/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.CategoryService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTCategoryService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.CategoryList;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTCategoryServiceImpl
extends RESTServiceImpl
implements RESTCategoryService {
    private static final Logger LOGGER = LogManager.getLogger(RESTCategoryServiceImpl.class);
    private CategoryService categoryService;

    public void setCategoryService(CategoryService categoryService) {
        this.categoryService = categoryService;
    }

    public long insert(SecurityContext sc, Category category) {
        if (category == null) {
            throw new BadRequestWebEx("Category is null");
        }
        if (category.getId() != null) {
            throw new BadRequestWebEx("Id should be null");
        }
        long id = -1L;
        try {
            id = this.categoryService.insert(category);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (BadRequestServiceEx e) {
            throw new BadRequestWebEx(e.getMessage());
        }
        return id;
    }

    public long update(SecurityContext sc, long id, Category category) {
        try {
            Category old = this.categoryService.get(id);
            if (old == null) {
                throw new NotFoundWebEx("Category not found");
            }
            boolean canUpdate = false;
            User authUser = this.extractAuthUser(sc);
            canUpdate = this.resourceAccessWrite(authUser, old.getId());
            if (!canUpdate) {
                throw new ForbiddenErrorWebEx("This user cannot update this category !");
            }
            id = this.categoryService.update(category);
        }
        catch (BadRequestServiceEx e) {
            throw new BadRequestWebEx(e.getMessage());
        }
        return id;
    }

    public void delete(SecurityContext sc, long id) throws NotFoundWebEx {
        boolean canDelete = false;
        User authUser = this.extractAuthUser(sc);
        canDelete = this.resourceAccessWrite(authUser, id);
        if (canDelete) {
            boolean ret = this.categoryService.delete(id);
            if (!ret) {
                throw new NotFoundWebEx("Category not found");
            }
        } else {
            throw new ForbiddenErrorWebEx("This user cannot delete this category !");
        }
    }

    public Category get(SecurityContext sc, long id) throws NotFoundWebEx {
        if (id == -1L) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retriving dummy data !");
            }
            Category category = new Category();
            category.setName("dummy name");
            return category;
        }
        Category ret = this.categoryService.get(id);
        if (ret == null) {
            throw new NotFoundWebEx("Category not found");
        }
        return ret;
    }

    public CategoryList getAll(SecurityContext sc, Integer page, Integer entries) throws BadRequestWebEx {
        try {
            return new CategoryList(this.categoryService.getAll(page, entries));
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
    }

    public long getCount(SecurityContext sc, String nameLike) {
        return this.categoryService.getCount(RESTCategoryServiceImpl.convertNameLikeToSqlSyntax(nameLike));
    }
}

