/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ResourcePermissionService;
import it.geosolutions.geostore.services.ResourcePermissionServiceImpl;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;

public class RESTServiceImplTest
extends ServiceTestBase {
    TESTRESTServiceImpl restService;
    TestSecurityService securityService;
    TestUserService userService;
    TestResourceService testResourceService;
    ResourcePermissionService resourcePermissionService;
    User user;
    UserGroup group;
    UserGroup everyone;

    private SecurityRule createSecurityRule(long id, User user, UserGroup group, boolean canRead, boolean canWrite) {
        SecurityRule sr = new SecurityRule();
        sr.setId(Long.valueOf(id));
        sr.setUser(user);
        sr.setGroup(group);
        sr.setCanRead(canRead);
        sr.setCanWrite(canWrite);
        return sr;
    }

    @Before
    public void setUp() {
        this.securityService = new TestSecurityService();
        this.restService = new TESTRESTServiceImpl();
        this.userService = new TestUserService();
        this.testResourceService = new TestResourceService();
        this.resourcePermissionService = new ResourcePermissionServiceImpl();
        this.restService.setSecurityService(this.securityService);
        this.restService.setUserService(this.userService);
        this.restService.setResourceService(this.testResourceService);
        this.restService.setResourcePermissionService(this.resourcePermissionService);
        this.user = new User();
        this.user.setName("TEST_USER");
        this.user.setId(Long.valueOf(100L));
        this.user.setRole(Role.USER);
        this.everyone = new UserGroup();
        this.everyone.setId(Long.valueOf(200L));
        this.everyone.setGroupName("everyone");
        this.group = new UserGroup();
        this.group.setGroupName("TEST_GROUP");
        this.group.setId(Long.valueOf(201L));
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        groups.add(this.everyone);
        groups.add(this.group);
        this.user.setGroups(groups);
        this.user.setGroups(groups);
    }

    @Test
    public void testRulesReadWrite() {
        Resource resource = new Resource();
        resource.setId(Long.valueOf(1L));
        this.testResourceService.resources = List.of(resource);
        SecurityRule groupSecurityReadWriteRule = this.createSecurityRule(1L, null, this.group, true, true);
        SecurityRule userSecurityReadRule = this.createSecurityRule(1L, this.user, null, true, false);
        resource.setSecurity(List.of(groupSecurityReadWriteRule, userSecurityReadRule));
        RESTServiceImplTest.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        RESTServiceImplTest.assertTrue((boolean)this.restService.resourceAccessWrite(this.user, 1L));
        SecurityRule groupSecurityReadRule = this.createSecurityRule(1L, null, this.group, true, false);
        SecurityRule userSecurityReadWriteRule = this.createSecurityRule(1L, this.user, null, true, true);
        resource.setSecurity(List.of(groupSecurityReadRule, userSecurityReadWriteRule));
        RESTServiceImplTest.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        RESTServiceImplTest.assertTrue((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testRulesReadOnly() {
        SecurityRule groupSecurityRule = this.createSecurityRule(1L, null, this.group, true, false);
        SecurityRule userSecurityRule = this.createSecurityRule(1L, this.user, null, true, false);
        Resource resource = new Resource();
        resource.setId(Long.valueOf(1L));
        resource.setSecurity(List.of(groupSecurityRule, userSecurityRule));
        this.testResourceService.resources = List.of(resource);
        RESTServiceImplTest.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        RESTServiceImplTest.assertFalse((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testRulesAccessDenied() {
        SecurityRule groupSecurityRule = this.createSecurityRule(1L, null, this.group, false, false);
        SecurityRule userSecurityRule = this.createSecurityRule(1L, this.user, null, false, false);
        Resource resource = new Resource();
        resource.setId(Long.valueOf(1L));
        resource.setSecurity(List.of(groupSecurityRule, userSecurityRule));
        this.testResourceService.resources = List.of(resource);
        RESTServiceImplTest.assertFalse((boolean)this.restService.resourceAccessRead(this.user, 1L));
        RESTServiceImplTest.assertFalse((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testIgnoreNotValidUserRules() {
        SecurityRule groupSecurityRule = this.createSecurityRule(1L, null, this.group, false, false);
        SecurityRule invalidSecurityRule = this.createSecurityRule(1L, null, this.group, true, false);
        SecurityRule userSecurityRule = this.createSecurityRule(1L, this.user, null, true, true);
        Resource resource = new Resource();
        resource.setId(Long.valueOf(1L));
        resource.setSecurity(List.of(groupSecurityRule, invalidSecurityRule, userSecurityRule));
        this.testResourceService.resources = List.of(resource);
        RESTServiceImplTest.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        RESTServiceImplTest.assertTrue((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testGuestHasEveryoneGroup() {
        Principal principal = this.restService.createGuestPrincipal();
        RESTServiceImplTest.assertTrue((boolean)(principal instanceof UsernamePasswordAuthenticationToken));
        UsernamePasswordAuthenticationToken userPrincipal = (UsernamePasswordAuthenticationToken)principal;
        RESTServiceImplTest.assertTrue((boolean)(userPrincipal.getPrincipal() instanceof User));
        User user = (User)userPrincipal.getPrincipal();
        RESTServiceImplTest.assertEquals((int)1, (int)user.getGroups().size());
        RESTServiceImplTest.assertEquals((String)GroupReservedNames.EVERYONE.groupName(), (String)((UserGroup)user.getGroups().iterator().next()).getGroupName());
    }

    public void testExtractUserIp() {
        String remoteIP = "4.88.132.112";
        this.mockHttpRequestIpAddressAttribute(remoteIP, List.of(), "");
        String ipAddress = this.restService.extractAuthUser((SecurityContext)new ServiceTestBase.SimpleSecurityContext(this.user)).getIpAddress();
        RESTServiceImplTest.assertEquals((String)remoteIP, (String)ipAddress);
    }

    public void testExtractUserIpWhenForwarded() {
        String forwardedIP = "12.12.12.12";
        this.mockHttpRequestIpAddressAttribute("localhost", List.of(forwardedIP), "");
        String ipAddress = this.restService.extractAuthUser((SecurityContext)new ServiceTestBase.SimpleSecurityContext(this.user)).getIpAddress();
        RESTServiceImplTest.assertEquals((String)forwardedIP, (String)ipAddress);
    }

    public void testExtractUserIpWhenForwardedMultipleTimes() {
        String forwardedIPA = "152.221.232.124";
        String forwardedIPB = "54.36.51.65";
        this.mockHttpRequestIpAddressAttribute("localhost", List.of(forwardedIPA, forwardedIPB), "");
        String ipAddress = this.restService.extractAuthUser((SecurityContext)new ServiceTestBase.SimpleSecurityContext(this.user)).getIpAddress();
        RESTServiceImplTest.assertEquals((String)forwardedIPA, (String)ipAddress);
    }

    public void testExtractUserIpWhenForwardedWithRealIP() {
        String realIP = "112.112.112.1";
        this.mockHttpRequestIpAddressAttribute("localhost", List.of(), realIP);
        String ipAddress = this.restService.extractAuthUser((SecurityContext)new ServiceTestBase.SimpleSecurityContext(this.user)).getIpAddress();
        RESTServiceImplTest.assertEquals((String)realIP, (String)ipAddress);
    }

    public void testExtractUserIpPrecedence() {
        String ipA = "76.41.15.54";
        String ipB = "12.6.0.3";
        String ipC = "1922.12.45.5";
        this.mockHttpRequestIpAddressAttribute(ipA, List.of(ipB), ipC);
        String ipAddress = this.restService.extractAuthUser((SecurityContext)new ServiceTestBase.SimpleSecurityContext(this.user)).getIpAddress();
        RESTServiceImplTest.assertEquals((String)ipB, (String)ipAddress);
    }

    private static class TESTRESTServiceImpl
    extends RESTServiceImpl {
        private SecurityService securityService = null;

        private TESTRESTServiceImpl() {
        }

        public void setSecurityService(SecurityService s) {
            this.securityService = s;
        }
    }

    private static class TestResourceService
    implements ResourceService {
        List<Resource> resources = new ArrayList<Resource>();

        private TestResourceService() {
        }

        public long insert(Resource resource) throws BadRequestServiceEx, NotFoundServiceEx, DuplicatedResourceNameServiceEx {
            return 0L;
        }

        public long update(Resource resource) throws NotFoundServiceEx, DuplicatedResourceNameServiceEx {
            return 0L;
        }

        public boolean delete(long id) {
            return false;
        }

        public void deleteResources(SearchFilter filter) throws BadRequestServiceEx, InternalErrorServiceEx {
        }

        public Resource get(long id) {
            return null;
        }

        public Resource getResource(long id, boolean includeAttributes, boolean includePermissions, boolean includeTags) {
            return this.resources.stream().filter(r -> r.getId().equals(id)).findFirst().orElseThrow();
        }

        public List<ShortResource> getList(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
            return List.of();
        }

        public List<ShortResource> getAll(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
            return List.of();
        }

        public long getCount(String nameLike) {
            return 0L;
        }

        public long getCountByFilter(SearchFilter filter) throws InternalErrorServiceEx, BadRequestServiceEx {
            return 0L;
        }

        public void updateAttributes(long id, List<Attribute> attributes) throws NotFoundServiceEx {
        }

        public List<ShortAttribute> getAttributes(long id) {
            return List.of();
        }

        public ShortAttribute getAttribute(long id, String name) {
            return null;
        }

        public long updateAttribute(long id, String name, String value) throws InternalErrorServiceEx {
            return 0L;
        }

        public List<Resource> getResources(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
            return List.of();
        }

        public List<ShortResource> getShortResources(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
            return List.of();
        }

        public List<Resource> getResourcesFull(ResourceSearchParameters resourceSearchParameters) throws BadRequestServiceEx, InternalErrorServiceEx {
            return List.of();
        }

        public List<SecurityRule> getSecurityRules(long id) {
            return List.of();
        }

        public void updateSecurityRules(long id, List<SecurityRule> rules) throws BadRequestServiceEx, InternalErrorServiceEx, NotFoundServiceEx {
        }

        public long count(SearchFilter filter, User user) throws BadRequestServiceEx, InternalErrorServiceEx {
            return 0L;
        }

        public long count(SearchFilter filter, User user, boolean favoritesOnly) throws BadRequestServiceEx, InternalErrorServiceEx {
            return 0L;
        }

        public long count(String nameLike, User user) throws BadRequestServiceEx {
            return 0L;
        }

        public long insertAttribute(long id, String name, String value, DataType type) throws InternalErrorServiceEx {
            return 0L;
        }

        public List<SecurityRule> getUserSecurityRule(String userName, long entityId) {
            return List.of();
        }

        public List<SecurityRule> getGroupSecurityRule(List<String> groupNames, long entityId) {
            return List.of();
        }
    }

    private static class TestSecurityService
    implements SecurityService {
        private List<SecurityRule> userSecurityRules = null;
        private List<SecurityRule> groupSecurityRules = null;

        private TestSecurityService() {
        }

        public void setUserSecurityRules(List<SecurityRule> userSecurityRules) {
            this.userSecurityRules = userSecurityRules;
        }

        public void setGroupSecurityRules(List<SecurityRule> groupSecurityRules) {
            this.groupSecurityRules = groupSecurityRules;
        }

        public List<SecurityRule> getUserSecurityRule(String userName, long entityId) {
            return this.userSecurityRules;
        }

        public List<SecurityRule> getGroupSecurityRule(List<String> groupNames, long entityId) {
            return this.groupSecurityRules;
        }
    }

    private static class TestUserService
    implements UserService {
        private TestUserService() {
        }

        public long insert(User user) throws BadRequestServiceEx, NotFoundServiceEx {
            return 0L;
        }

        public long update(User user) throws NotFoundServiceEx, BadRequestServiceEx {
            return 0L;
        }

        public boolean delete(long id) {
            return false;
        }

        public User get(long id) {
            return null;
        }

        public User get(String name) throws NotFoundServiceEx {
            throw new NotFoundServiceEx(name);
        }

        public List<User> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
            return null;
        }

        public List<User> getAll(Integer page, Integer entries, String nameLike, boolean includeAttributes) throws BadRequestServiceEx {
            return null;
        }

        public long getCount(String nameLike) {
            return 0L;
        }

        public void updateAttributes(long id, List<UserAttribute> attributes) throws NotFoundServiceEx {
        }

        public boolean insertSpecialUsers() {
            return false;
        }

        public Collection<User> getByAttribute(UserAttribute attribute) {
            return null;
        }

        public Collection<User> getByGroup(UserGroup group) {
            return null;
        }
    }
}

