/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.IPRange;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTResourceServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTAttribute;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.utils.MockSecurityContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.jupiter.api.Assertions;
import org.springframework.web.context.request.RequestContextHolder;

public class RESTResourceServiceImplTest
extends ServiceTestBase {
    RESTResourceServiceImpl restService;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.restService = new RESTResourceServiceImpl();
        this.restService.setResourceService(resourceService);
        this.restService.setResourcePermissionService(resourcePermissionService);
        this.mockHttpRequestIpAddressAttribute();
    }

    @After
    public void cleanup() {
        RequestContextHolder.resetRequestAttributes();
    }

    @Test
    public void testUpdateResource_editorUpdate() throws Exception {
        long u0ID = this.createUser("u0", Role.USER, "p0");
        User user = new User();
        user.setId(Long.valueOf(u0ID));
        user.setName("u0");
        ArrayList<SecurityRule> rules = new ArrayList<SecurityRule>();
        SecurityRule rule = new SecurityRule();
        rule.setUser(user);
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rules.add(rule);
        long groupId = this.createGroup("group1");
        UserGroup group = new UserGroup();
        group.setId(Long.valueOf(groupId));
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        rule.setGroup(group);
        rules.add(rule);
        long resourceId = this.createResource("name1", "description1", "MAP", rules);
        MockSecurityContext sc = new MockSecurityContext(userService.get(u0ID));
        RESTAttribute restAttribute = new RESTAttribute();
        String NAME = "NAME";
        String VALUE = "VALUE";
        restAttribute.setName(NAME);
        restAttribute.setValue(VALUE);
        this.restService.updateAttribute((SecurityContext)sc, resourceId, restAttribute);
        Resource sr = this.restService.get((SecurityContext)sc, resourceId, false);
        Attribute attribute = (Attribute)sr.getAttribute().get(0);
        RESTResourceServiceImplTest.assertEquals((String)attribute.getName(), (String)NAME);
        RESTResourceServiceImplTest.assertEquals((String)attribute.getValue(), (String)VALUE);
        RESTResourceServiceImplTest.assertEquals((Object)attribute.getType(), (Object)DataType.STRING);
        RESTResourceServiceImplTest.assertEquals((String)sr.getCreator(), (String)"u0");
        RESTResourceServiceImplTest.assertEquals((String)sr.getEditor(), (String)"u0");
        long u1ID = this.createUser("u1", Role.USER, "p1", groupId);
        user = new User();
        user.setId(Long.valueOf(u1ID));
        user.setName("u1");
        sc = new MockSecurityContext(userService.get(u1ID));
        restAttribute = new RESTAttribute();
        NAME = "NAME";
        VALUE = "VALUE1";
        restAttribute.setName(NAME);
        restAttribute.setValue(VALUE);
        this.restService.updateAttribute((SecurityContext)sc, resourceId, restAttribute);
        sr = this.restService.get((SecurityContext)sc, resourceId, false);
        attribute = (Attribute)sr.getAttribute().get(0);
        RESTResourceServiceImplTest.assertEquals((String)attribute.getName(), (String)NAME);
        RESTResourceServiceImplTest.assertEquals((String)attribute.getValue(), (String)VALUE);
        RESTResourceServiceImplTest.assertEquals((Object)attribute.getType(), (Object)DataType.STRING);
        RESTResourceServiceImplTest.assertEquals((String)sr.getCreator(), (String)"u0");
        RESTResourceServiceImplTest.assertEquals((String)sr.getEditor(), (String)"u1");
    }

    @Test
    public void testUpdateResourceSecurityRules_withoutPermissions() throws Exception {
        long resourceId = this.createResource("name1", "description1", "MAP");
        long userId = this.createUser("user", Role.USER, "user");
        MockSecurityContext sc = new MockSecurityContext(userService.get(userId));
        SecurityRule securityRule = new ServiceTestBase.SecurityRuleBuilder().build();
        Assertions.assertThrows(ForbiddenErrorWebEx.class, () -> this.restService.updateSecurityRules(sc, resourceId, new SecurityRuleList(List.of(securityRule))));
    }

    @Test
    public void testUpdateResource_ipRangeUpdate() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange ipRange = new IPRange();
        ipRange.setCidr("192.168.1.1/24");
        ipRange.setDescription("range");
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(ipRange)).build()));
        this.restService.updateSecurityRules((SecurityContext)sc, resourceId, securityRulelist);
        List securityRules = resourceService.getSecurityRules(resourceId);
        RESTResourceServiceImplTest.assertEquals((int)1, (int)securityRules.size());
        Set ipRanges = ((SecurityRule)securityRules.get(0)).getIpRanges();
        RESTResourceServiceImplTest.assertEquals((int)1, (int)ipRanges.size());
        IPRange savedIpRange = (IPRange)new ArrayList(ipRanges).get(0);
        RESTResourceServiceImplTest.assertEquals((String)ipRange.getCidr(), (String)savedIpRange.getCidr());
        RESTResourceServiceImplTest.assertEquals((String)ipRange.getDescription(), (String)savedIpRange.getDescription());
    }

    @Test
    public void testUpdateResource_ipRangeUpdateWithInvalidCidrFormat() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange invalidIPRange = new IPRange();
        invalidIPRange.setCidr("1.1.1.1");
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(invalidIPRange)).build()));
        BadRequestWebEx badRequestWebEx = (BadRequestWebEx)Assertions.assertThrows(BadRequestWebEx.class, () -> this.restService.updateSecurityRules(sc, resourceId, securityRulelist));
        RESTResourceServiceImplTest.assertTrue((boolean)badRequestWebEx.getMessage().contains("Invalid CIDR format"));
    }

    @Test
    public void testUpdateResource_ipRangeUpdateWithInvalidCidr() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange invalidIPRange = new IPRange();
        invalidIPRange.setCidr("a.0.b.1.xx/s");
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(invalidIPRange)).build()));
        BadRequestWebEx badRequestWebEx = (BadRequestWebEx)Assertions.assertThrows(BadRequestWebEx.class, () -> this.restService.updateSecurityRules(sc, resourceId, securityRulelist));
        RESTResourceServiceImplTest.assertTrue((boolean)badRequestWebEx.getMessage().contains("Malformed IP address"));
    }

    @Test
    public void testUpdateResource_ipRangeUpdateWithMissingPrefix() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange invalidIPRange = new IPRange();
        invalidIPRange.setCidr("192.165.1.5/");
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(invalidIPRange)).build()));
        BadRequestWebEx badRequestWebEx = (BadRequestWebEx)Assertions.assertThrows(BadRequestWebEx.class, () -> this.restService.updateSecurityRules(sc, resourceId, securityRulelist));
        RESTResourceServiceImplTest.assertTrue((boolean)badRequestWebEx.getMessage().contains("Invalid CIDR format"));
    }

    @Test
    public void testUpdateResource_ipRangeUpdateWithInvalidIP() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange invalidIPRange = new IPRange();
        invalidIPRange.setCidr("666.555.444.333/222");
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(invalidIPRange)).build()));
        BadRequestWebEx badRequestWebEx = (BadRequestWebEx)Assertions.assertThrows(BadRequestWebEx.class, () -> this.restService.updateSecurityRules(sc, resourceId, securityRulelist));
        RESTResourceServiceImplTest.assertTrue((boolean)badRequestWebEx.getMessage().contains(invalidIPRange.getCidr() + " IP Address error"));
    }

    @Test
    public void testUpdateResource_ipRangeUpdateWithInvalidCidrPrefix() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange invalidIPRange = new IPRange();
        invalidIPRange.setCidr("1.1.1.1/555");
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(invalidIPRange)).build()));
        BadRequestWebEx badRequestWebEx = (BadRequestWebEx)Assertions.assertThrows(BadRequestWebEx.class, () -> this.restService.updateSecurityRules(sc, resourceId, securityRulelist));
        RESTResourceServiceImplTest.assertTrue((boolean)badRequestWebEx.getMessage().contains(invalidIPRange.getCidr() + " IP Address error"));
    }

    @Test
    public void testUpdateResource_ipRangeUpdateSanitizingInput() throws Exception {
        long adminId = this.createUser("user", Role.ADMIN, "user");
        long resourceId = this.createResource("name1", "description1", "MAP");
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminId));
        IPRange ipRange = new IPRange();
        ipRange.setCidr("008.08.8.80/0");
        ipRange.setDescription("sanitize");
        SecurityRuleList securityRulelist = new SecurityRuleList(List.of(new ServiceTestBase.SecurityRuleBuilder().ipRanges(Set.of(ipRange)).build()));
        this.restService.updateSecurityRules((SecurityContext)sc, resourceId, securityRulelist);
        List securityRules = resourceService.getSecurityRules(resourceId);
        RESTResourceServiceImplTest.assertEquals((int)1, (int)securityRules.size());
        Set ipRanges = ((SecurityRule)securityRules.get(0)).getIpRanges();
        RESTResourceServiceImplTest.assertEquals((int)1, (int)ipRanges.size());
        IPRange savedIpRange = (IPRange)new ArrayList(ipRanges).get(0);
        RESTResourceServiceImplTest.assertEquals((String)"8.8.8.80/0", (String)savedIpRange.getCidr());
        RESTResourceServiceImplTest.assertEquals((String)ipRange.getDescription(), (String)savedIpRange.getDescription());
    }
}

