/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.services.rest.IdPLoginRest;
import it.geosolutions.geostore.services.rest.IdPLoginService;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakTokenDetails;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.Oauth2LoginService;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.web.context.request.RequestContextHolder;

public class KeyCloakLoginService
extends Oauth2LoginService {
    private static final Logger LOGGER = LogManager.getLogger(KeyCloakLoginService.class);
    static String KEYCLOAK_REDIRECT = "KEYCLOAK_REDIRECT";

    public KeyCloakLoginService(IdPLoginRest loginRest) {
        loginRest.registerService("keycloak", (IdPLoginService)this);
    }

    @Override
    public void doLogin(HttpServletRequest request, HttpServletResponse response, String provider) {
        KeycloakTokenDetails details = this.getDetails();
        boolean attempInternalRedirect = details != null && details.getAccessToken() != null;
        AuthenticationEntryPoint challenge = (AuthenticationEntryPoint)Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getAttribute(KEYCLOAK_REDIRECT, 0);
        if (challenge == null) {
            attempInternalRedirect = true;
        } else if (!attempInternalRedirect) {
            try {
                challenge.commence(request, response, null);
                attempInternalRedirect = false;
            }
            catch (Exception e) {
                LOGGER.error("Error while redirecting to Keycloak authorization.", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        if (attempInternalRedirect) {
            try {
                response.sendRedirect(this.configuration(provider).getInternalRedirectUri());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Response doInternalRedirect(HttpServletRequest request, HttpServletResponse response, String provider) {
        String refreshToken;
        String token;
        KeycloakTokenDetails details = this.getDetails();
        if (details != null) {
            token = details.getAccessToken();
            refreshToken = details.getRefreshToken();
        } else {
            token = OAuth2Utils.getAccessToken();
            refreshToken = OAuth2Utils.getRefreshAccessToken();
        }
        return this.buildCallbackResponse(response, token, refreshToken, provider);
    }

    private KeycloakTokenDetails getDetails() {
        KeycloakTokenDetails result = null;
        Authentication auth = SecurityContextHolder.getContext().getAuthentication();
        if (auth != null && auth.getDetails() instanceof KeycloakTokenDetails) {
            result = (KeycloakTokenDetails)auth.getDetails();
        }
        return result;
    }
}

