/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.oauth2;

import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.common.ConsoleNotifier;
import com.github.tomakehurst.wiremock.common.Notifier;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import it.geosolutions.geostore.services.rest.security.oauth2.DiscoveryClient;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class DiscoveryClientTest {
    private static WireMockServer openIdService;
    private static String authService;

    @BeforeClass
    public static void beforeClass() throws Exception {
        openIdService = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort().notifier((Notifier)new ConsoleNotifier(true)));
        openIdService.start();
        openIdService.stubFor(WireMock.any((UrlPattern)WireMock.urlEqualTo((String)"/.well-known/openid-configuration")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("discovery_result.json")));
        authService = "http://localhost:" + openIdService.port();
    }

    @Test
    public void testDiscovery() {
        DiscoveryClient discoveryClient = new DiscoveryClient(authService + "/.well-known/openid-configuration");
        OAuth2Configuration configuration = new OAuth2Configuration();
        configuration.setScopes("openid,groups");
        discoveryClient.autofill(configuration);
        Assert.assertEquals((Object)"https://oauth2.googleapis.com/token", (Object)configuration.getAccessTokenUri());
        Assert.assertEquals((Object)"https://accounts.google.com/o/oauth2/v2/auth", (Object)configuration.getAuthorizationUri());
        Assert.assertEquals((Object)"https://oauth2.googleapis.com/revoke", (Object)configuration.getRevokeEndpoint());
        Assert.assertEquals((Object)"https://openidconnect.googleapis.com/v1/userinfo", (Object)configuration.getCheckTokenEndpointUrl());
        Assert.assertEquals((Object)"https://www.googleapis.com/oauth2/v3/certs", (Object)configuration.getIdTokenUri());
        Object[] expectedScopes = "openid,groups".split(",");
        Object[] actualScopes = configuration.getScopes().split(",");
        Arrays.sort(expectedScopes);
        Arrays.sort(actualScopes);
        Assert.assertArrayEquals((String)"The scopes match", (Object[])expectedScopes, (Object[])actualScopes);
    }
}

