/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import java.util.Collections;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2Configuration
extends IdPConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(OAuth2Configuration.class);
    public static final String CONFIG_NAME_SUFFIX = "OAuth2Config";
    public static final String CONFIGURATION_NAME = "CONFIGURATION_NAME";
    private String clientId;
    private String clientSecret;
    private String accessTokenUri;
    private String authorizationUri;
    private String checkTokenEndpointUrl;
    private String logoutUri;
    private String revokeEndpoint;
    private boolean globalLogoutEnabled = false;
    private String scopes;
    private String idTokenUri;
    private String discoveryUrl;
    private boolean enableRedirectEntryPoint = false;
    private String principalKey;
    private String uniqueUsername;
    private String rolesClaim;
    private String groupsClaim;
    private boolean groupNamesUppercase = false;
    private long initialBackoffDelay = 1000L;
    private double backoffMultiplier = 2.0;
    private int maxRetries = 3;

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public void setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
    }

    public long getInitialBackoffDelay() {
        return this.initialBackoffDelay;
    }

    public void setInitialBackoffDelay(long initialBackoffDelay) {
        this.initialBackoffDelay = initialBackoffDelay;
    }

    public double getBackoffMultiplier() {
        return this.backoffMultiplier;
    }

    public void setBackoffMultiplier(double backoffMultiplier) {
        this.backoffMultiplier = backoffMultiplier;
    }

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return (request, response, authException) -> {
            String loginUri = this.buildLoginUri();
            response.sendRedirect(loginUri);
        };
    }

    public String buildLoginUri() {
        return this.buildLoginUri(null, new String[0]);
    }

    public String buildLoginUri(String accessType) {
        return this.buildLoginUri(accessType, new String[0]);
    }

    public String buildLoginUri(String accessType, String ... additionalScopes) {
        StringBuilder loginUri = new StringBuilder(this.getAuthorizationUri());
        loginUri.append("?response_type=code").append("&client_id=").append(this.getClientId()).append("&scope=").append(this.getScopes().replace(",", "%20"));
        for (String scope : additionalScopes) {
            loginUri.append("%20").append(scope);
        }
        loginUri.append("&redirect_uri=").append(this.getRedirectUri());
        if (accessType != null) {
            loginUri.append("&access_type=").append(accessType);
        }
        LOGGER.debug("Authorization endpoint URI built: {}", (Object)loginUri);
        return loginUri.toString();
    }

    public String buildRefreshTokenURI() {
        return this.buildRefreshTokenURI(null);
    }

    public String buildRefreshTokenURI(String accessType) {
        StringBuilder refreshUri = new StringBuilder(this.getAccessTokenUri()).append("?client_id=").append(this.getClientId()).append("&scope=").append(this.getScopes().replace(",", "%20"));
        if (accessType != null) {
            refreshUri.append("&access_type=").append(accessType);
        }
        return refreshUri.toString();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String cliendId) {
        this.clientId = cliendId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    public String getCheckTokenEndpointUrl() {
        return this.checkTokenEndpointUrl;
    }

    public void setCheckTokenEndpointUrl(String checkTokenEndpointUrl) {
        this.checkTokenEndpointUrl = checkTokenEndpointUrl;
    }

    public String getLogoutUri() {
        return this.logoutUri;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }

    public boolean isGlobalLogoutEnabled() {
        return this.globalLogoutEnabled;
    }

    public void setGlobalLogoutEnabled(boolean globalLogoutEnabled) {
        this.globalLogoutEnabled = globalLogoutEnabled;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getIdTokenUri() {
        return this.idTokenUri;
    }

    public void setIdTokenUri(String idTokenUri) {
        this.idTokenUri = idTokenUri;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public void setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public boolean isInvalid() {
        return this.clientId == null || this.clientSecret == null || this.authorizationUri == null || this.accessTokenUri == null;
    }

    public String getRevokeEndpoint() {
        return this.revokeEndpoint;
    }

    public void setRevokeEndpoint(String revokeEndpoint) {
        this.revokeEndpoint = revokeEndpoint;
    }

    public String getProvider() {
        return this.getBeanName().replaceAll(CONFIG_NAME_SUFFIX, "");
    }

    protected String appendParameters(MultiValueMap<String, String> params, String url) {
        return UriComponentsBuilder.fromHttpUrl((String)url).queryParams(params).build().toUriString();
    }

    protected static void getLogoutRequestParams(String token, String clientId, MultiValueMap<String, String> params) {
        params.put((Object)"token", Collections.singletonList(token));
        if (clientId != null && !clientId.isEmpty()) {
            params.put((Object)"client_id", Collections.singletonList(clientId));
        }
    }

    public Endpoint buildRevokeEndpoint(String token, String accessToken, OAuth2Configuration configuration) {
        if (this.revokeEndpoint == null) {
            return null;
        }
        HttpHeaders headers = OAuth2Configuration.getHttpHeaders(accessToken, configuration);
        LinkedMultiValueMap bodyParams = new LinkedMultiValueMap();
        bodyParams.add((Object)"token", (Object)token);
        bodyParams.add((Object)"client_id", (Object)this.clientId);
        HttpEntity requestEntity = new HttpEntity((Object)bodyParams, (MultiValueMap)headers);
        return new Endpoint(HttpMethod.POST, this.revokeEndpoint, requestEntity);
    }

    private static HttpHeaders getHttpHeaders(String accessToken, OAuth2Configuration configuration) {
        HttpHeaders headers = OAuth2Configuration.getHeaders(accessToken, configuration);
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    public Endpoint buildLogoutEndpoint(String token, String accessToken, OAuth2Configuration configuration) {
        if (this.logoutUri == null) {
            return null;
        }
        HttpHeaders headers = OAuth2Configuration.getHeaders(accessToken, configuration);
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        OAuth2Configuration.getLogoutRequestParams(token, this.clientId, (MultiValueMap<String, String>)params);
        return new Endpoint(HttpMethod.GET, this.appendParameters((MultiValueMap<String, String>)params, this.logoutUri), new HttpEntity((MultiValueMap)headers));
    }

    private static HttpHeaders getHeaders(String accessToken, OAuth2Configuration configuration) {
        HttpHeaders headers = new HttpHeaders();
        if (configuration != null && configuration.clientId != null && configuration.clientSecret != null) {
            headers.setBasicAuth(configuration.clientId, configuration.clientSecret);
        } else if (accessToken != null && !accessToken.isEmpty()) {
            headers.set("Authorization", "Bearer " + accessToken);
        }
        return headers;
    }

    public boolean isEnableRedirectEntryPoint() {
        return this.enableRedirectEntryPoint;
    }

    public void setEnableRedirectEntryPoint(boolean enableRedirectEntryPoint) {
        this.enableRedirectEntryPoint = enableRedirectEntryPoint;
    }

    public String getPrincipalKey() {
        if (this.principalKey == null || this.principalKey.isEmpty()) {
            return "email";
        }
        return this.principalKey;
    }

    public void setPrincipalKey(String principalKey) {
        this.principalKey = principalKey;
    }

    public String getUniqueUsername() {
        return this.uniqueUsername;
    }

    public void setUniqueUsername(String uniqueUsername) {
        this.uniqueUsername = uniqueUsername;
    }

    public String getRolesClaim() {
        return this.rolesClaim;
    }

    public void setRolesClaim(String rolesClaim) {
        this.rolesClaim = rolesClaim;
    }

    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    public boolean isGroupNamesUppercase() {
        return this.groupNamesUppercase;
    }

    public void setGroupNamesUppercase(boolean groupNamesUppercase) {
        this.groupNamesUppercase = groupNamesUppercase;
    }

    public boolean equals(Object o) {
        if (!(o instanceof OAuth2Configuration)) {
            return false;
        }
        OAuth2Configuration that = (OAuth2Configuration)o;
        return this.isGlobalLogoutEnabled() == that.isGlobalLogoutEnabled() && this.isEnableRedirectEntryPoint() == that.isEnableRedirectEntryPoint() && this.isGroupNamesUppercase() == that.isGroupNamesUppercase() && this.getInitialBackoffDelay() == that.getInitialBackoffDelay() && Double.compare(this.getBackoffMultiplier(), that.getBackoffMultiplier()) == 0 && this.getMaxRetries() == that.getMaxRetries() && Objects.equals(this.getClientId(), that.getClientId()) && Objects.equals(this.getClientSecret(), that.getClientSecret()) && Objects.equals(this.getAccessTokenUri(), that.getAccessTokenUri()) && Objects.equals(this.getAuthorizationUri(), that.getAuthorizationUri()) && Objects.equals(this.getCheckTokenEndpointUrl(), that.getCheckTokenEndpointUrl()) && Objects.equals(this.getLogoutUri(), that.getLogoutUri()) && Objects.equals(this.getRevokeEndpoint(), that.getRevokeEndpoint()) && Objects.equals(this.getScopes(), that.getScopes()) && Objects.equals(this.getIdTokenUri(), that.getIdTokenUri()) && Objects.equals(this.getDiscoveryUrl(), that.getDiscoveryUrl()) && Objects.equals(this.getPrincipalKey(), that.getPrincipalKey()) && Objects.equals(this.getUniqueUsername(), that.getUniqueUsername()) && Objects.equals(this.getRolesClaim(), that.getRolesClaim()) && Objects.equals(this.getGroupsClaim(), that.getGroupsClaim());
    }

    public int hashCode() {
        return Objects.hash(this.getClientId(), this.getClientSecret(), this.getAccessTokenUri(), this.getAuthorizationUri(), this.getCheckTokenEndpointUrl(), this.getLogoutUri(), this.getRevokeEndpoint(), this.isGlobalLogoutEnabled(), this.getScopes(), this.getIdTokenUri(), this.getDiscoveryUrl(), this.isEnableRedirectEntryPoint(), this.getPrincipalKey(), this.getUniqueUsername(), this.getRolesClaim(), this.getGroupsClaim(), this.isGroupNamesUppercase(), this.getInitialBackoffDelay(), this.getBackoffMultiplier(), this.getMaxRetries());
    }

    public String toString() {
        return "OAuth2Configuration{clientId='" + this.clientId + "', clientSecret='" + this.clientSecret + "', accessTokenUri='" + this.accessTokenUri + "', authorizationUri='" + this.authorizationUri + "', checkTokenEndpointUrl='" + this.checkTokenEndpointUrl + "', logoutUri='" + this.logoutUri + "', revokeEndpoint='" + this.revokeEndpoint + "', globalLogoutEnabled=" + this.globalLogoutEnabled + ", scopes='" + this.scopes + "', idTokenUri='" + this.idTokenUri + "', discoveryUrl='" + this.discoveryUrl + "', enableRedirectEntryPoint=" + this.enableRedirectEntryPoint + ", principalKey='" + this.principalKey + "', uniqueUsername='" + this.uniqueUsername + "', rolesClaim='" + this.rolesClaim + "', groupsClaim='" + this.groupsClaim + "', groupNamesUppercase=" + this.groupNamesUppercase + ", initialBackoffDelay=" + this.initialBackoffDelay + ", backoffMultiplier=" + this.backoffMultiplier + ", maxRetries=" + this.maxRetries + "}";
    }

    public static class Endpoint {
        private final String url;
        private final HttpMethod method;
        private final HttpEntity<?> requestEntity;

        public Endpoint(HttpMethod method, String url, HttpEntity<?> requestEntity) {
            this.method = method;
            this.url = url;
            this.requestEntity = requestEntity;
        }

        public String getUrl() {
            return this.url;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public HttpEntity<?> getRequestEntity() {
            return this.requestEntity;
        }
    }
}

