/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import it.geosolutions.geostore.services.rest.security.GeoStoreAuthenticationFilter;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class TokenAuthenticationFilter
extends GeoStoreAuthenticationFilter {
    private static final Logger LOGGER = LogManager.getLogger(TokenAuthenticationFilter.class);
    protected LoadingCache<String, Optional<Authentication>> cache;
    private String tokenHeader = "Authorization";
    private String tokenPrefix = "Bearer ";
    private int cacheSize = 1000;
    private int cacheExpiration = 60;

    public void setTokenHeader(String tokenHeader) {
        this.tokenHeader = tokenHeader;
    }

    public void setTokenPrefix(String tokenPrefix) {
        this.tokenPrefix = tokenPrefix;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public void setCacheExpiration(int cacheExpiration) {
        this.cacheExpiration = cacheExpiration;
    }

    protected LoadingCache<String, Optional<Authentication>> getCache() {
        if (this.cache == null) {
            this.cache = CacheBuilder.newBuilder().maximumSize((long)this.cacheSize).refreshAfterWrite((long)this.cacheExpiration, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Optional<Authentication>>(){

                public Optional<Authentication> load(String token) {
                    return Optional.fromNullable((Object)TokenAuthenticationFilter.this.checkToken(token));
                }
            });
        }
        return this.cache;
    }

    public void setCache(LoadingCache<String, Optional<Authentication>> cache) {
        this.cache = cache;
    }

    @Override
    protected void authenticate(HttpServletRequest req) {
        String authHeader = req.getHeader(this.tokenHeader);
        if (authHeader != null && authHeader.trim().toUpperCase().startsWith(this.tokenPrefix.toUpperCase())) {
            String token = authHeader.substring(this.tokenPrefix.length()).trim();
            try {
                Authentication auth = (Authentication)((Optional)this.getCache().get((Object)token)).orNull();
                if (auth != null) {
                    LOGGER.info("User authenticated using token: " + auth.getName());
                    SecurityContextHolder.getContext().setAuthentication(auth);
                }
            }
            catch (ExecutionException e) {
                LOGGER.error("Error authenticating token", (Throwable)e);
            }
        }
    }

    protected abstract Authentication checkToken(String var1);
}

