/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.service.impl;

import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;

public class RESTServiceImplTest {
    TESTRESTServiceImpl restService;
    TestSecurityService securityService;
    TestUserService userService;
    User user;
    UserGroup group;
    UserGroup everyone;
    UserGroup extGroup;

    private SecurityRule createSecurityRule(long id, User user, UserGroup group, boolean canRead, boolean canWrite) {
        SecurityRule sr = new SecurityRule();
        sr.setId(Long.valueOf(id));
        sr.setUser(user);
        sr.setGroup(group);
        sr.setCanRead(canRead);
        sr.setCanWrite(canWrite);
        return sr;
    }

    @Before
    public void setUp() {
        this.restService = new TESTRESTServiceImpl();
        this.securityService = new TestSecurityService();
        this.userService = new TestUserService();
        this.restService.setSecurityService(this.securityService);
        this.restService.setUserService(this.userService);
        this.user = new User();
        this.user.setName("TEST_USER");
        this.user.setId(Long.valueOf(100L));
        this.user.setRole(Role.USER);
        this.everyone = new UserGroup();
        this.everyone.setId(Long.valueOf(200L));
        this.everyone.setGroupName("everyone");
        this.group = new UserGroup();
        this.group.setGroupName("TEST_GROUP");
        this.group.setId(Long.valueOf(201L));
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        groups.add(this.everyone);
        groups.add(this.group);
        this.user.setGroups(groups);
        this.user.setGroups(groups);
    }

    @Test
    public void testRulesReadWrite() {
        ArrayList<Object> groupSecurityRules = new ArrayList<SecurityRule>();
        groupSecurityRules.add(this.createSecurityRule(1L, null, this.group, true, true));
        ArrayList<Object> userSecurityRules = new ArrayList<SecurityRule>();
        userSecurityRules.add(this.createSecurityRule(1L, this.user, null, true, false));
        this.securityService.setGroupSecurityRules(groupSecurityRules);
        this.securityService.setUserSecurityRules(userSecurityRules);
        Assert.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        Assert.assertTrue((boolean)this.restService.resourceAccessWrite(this.user, 1L));
        groupSecurityRules = new ArrayList();
        groupSecurityRules.add(this.createSecurityRule(1L, null, this.group, true, false));
        userSecurityRules = new ArrayList();
        userSecurityRules.add(this.createSecurityRule(1L, this.user, null, true, true));
        this.securityService.setGroupSecurityRules(groupSecurityRules);
        this.securityService.setUserSecurityRules(userSecurityRules);
        Assert.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        Assert.assertTrue((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testRulesReadOnly() {
        ArrayList<SecurityRule> groupSecurityRules = new ArrayList<SecurityRule>();
        groupSecurityRules.add(this.createSecurityRule(1L, null, this.group, true, false));
        ArrayList<SecurityRule> userSecurityRules = new ArrayList<SecurityRule>();
        userSecurityRules.add(this.createSecurityRule(1L, this.user, null, true, false));
        this.securityService.setGroupSecurityRules(groupSecurityRules);
        this.securityService.setUserSecurityRules(userSecurityRules);
        Assert.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        Assert.assertFalse((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testRulesAccessDenied() {
        ArrayList<SecurityRule> groupSecurityRules = new ArrayList<SecurityRule>();
        groupSecurityRules.add(this.createSecurityRule(1L, null, this.group, false, false));
        ArrayList<SecurityRule> userSecurityRules = new ArrayList<SecurityRule>();
        userSecurityRules.add(this.createSecurityRule(1L, this.user, null, false, false));
        this.securityService.setGroupSecurityRules(groupSecurityRules);
        this.securityService.setUserSecurityRules(userSecurityRules);
        Assert.assertFalse((boolean)this.restService.resourceAccessRead(this.user, 1L));
        Assert.assertFalse((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testIgnoreNotValidUserRules() {
        ArrayList<SecurityRule> groupSecurityRules = new ArrayList<SecurityRule>();
        groupSecurityRules.add(this.createSecurityRule(1L, null, this.group, false, false));
        ArrayList<SecurityRule> userSecurityRules = new ArrayList<SecurityRule>();
        userSecurityRules.add(this.createSecurityRule(1L, null, this.group, true, false));
        userSecurityRules.add(this.createSecurityRule(1L, this.user, null, true, true));
        this.securityService.setGroupSecurityRules(groupSecurityRules);
        this.securityService.setUserSecurityRules(userSecurityRules);
        Assert.assertTrue((boolean)this.restService.resourceAccessRead(this.user, 1L));
        Assert.assertTrue((boolean)this.restService.resourceAccessWrite(this.user, 1L));
    }

    @Test
    public void testGuestHasEveryoneGroup() {
        Principal principal = this.restService.createGuestPrincipal();
        Assert.assertTrue((boolean)(principal instanceof UsernamePasswordAuthenticationToken));
        UsernamePasswordAuthenticationToken userPrincipal = (UsernamePasswordAuthenticationToken)principal;
        Assert.assertTrue((boolean)(userPrincipal.getPrincipal() instanceof User));
        User user = (User)userPrincipal.getPrincipal();
        Assert.assertEquals((long)1L, (long)user.getGroups().size());
        Assert.assertEquals((Object)GroupReservedNames.EVERYONE.groupName(), (Object)((UserGroup)user.getGroups().iterator().next()).getGroupName());
    }

    private class TESTRESTServiceImpl
    extends RESTServiceImpl {
        private SecurityService securityService = null;

        private TESTRESTServiceImpl() {
        }

        protected SecurityService getSecurityService() {
            return this.securityService;
        }

        public void setSecurityService(SecurityService s) {
            this.securityService = s;
        }
    }

    private class TestSecurityService
    implements SecurityService {
        private List<SecurityRule> userSecurityRules = null;
        private List<SecurityRule> groupSecurityRules = null;

        private TestSecurityService() {
        }

        public void setUserSecurityRules(List<SecurityRule> userSecurityRules) {
            this.userSecurityRules = userSecurityRules;
        }

        public void setGroupSecurityRules(List<SecurityRule> groupSecurityRules) {
            this.groupSecurityRules = groupSecurityRules;
        }

        public List<SecurityRule> getUserSecurityRule(String userName, long entityId) {
            return this.userSecurityRules;
        }

        public List<SecurityRule> getGroupSecurityRule(List<String> groupNames, long entityId) {
            return this.groupSecurityRules;
        }
    }

    private class TestUserService
    implements UserService {
        private TestUserService() {
        }

        public long insert(User user) throws BadRequestServiceEx, NotFoundServiceEx {
            return 0L;
        }

        public long update(User user) throws NotFoundServiceEx, BadRequestServiceEx {
            return 0L;
        }

        public boolean delete(long id) {
            return false;
        }

        public User get(long id) {
            return null;
        }

        public User get(String name) throws NotFoundServiceEx {
            throw new NotFoundServiceEx(name);
        }

        public List<User> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
            return null;
        }

        public List<User> getAll(Integer page, Integer entries, String nameLike, boolean includeAttributes) throws BadRequestServiceEx {
            return null;
        }

        public long getCount(String nameLike) {
            return 0L;
        }

        public void updateAttributes(long id, List<UserAttribute> attributes) throws NotFoundServiceEx {
        }

        public boolean insertSpecialUsers() {
            return false;
        }

        public Collection<User> getByAttribute(UserAttribute attribute) {
            return null;
        }

        public Collection<User> getByGroup(UserGroup group) {
            return null;
        }
    }
}

