/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import com.googlecode.genericdao.search.ISearch;
import it.geosolutions.geostore.core.dao.UserDAO;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.model.enums.UserReservedNames;
import it.geosolutions.geostore.services.rest.security.keycloak.BaseKeycloakDAO;
import it.geosolutions.geostore.services.rest.security.keycloak.GeoStoreKeycloakAuthoritiesMapper;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakAdminClientConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakQuery;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakUserGroupDAO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.core.Response;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.keycloak.admin.client.Keycloak;
import org.keycloak.admin.client.resource.UserResource;
import org.keycloak.admin.client.resource.UsersResource;
import org.keycloak.representations.idm.CredentialRepresentation;
import org.keycloak.representations.idm.UserRepresentation;
import org.springframework.http.HttpStatus;

public class KeycloakUserDAO
extends BaseKeycloakDAO
implements UserDAO {
    private static final Logger LOGGER = LogManager.getLogger(KeycloakUserDAO.class);

    public KeycloakUserDAO(KeycloakAdminClientConfiguration adminClientConfiguration) {
        super(adminClientConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> findAll() {
        Keycloak keycloak = this.keycloak();
        try {
            UsersResource ur = this.getUsersResource(keycloak);
            List userRepresentations = ur.list();
            List<User> list = this.toUsers(userRepresentations, ur, false);
            return list;
        }
        catch (NotFoundException e) {
            LOGGER.warn("No users were found.", (Throwable)e);
            List<User> list = null;
            return list;
        }
        finally {
            this.close(keycloak);
        }
    }

    public User find(Long id) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persist(User ... users) {
        Keycloak keycloak = this.keycloak();
        try {
            List<UserRepresentation> representations = this.toUserRepresentation(users);
            UsersResource usersResource = this.getUsersResource(keycloak);
            representations.forEach(r -> usersResource.create(r));
            for (User u : users) {
                u.setId(Long.valueOf(-1L));
            }
        }
        finally {
            this.close(keycloak);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User[] save(User ... users) {
        Keycloak keycloak = this.keycloak();
        try {
            List<UserRepresentation> representations = this.toUserRepresentation(users);
            UsersResource usersResource = this.getUsersResource(keycloak);
            representations.forEach(r -> usersResource.create(r));
            for (User u : users) {
                u.setId(Long.valueOf(-1L));
            }
        }
        finally {
            this.close(keycloak);
        }
        return users;
    }

    public User merge(User user) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(User user) {
        Keycloak keycloak = this.keycloak();
        try {
            boolean bl;
            block17: {
                Response response;
                block15: {
                    boolean bl2;
                    block16: {
                        UsersResource ur = this.getUsersResource(keycloak);
                        List userRep = ur.search(user.getName(), Boolean.valueOf(true));
                        if (userRep.isEmpty()) {
                            boolean bl3 = false;
                            return bl3;
                        }
                        response = ur.delete(((UserRepresentation)userRep.get(0)).getId());
                        try {
                            if (response.getStatus() != HttpStatus.NO_CONTENT.value()) break block15;
                            bl2 = true;
                            if (response == null) break block16;
                        }
                        catch (Throwable throwable) {
                            try {
                                if (response != null) {
                                    try {
                                        response.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            catch (NotFoundException e) {
                                LOGGER.warn("No user found with name {}", (Object)user.getName(), (Object)e);
                                boolean bl4 = false;
                                return bl4;
                            }
                        }
                        response.close();
                    }
                    return bl2;
                }
                LOGGER.debug("Delete failed with response status {}", (Object)response.getStatus());
                bl = false;
                if (response == null) break block17;
                response.close();
            }
            return bl;
        }
        finally {
            this.close(keycloak);
        }
    }

    public boolean removeById(Long id) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<User> search(ISearch search) {
        Keycloak keycloak = this.keycloak();
        KeycloakQuery query = this.toKeycloakQuery(search);
        try {
            List<User> users;
            UserResource resource;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing the query " + query.toString());
            }
            UsersResource ur = this.getUsersResource(keycloak);
            Collection<Object> userRepresentations = query.isExact() ? ur.search(query.getUserName(), query.getExact()) : (query.getGroupName() != null ? this.getRolesResource(keycloak).get(query.getGroupName()).getRoleUserMembers(query.getStartIndex(), query.getMaxResults()) : ur.search(query.getUserName(), null, null, null, null, null, null, Integer.valueOf(search.getPage()), Integer.valueOf(search.getMaxResults()), query.getEnabled(), Boolean.valueOf(false)));
            if (userRepresentations == null) {
                userRepresentations = new ArrayList<UserRepresentation>();
            }
            if (userRepresentations.isEmpty() && this.isByUsername(query) && (resource = ur.get(query.getUserName())) != null) {
                userRepresentations.add(resource.toRepresentation());
            }
            List<User> list = users = this.toUsers(userRepresentations, ur, this.isGuest(query));
            return list;
        }
        catch (NotFoundException e) {
            LOGGER.warn("No users were found", (Throwable)e);
            ArrayList<User> list = new ArrayList<User>();
            list.add(this.createGUESTUser(1L));
            ArrayList<User> arrayList = list;
            return arrayList;
        }
        finally {
            this.close(keycloak);
        }
    }

    private boolean isGuest(KeycloakQuery query) {
        return query.getUserName() != null && UserReservedNames.GUEST.name().equals(query.getUserName());
    }

    private User createGUESTUser(long id) {
        User user = new User();
        user.setName(UserReservedNames.GUEST.userName());
        user.setPassword("");
        user.setEnabled(true);
        user.setRole(Role.GUEST);
        user.setId(Long.valueOf(id));
        UserGroup groupEveryone = new UserGroup();
        groupEveryone.setGroupName(GroupReservedNames.EVERYONE.groupName());
        groupEveryone.setEnabled(true);
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        groups.add(groupEveryone);
        user.setGroups(groups);
        return user;
    }

    private boolean isByUsername(KeycloakQuery query) {
        return query.isExact() && query.getUserName() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int count(ISearch search) {
        Keycloak keycloak = this.keycloak();
        try {
            KeycloakQuery query = this.toKeycloakQuery(search);
            UsersResource ur = this.getUsersResource(keycloak);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Executing the query " + query.toString());
            }
            Integer count = query.getExact() != null && query.getExact() != false ? ur.count(null, null, null, null, query.getUserName()) : Integer.valueOf(ur.search(query.getUserName(), null, null, null, null, null, null, Integer.valueOf(search.getPage()), Integer.valueOf(search.getMaxResults()), query.getEnabled(), Boolean.valueOf(true)).size());
            int n = count;
            return n;
        }
        catch (NotFoundException e) {
            LOGGER.warn("No users were found", (Throwable)e);
            int n = 0;
            return n;
        }
        finally {
            this.close(keycloak);
        }
    }

    private List<UserRepresentation> toUserRepresentation(User ... users) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converting User to UserRepresentation");
        }
        ArrayList<UserRepresentation> userList = new ArrayList<UserRepresentation>();
        for (User user : users) {
            UserRepresentation representation = new UserRepresentation();
            if (user.getNewPassword() != null) {
                CredentialRepresentation credentialRepresentation = new CredentialRepresentation();
                credentialRepresentation.setType("password");
                credentialRepresentation.setValue(user.getNewPassword());
                representation.setCredentials(Collections.singletonList(credentialRepresentation));
            }
            representation.setUsername(user.getName());
            representation.setEnabled(Boolean.valueOf(user.isEnabled()));
            userList.add(representation);
        }
        return userList;
    }

    private List<User> toUsers(Collection<UserRepresentation> userRepresentations, UsersResource ur, boolean isGuest) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Converting UserRepresentation to User");
        }
        ArrayList<User> users = new ArrayList<User>();
        int id = 1;
        for (UserRepresentation representation : userRepresentations) {
            User user = new User();
            user.setId(Long.valueOf(id));
            ++id;
            user.setName(representation.getUsername());
            user.setEnabled(representation.isEnabled().booleanValue());
            user.setTrusted(true);
            GeoStoreKeycloakAuthoritiesMapper mapper = this.getAuthoritiesMapper();
            List<String> roles = ur.get(representation.getId()).roles().realmLevel().listEffective().stream().map(m -> m.getName()).collect(Collectors.toList());
            mapper.mapAuthorities(roles);
            user.setRole(mapper.getRole());
            Set<UserGroup> groups = mapper.getGroups();
            groups.add(KeycloakUserGroupDAO.everyoneGroup(mapper.getIdCounter()));
            user.setGroups(groups);
            users.add(user);
        }
        if (isGuest && users.isEmpty()) {
            users.add(this.createGUESTUser(id));
        }
        return users;
    }
}

