/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.services.TagService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedTagNameServiceException;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTTagService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ConflictWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.TagList;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTTagServiceImpl
implements RESTTagService {
    private static final Logger LOGGER = LogManager.getLogger(RESTTagServiceImpl.class);
    private TagService tagService;

    public void setTagService(TagService tagService) {
        this.tagService = tagService;
    }

    public long insert(SecurityContext sc, Tag tag) {
        try {
            if (tag == null) {
                throw new BadRequestWebEx("Tag is null");
            }
            if (tag.getId() != null) {
                throw new BadRequestWebEx("Id should be null");
            }
            return this.tagService.insert(tag);
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
        catch (DuplicatedTagNameServiceException e) {
            throw new ConflictWebEx(e.getMessage());
        }
    }

    public TagList getAll(SecurityContext sc, Integer page, Integer entries, String nameLike) throws BadRequestWebEx {
        try {
            String sqlNameLike = RESTServiceImpl.convertNameLikeToSqlSyntax(nameLike);
            List tags = this.tagService.getAll(page, entries, sqlNameLike);
            long count = 0L;
            if (!tags.isEmpty()) {
                count = this.tagService.count(sqlNameLike);
            }
            return new TagList((Collection)tags, Long.valueOf(count));
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
    }

    public Tag get(SecurityContext sc, long id) throws NotFoundWebEx {
        Tag tag = this.tagService.get(id);
        if (tag == null) {
            throw new NotFoundWebEx("Tag not found");
        }
        return tag;
    }

    public long update(SecurityContext sc, long id, Tag tag) {
        try {
            return this.tagService.update(id, tag);
        }
        catch (BadRequestServiceEx e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new BadRequestWebEx(e.getMessage());
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (DuplicatedTagNameServiceException e) {
            throw new ConflictWebEx(e.getMessage());
        }
    }

    public void delete(SecurityContext sc, long id) throws NotFoundWebEx {
        try {
            this.tagService.delete(id);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
    }

    public void addToResource(SecurityContext sc, long id, long resourceId) throws NotFoundWebEx {
        try {
            this.tagService.addToResource(id, resourceId);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
    }

    public void removeFromResource(SecurityContext sc, long id, long resourceId) throws NotFoundWebEx {
        try {
            this.tagService.removeFromResource(id, resourceId);
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
    }
}

