/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.keycloak;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakAdminClientConfiguration;
import it.geosolutions.geostore.services.rest.security.keycloak.KeycloakUserDAO;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class KeycloakUserDAOTest {
    @Rule
    public WireMockRule wireMockServer = new WireMockRule((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
    private String authService;
    private KeycloakUserDAO userDAO;

    @Before
    public void before() {
        this.authService = "http://localhost:" + this.wireMockServer.port();
        KeycloakAdminClientConfiguration configuration = new KeycloakAdminClientConfiguration();
        configuration.setServerUrl(this.authService);
        configuration.setRealm("master");
        configuration.setUsername("username");
        configuration.setPassword("password");
        configuration.setClientId("clientId");
        this.userDAO = new KeycloakUserDAO(configuration);
        this.wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/realms/master/protocol/openid-connect/token")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_token_response.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/users")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_users.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/users/0e72c14e-53d8-4619-a05a-a605dc2102b9/role-mappings/realm/composite")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_user_roles.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/users?username=test&first=-1&max=-1&briefRepresentation=false")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_two_users.json")));
        this.wireMockServer.stubFor(WireMock.get((UrlPattern)WireMock.urlEqualTo((String)"/admin/realms/master/users?username=admin&exact=true")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", "application/json").withBodyFile("keycloak_admin_user.json")));
    }

    @Test
    public void testGetAll() {
        List userList = this.userDAO.findAll();
        Assert.assertEquals((long)3L, (long)userList.size());
        for (User u : userList) {
            Assert.assertNotNull((Object)u.getRole());
            Assert.assertEquals((long)5L, (long)u.getGroups().size());
        }
    }

    @Test
    public void testSearchNameLike() {
        Search searchCriteria = new Search(User.class);
        searchCriteria.addFilterILike("name", "test");
        List userList = this.userDAO.search((ISearch)searchCriteria);
        Assert.assertEquals((long)2L, (long)userList.size());
        List<String> validNames = Arrays.asList("test-user", "test-user-2");
        for (User u : userList) {
            Assert.assertNotNull((Object)u.getRole());
            Assert.assertEquals((long)5L, (long)u.getGroups().size());
            Assert.assertTrue((boolean)validNames.contains(u.getName()));
        }
    }

    @Test
    public void testGetOneByName() {
        Search searchCriteria = new Search(User.class);
        searchCriteria.addFilterEqual("name", (Object)"admin");
        List userList = this.userDAO.search((ISearch)searchCriteria);
        Assert.assertEquals((long)1L, (long)userList.size());
        for (User u : userList) {
            Assert.assertNotNull((Object)u.getRole());
            Assert.assertEquals((long)5L, (long)u.getGroups().size());
            Assert.assertEquals((Object)"admin", (Object)u.getName());
        }
    }
}

