/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.IdPLoginRest;
import it.geosolutions.geostore.services.rest.IdPLoginService;
import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.IdPLoginRestImpl;
import it.geosolutions.geostore.services.rest.security.oauth2.InMemoryTokenStorage;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.Oauth2LoginService;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenStorage;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class OAuth2LoginTest {
    private final IdPLoginRest idPLoginRest = new IdPLoginRestImpl();

    @Test
    public void testLogin() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        OAuth2Configuration configuration = new OAuth2Configuration();
        configuration.setScopes("openid");
        configuration.setClientId("mockClientId");
        configuration.setAuthorizationUri("http://localhost:8080/authorization");
        SetConfOAuthLoginService setConfiguration = new SetConfOAuthLoginService(this.idPLoginRest);
        setConfiguration.setConfiguration(configuration);
        this.idPLoginRest.login("mock");
        Assert.assertEquals((long)302L, (long)response.getStatus());
        Assert.assertEquals((Object)"http://localhost:8080/authorization?response_type=code&client_id=mockClientId&scope=openid&redirect_uri=null", (Object)response.getRedirectedUrl());
    }

    @Test
    public void testCallback() {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        attributes.setAttribute("refresh_token", (Object)"mockRefreshToken", 0);
        attributes.setAttribute("access_token", (Object)"mockAccessToken", 0);
        OAuth2Configuration configuration = new OAuth2Configuration();
        configuration.setInternalRedirectUri("http://localhost:8080/geostore/redirect");
        SetConfOAuthLoginService setConfiguration = new SetConfOAuthLoginService(this.idPLoginRest);
        setConfiguration.setConfiguration(configuration);
        setConfiguration.setTokenStorage((TokenStorage)new InMemoryTokenStorage());
        Response result = this.idPLoginRest.callback("mock");
        Assert.assertEquals((long)302L, (long)result.getStatus());
        List cookies = (List)result.getMetadata().get((Object)"Set-Cookie");
        List tokenCookies = cookies.stream().filter(c -> ((String)c).contains("authProvider") || ((String)c).contains("tokens_key")).collect(Collectors.toList());
        Assert.assertEquals((long)2L, (long)tokenCookies.size());
        Assert.assertEquals((Object)"http://localhost:8080/geostore/redirect", (Object)result.getHeaderString("Location"));
    }

    @After
    public void afterTest() {
        RequestContextHolder.resetRequestAttributes();
    }

    private class SetConfOAuthLoginService
    extends Oauth2LoginService {
        private OAuth2Configuration configuration;
        private TokenStorage tokenStorage;

        public SetConfOAuthLoginService(IdPLoginRest loginRest) {
            loginRest.registerService("mock", (IdPLoginService)this);
        }

        public void setConfiguration(OAuth2Configuration configuration) {
            this.configuration = configuration;
        }

        protected OAuth2Configuration oauth2Configuration(String provider) {
            return this.configuration;
        }

        protected IdPConfiguration configuration(String provider) {
            return this.configuration;
        }

        protected TokenStorage tokenStorage() {
            return this.tokenStorage;
        }

        public void setTokenStorage(TokenStorage tokenStorage) {
            this.tokenStorage = tokenStorage;
        }
    }
}

