/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.MapExpressionUserMapper;
import it.geosolutions.geostore.core.security.UserMapper;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.GeoStoreRequestHeadersAuthenticationFilter;
import it.geosolutions.geostore.services.rest.security.oauth2.JWTHelper;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2GeoStoreAuthenticationFilter;
import it.geosolutions.geostore.services.rest.utils.MockedUserService;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;

public class GeoStoreAuthenticationFilterTest {
    private static final String USERNAME_HEADER = "username";
    private static final String SAMPLE_USER = "myuser";
    private MockedUserService userService;
    private GeoStoreRequestHeadersAuthenticationFilter headerFilter;
    private HttpServletRequest req;
    private HttpServletResponse resp;

    @Before
    public void setUp() {
        this.userService = new MockedUserService();
        this.headerFilter = new GeoStoreRequestHeadersAuthenticationFilter();
        this.headerFilter.setUserNameHeader(USERNAME_HEADER);
        this.headerFilter.setUserService((UserService)this.userService);
        this.headerFilter.setAutoCreateUser(true);
        this.req = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.resp = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)this.req.getHeader(USERNAME_HEADER)).thenReturn((Object)SAMPLE_USER);
        Mockito.when((Object)this.req.getHeader("header1")).thenReturn((Object)"value1");
        Mockito.when((Object)this.req.getHeaderNames()).thenReturn(new Vector<String>(Arrays.asList(USERNAME_HEADER, "header1")).elements());
    }

    @After
    public void tearDown() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void testAutoCreate() throws IOException, ServletException, NotFoundServiceEx {
        this.headerFilter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        this.checkUser(user);
        Assert.assertTrue((String)"User should be enabled", (boolean)user.isEnabled());
    }

    @Test
    public void testAutoCreateDisabled() throws IOException, ServletException, NotFoundServiceEx {
        this.headerFilter.setEnableAutoCreatedUsers(false);
        this.headerFilter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        this.checkUser(user);
        Assert.assertFalse((String)"User should be disabled", (boolean)user.isEnabled());
    }

    @Test
    public void testAutoCreateAttributesMapping() throws IOException, ServletException, NotFoundServiceEx {
        this.headerFilter.setUserMapper((UserMapper)new MapExpressionUserMapper(Collections.singletonMap("attr1", "header1")));
        this.headerFilter.doFilter((ServletRequest)this.req, (ServletResponse)this.resp, new FilterChain(){

            public void doFilter(ServletRequest arg0, ServletResponse arg1) throws IOException, ServletException {
            }
        });
        User user = this.userService.get(SAMPLE_USER);
        this.checkUser(user);
        Assert.assertNotNull((String)"Attributes should not be null", (Object)user.getAttribute());
        Assert.assertEquals((String)"Should have one attribute", (long)1L, (long)user.getAttribute().size());
        UserAttribute attr = (UserAttribute)user.getAttribute().get(0);
        Assert.assertEquals((String)"Attribute name should be 'attr1'", (Object)"attr1", (Object)attr.getName());
        Assert.assertEquals((String)"Attribute value should be 'value1'", (Object)"value1", (Object)attr.getValue());
    }

    @Test
    public void testUsernameRemapping() throws Exception {
        String ORIGINAL_USERNAME = SAMPLE_USER;
        String REMAPPED_USERNAME = "remappedUser";
        OAuth2Configuration config = new OAuth2Configuration();
        config.setPrincipalKey("principal");
        config.setUniqueUsername("unique");
        config.setBeanName("testBean");
        config.setAutoCreateUser(true);
        OAuth2GeoStoreAuthenticationFilter oauth2Filter = new OAuth2GeoStoreAuthenticationFilter(null, null, config, null){

            protected JWTHelper decodeAndValidateIdToken(String idToken) {
                return new JWTHelper(idToken){

                    public <T> T getClaim(String claimName, Class<T> clazz) {
                        if ("principal".equals(claimName)) {
                            return (T)GeoStoreAuthenticationFilterTest.SAMPLE_USER;
                        }
                        if ("unique".equals(claimName)) {
                            return (T)"remappedUser";
                        }
                        return null;
                    }
                };
            }

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                User user = new User();
                user.setName(username);
                user.setRole(Role.USER);
                user.setEnabled(true);
                user.setAttribute(Collections.emptyList());
                user.setGroups(new HashSet());
                return user;
            }

            protected void configureRestTemplate() {
            }
        };
        HttpServletRequest req2 = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp2 = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        PreAuthenticatedAuthenticationToken authToken = oauth2Filter.createPreAuthentication(SAMPLE_USER, req2, resp2);
        Assert.assertNotNull((String)"Authentication token should not be null", (Object)authToken);
        User user = (User)authToken.getPrincipal();
        Assert.assertNotNull((String)"User should not be null", (Object)user);
        Assert.assertEquals((String)"Username should be remapped to the unique claim value", (Object)"remappedUser", (Object)user.getName());
    }

    @Test
    public void testGroupNamesUppercaseAndUserGroupAssignment() throws Exception {
        String GROUP_FROM_TOKEN = "groupA";
        String EXPECTED_GROUP = "GROUPA";
        OAuth2Configuration config = new OAuth2Configuration();
        config.setGroupsClaim("groups");
        config.setBeanName("testBean");
        config.setAutoCreateUser(true);
        config.setGroupNamesUppercase(true);
        DummyUserGroupService dummyGroupService = new DummyUserGroupService();
        OAuth2GeoStoreAuthenticationFilter oauth2Filter = new OAuth2GeoStoreAuthenticationFilter(null, null, config, null){

            protected JWTHelper decodeAndValidateIdToken(String idToken) {
                return new JWTHelper(idToken){

                    public <T> List<T> getClaimAsList(String claimName, Class<T> clazz) {
                        if ("groups".equals(claimName)) {
                            return Collections.singletonList("groupA");
                        }
                        return Collections.emptyList();
                    }
                };
            }

            protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
                User user = new User();
                user.setName(username);
                user.setRole(Role.USER);
                user.setEnabled(true);
                user.setAttribute(Collections.emptyList());
                user.setGroups(new HashSet());
                return user;
            }

            protected void configureRestTemplate() {
            }
        };
        oauth2Filter.setUserGroupService((UserGroupService)dummyGroupService);
        HttpServletRequest req2 = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        HttpServletResponse resp2 = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        PreAuthenticatedAuthenticationToken authToken = oauth2Filter.createPreAuthentication("anyuser", req2, resp2);
        Assert.assertNotNull((String)"Authentication token should not be null", (Object)authToken);
        User user = (User)authToken.getPrincipal();
        Assert.assertNotNull((String)"User should not be null", (Object)user);
        boolean found = user.getGroups().stream().anyMatch(group -> "GROUPA".equals(group.getGroupName()));
        Assert.assertTrue((String)"User should be assigned to group GROUPA", (boolean)found);
        UserGroup groupFromService = dummyGroupService.get("GROUPA");
        Assert.assertNotNull((String)"Dummy group service should contain group GROUPA", (Object)groupFromService);
    }

    private void checkUser(User user) {
        Assert.assertNotNull((String)"User should not be null", (Object)user);
        Assert.assertEquals((String)"User role should be USER", (Object)Role.USER, (Object)user.getRole());
        Assert.assertTrue((String)"User groups should be empty", (boolean)user.getGroups().isEmpty());
    }

    private static class DummyUserGroupService
    implements UserGroupService {
        private final Map<String, UserGroup> groupsByName = new HashMap<String, UserGroup>();
        private final Map<Long, UserGroup> groupsById = new HashMap<Long, UserGroup>();
        private long nextId = 1L;

        private DummyUserGroupService() {
        }

        public UserGroup get(String groupName) {
            return this.groupsByName.get(groupName);
        }

        public long getCount(String nameLike, boolean all) throws BadRequestServiceEx {
            return 0L;
        }

        public long getCount(User authUser, String nameLike, boolean all) throws BadRequestServiceEx {
            return 0L;
        }

        public void updateAttributes(long id, List<UserGroupAttribute> attributes) throws NotFoundServiceEx {
        }

        public long update(UserGroup group) throws NotFoundServiceEx, BadRequestServiceEx {
            return 0L;
        }

        public Collection<UserGroup> findByAttribute(String name, List<String> values, boolean ignoreCase) {
            return List.of();
        }

        public UserGroup get(long id) {
            return this.groupsById.get(id);
        }

        public List<ShortResource> updateSecurityRules(Long groupId, List<Long> resourcesToSet, boolean canRead, boolean canWrite) throws NotFoundServiceEx, BadRequestServiceEx {
            return List.of();
        }

        public boolean insertSpecialUsersGroups() {
            return false;
        }

        public boolean removeSpecialUsersGroups() {
            return false;
        }

        public long insert(UserGroup group) throws BadRequestServiceEx {
            group.setId(Long.valueOf(this.nextId));
            this.groupsById.put(this.nextId, group);
            this.groupsByName.put(group.getGroupName(), group);
            return this.nextId++;
        }

        public boolean delete(long id) throws NotFoundServiceEx, BadRequestServiceEx {
            return false;
        }

        public void assignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
        }

        public void deassignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
        }

        public List<UserGroup> getAllAllowed(User user, Integer page, Integer entries, String nameLike, boolean all) throws BadRequestServiceEx {
            return List.of();
        }

        public List<UserGroup> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
            return List.of();
        }

        public List<UserGroup> getAll(Integer page, Integer entries, String nameLike, boolean all) throws BadRequestServiceEx {
            return List.of();
        }
    }
}

