/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.keycloak;

import it.geosolutions.geostore.services.rest.security.keycloak.KeyCloakConfiguration;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import org.keycloak.adapters.KeycloakDeployment;
import org.keycloak.adapters.OAuthRequestAuthenticator;
import org.keycloak.adapters.OIDCAuthenticationError;
import org.keycloak.adapters.RequestAuthenticator;
import org.keycloak.adapters.spi.AdapterSessionStore;
import org.keycloak.adapters.spi.AuthChallenge;
import org.keycloak.adapters.spi.HttpFacade;

public class GeoStoreOAuthAuthenticator
extends OAuthRequestAuthenticator {
    public GeoStoreOAuthAuthenticator(RequestAuthenticator requestAuthenticator, HttpFacade facade, KeycloakDeployment deployment, int sslRedirectPort, AdapterSessionStore tokenStore) {
        super(requestAuthenticator, facade, deployment, sslRedirectPort, tokenStore);
    }

    protected AuthChallenge loginRedirect() {
        final String state = this.getStateCode();
        final String redirect = this.getRedirectUri(state);
        if (redirect == null) {
            return this.challenge(403, OIDCAuthenticationError.Reason.NO_REDIRECT_URI, null);
        }
        return new AuthChallenge(){

            public int getResponseCode() {
                return 0;
            }

            public boolean challenge(HttpFacade exchange) {
                GeoStoreOAuthAuthenticator.this.tokenStore.saveRequest();
                exchange.getResponse().setStatus(302);
                exchange.getResponse().setCookie(GeoStoreOAuthAuthenticator.this.deployment.getStateCookieName(), state, null, null, -1, GeoStoreOAuthAuthenticator.this.deployment.getSslRequired().isRequired(GeoStoreOAuthAuthenticator.this.facade.getRequest().getRemoteAddr()), true);
                exchange.getResponse().setHeader("Location", redirect);
                return true;
            }
        };
    }

    protected String stripOauthParametersFromRedirect() {
        String redirectUrl = super.stripOauthParametersFromRedirect();
        KeyCloakConfiguration configuration = GeoStoreContext.bean(KeyCloakConfiguration.class);
        Boolean forceRedirectURI = configuration.getForceConfiguredRedirectURI();
        if (forceRedirectURI.booleanValue()) {
            return configuration.getRedirectUri();
        }
        return redirectUrl;
    }

    protected String getRequestUrl() {
        KeyCloakConfiguration configuration = GeoStoreContext.bean(KeyCloakConfiguration.class);
        String redirectUri = configuration.getRedirectUri();
        if (redirectUri != null && !"".equals(redirectUri)) {
            return redirectUri;
        }
        return super.getRequestUrl();
    }
}

