/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.service.impl;

import it.geosolutions.geostore.services.InMemoryUserSessionServiceImpl;
import it.geosolutions.geostore.services.UserSessionService;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.impl.SessionServiceDelegateImpl;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import java.text.ParseException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.junit.Assert;
import org.junit.Test;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RESTSessionServiceDelegateImplTest {
    @Test
    public void testForbiddenOnRefreshTokenInvalidOrExpired() throws ParseException {
        MockHttpServletRequest request = new MockHttpServletRequest();
        MockHttpServletResponse response = new MockHttpServletResponse();
        SessionServiceDelegateImpl sessionServiceDelegate = new SessionServiceDelegateImpl();
        sessionServiceDelegate.setUserSessionService((UserSessionService)new InMemoryUserSessionServiceImpl());
        ServletRequestAttributes attributes = new ServletRequestAttributes((HttpServletRequest)request, (HttpServletResponse)response);
        RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
        String access_token = "a_random_access_token";
        String refresh_token = "a_random_refresh_token";
        SessionToken sessionToken = new SessionToken();
        sessionToken.setAccessToken(access_token);
        sessionToken.setRefreshToken(refresh_token);
        SessionToken result = null;
        int status = 0;
        try {
            result = sessionServiceDelegate.refresh(sessionToken.getRefreshToken(), sessionToken.getAccessToken());
        }
        catch (ForbiddenErrorWebEx e) {
            status = e.getResponse().getStatus();
        }
        Assert.assertNull((Object)result);
        Assert.assertEquals((long)status, (long)Response.Status.FORBIDDEN.getStatusCode());
    }
}

