/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.IdPLoginRest;
import it.geosolutions.geostore.services.rest.IdPLoginService;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public class IdPLoginRestImpl
implements IdPLoginRest {
    private final Map<String, IdPLoginService> services = new HashMap<String, IdPLoginService>();

    public void login(String provider) {
        HttpServletRequest request = OAuth2Utils.getRequest();
        HttpServletResponse resp = OAuth2Utils.getResponse();
        IdPLoginService service = this.services.get(provider);
        service.doLogin(request, resp, provider);
    }

    public Response callback(String provider) throws NotFoundWebEx {
        IdPLoginService service = this.services.get(provider);
        return service.doInternalRedirect(OAuth2Utils.getRequest(), OAuth2Utils.getResponse(), provider);
    }

    public SessionToken getTokensByTokenIdentifier(String provider, String tokenIdentifier) throws NotFoundWebEx {
        return this.services.get(provider).getTokenByIdentifier(provider, tokenIdentifier);
    }

    public void registerService(String providerName, IdPLoginService service) {
        this.services.put(providerName, service);
    }
}

