/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.keycloak;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

class MockUserService
implements UserService {
    private final Map<String, User> users = new ConcurrentHashMap<String, User>();
    private final AtomicLong atomicLong = new AtomicLong();

    MockUserService() {
    }

    public long insert(User user) throws BadRequestServiceEx, NotFoundServiceEx {
        Long id = this.atomicLong.incrementAndGet();
        user.setId(id);
        this.users.put(user.getName(), user);
        return id;
    }

    public long update(User user) throws NotFoundServiceEx, BadRequestServiceEx {
        return 0L;
    }

    public boolean delete(long id) {
        return false;
    }

    public User get(long id) {
        return this.users.values().stream().filter(u -> u.getId().equals(id)).findAny().get();
    }

    public User get(String name) throws NotFoundServiceEx {
        return this.users.get(name);
    }

    public List<User> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
        return null;
    }

    public List<User> getAll(Integer page, Integer entries, String nameLike, boolean includeAttributes) throws BadRequestServiceEx {
        return null;
    }

    public long getCount(String nameLike) {
        return 0L;
    }

    public void updateAttributes(long id, List<UserAttribute> attributes) throws NotFoundServiceEx {
    }

    public boolean insertSpecialUsers() {
        return false;
    }

    public Collection<User> getByAttribute(UserAttribute attribute) {
        return null;
    }

    public Collection<User> getByGroup(UserGroup group) {
        return null;
    }
}

