/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import com.auth0.jwt.JWT;
import com.auth0.jwt.impl.NullClaim;
import com.auth0.jwt.interfaces.Claim;
import com.auth0.jwt.interfaces.DecodedJWT;
import java.util.ArrayList;
import java.util.List;

public class JWTHelper {
    private final DecodedJWT decodedJWT;

    public JWTHelper(String jwtToken) {
        this.decodedJWT = JWT.decode((String)jwtToken);
    }

    public <T> T getClaim(String claimName, Class<T> binding) {
        Claim claim;
        Object result = null;
        if (this.decodedJWT != null && claimName != null && this.nonNullClaim(claim = this.decodedJWT.getClaim(claimName))) {
            result = claim.as(binding);
        }
        return (T)result;
    }

    public <T> List<T> getClaimAsList(String claimName, Class<T> binding) {
        Claim claim;
        ArrayList<Object> result = null;
        if (this.decodedJWT != null && claimName != null && this.nonNullClaim(claim = this.decodedJWT.getClaim(claimName)) && (result = claim.asList(binding)) == null) {
            result = new ArrayList<Object>();
            Object singleValue = claim.as(binding);
            if (singleValue != null) {
                result.add(singleValue);
            }
        }
        return result;
    }

    private boolean nonNullClaim(Claim claim) {
        return claim != null && !(claim instanceof NullClaim);
    }
}

