/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import com.google.common.collect.Lists;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserAttribute;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.JWTHelper;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.filter.OAuth2ClientAuthenticationProcessingFilter;
import org.springframework.security.oauth2.client.http.AccessTokenRequiredException;
import org.springframework.security.oauth2.client.resource.OAuth2AccessDeniedException;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.security.oauth2.provider.token.ResourceServerTokenServices;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public abstract class OAuth2GeoStoreAuthenticationFilter
extends OAuth2ClientAuthenticationProcessingFilter {
    public static final String OAUTH2_AUTHENTICATION_KEY = "oauth2.authentication";
    public static final String OAUTH2_AUTHENTICATION_TYPE_KEY = "oauth2.authenticationType";
    public static final String OAUTH2_ACCESS_TOKEN_CHECK_KEY = "oauth2.AccessTokenCheckResponse";
    private static final Logger LOGGER = LogManager.getLogger(OAuth2GeoStoreAuthenticationFilter.class);
    private final AuthenticationEntryPoint authEntryPoint;
    private final TokenAuthenticationCache cache;
    @Autowired
    protected UserService userService;
    @Autowired
    protected UserGroupService userGroupService;
    protected RemoteTokenServices tokenServices;
    protected OAuth2Configuration configuration;

    public OAuth2GeoStoreAuthenticationFilter(RemoteTokenServices tokenServices, GeoStoreOAuthRestTemplate oAuth2RestTemplate, OAuth2Configuration configuration, TokenAuthenticationCache tokenAuthenticationCache) {
        super("/**");
        super.setTokenServices((ResourceServerTokenServices)tokenServices);
        this.tokenServices = tokenServices;
        this.restTemplate = oAuth2RestTemplate;
        this.configuration = configuration;
        this.authEntryPoint = configuration.getAuthenticationEntryPoint();
        this.cache = tokenAuthenticationCache;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (this.configuration.isEnabled() && !this.configuration.isInvalid() && authentication == null) {
            super.doFilter(req, res, chain);
        } else if (req instanceof HttpServletRequest) {
            this.addRequestAttributes((HttpServletRequest)req, authentication);
        }
        if (this.configuration.isEnabled() && this.configuration.isInvalid() && LOGGER.isDebugEnabled()) {
            LOGGER.info("Skipping configured OAuth2 authentication. One or more mandatory properties are missing (clientId, clientSecret, authorizationUri, tokenUri");
        }
        chain.doFilter(req, res);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        Authentication authentication;
        String token = OAuth2Utils.tokenFromParamsOrBearer("access_token", request);
        if (token != null) {
            request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.BEARER);
        } else {
            request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.USER);
        }
        if (token != null) {
            authentication = this.cache.get(token);
            if (authentication == null) {
                authentication = this.authenticateAndUpdateCache(request, response, token, (OAuth2AccessToken)new DefaultOAuth2AccessToken(token));
            } else {
                OAuth2AccessToken accessToken;
                TokenDetails details = this.tokenDetails(authentication);
                if (details != null && (accessToken = details.getAccessToken()).isExpired()) {
                    authentication = this.authenticateAndUpdateCache(request, response, token, accessToken);
                }
            }
        } else {
            this.clearState();
            authentication = this.authenticateAndUpdateCache(request, response, null, null);
            token = (String)RequestContextHolder.getRequestAttributes().getAttribute("access_token", 0);
            if (token != null) {
                request.setAttribute("access_token", (Object)token);
                request.setAttribute(OAUTH2_AUTHENTICATION_TYPE_KEY, (Object)OAuth2AuthenticationType.BEARER);
                request.setAttribute("id_token", RequestContextHolder.getRequestAttributes().getAttribute("id_token", 0));
                request.setAttribute("refresh_token", RequestContextHolder.getRequestAttributes().getAttribute("refresh_token", 0));
            }
        }
        return authentication;
    }

    private TokenDetails tokenDetails(Authentication authentication) {
        TokenDetails tokenDetails = null;
        Object details = authentication.getDetails();
        if (details instanceof TokenDetails) {
            tokenDetails = (TokenDetails)details;
        }
        return tokenDetails;
    }

    private Authentication authenticateAndUpdateCache(HttpServletRequest request, HttpServletResponse response, String token, OAuth2AccessToken accessToken) {
        Authentication authentication = this.performOAuthAuthentication(request, response, accessToken);
        if (authentication != null) {
            SecurityContextHolder.getContext().setAuthentication(authentication);
            TokenDetails tokenDetails = this.tokenDetails(authentication);
            if (tokenDetails != null) {
                OAuth2AccessToken accessTokenDetails = tokenDetails.getAccessToken();
                if (accessTokenDetails != null) {
                    token = accessTokenDetails.getValue();
                    RequestContextHolder.getRequestAttributes().setAttribute("access_token", (Object)accessTokenDetails.getValue(), 0);
                    if (accessTokenDetails != null && accessTokenDetails.getRefreshToken() != null && accessTokenDetails.getRefreshToken().getValue() != null) {
                        RequestContextHolder.getRequestAttributes().setAttribute("refresh_token", (Object)accessTokenDetails.getRefreshToken().getValue(), 0);
                    }
                }
                if (tokenDetails.getIdToken() != null) {
                    RequestContextHolder.getRequestAttributes().setAttribute("id_token", (Object)tokenDetails.getIdToken(), 0);
                }
            }
            this.cache.putCacheEntry(token, authentication);
        }
        RequestContextHolder.getRequestAttributes().setAttribute("PROVIDER", (Object)this.configuration.getProvider(), 0);
        return authentication;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearState() {
        OAuth2ClientContext clientContext = this.restTemplate.getOAuth2ClientContext();
        AccessTokenRequest accessTokenRequest = clientContext.getAccessTokenRequest();
        if (accessTokenRequest != null && accessTokenRequest.getStateKey() != null) {
            clientContext.removePreservedState(accessTokenRequest.getStateKey());
        }
        if (accessTokenRequest != null) {
            try {
                accessTokenRequest.remove((Object)"access_token");
            }
            finally {
                SecurityContextHolder.clearContext();
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                LOGGER.debug("Cleaned out Session Access Token Request!");
            }
        }
    }

    protected Authentication performOAuthAuthentication(HttpServletRequest request, HttpServletResponse response, OAuth2AccessToken accessToken) {
        LOGGER.debug("About to perform remote authentication.");
        LOGGER.debug("Access Token: " + String.valueOf(accessToken));
        String principal = null;
        PreAuthenticatedAuthenticationToken result = null;
        try {
            LOGGER.debug("Trying to get the preauthenticated principal.");
            principal = this.getPreAuthenticatedPrincipal(request, response, accessToken);
        }
        catch (IOException e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
            principal = null;
        }
        catch (ServletException e1) {
            LOGGER.error(e1.getMessage(), (Throwable)e1);
            principal = null;
        }
        LOGGER.debug("preAuthenticatedPrincipal = " + principal + ", trying to authenticate");
        if (principal != null && principal.trim().length() > 0) {
            result = this.createPreAuthentication(principal, request, response);
        }
        return result;
    }

    protected String getPreAuthenticatedPrincipal(HttpServletRequest req, HttpServletResponse resp, OAuth2AccessToken accessToken) throws IOException, ServletException {
        String username;
        LOGGER.debug("About to configure the REST Resource Template");
        this.configureRestTemplate();
        if (accessToken != null && accessToken.getValue() != null && !accessToken.getValue().isEmpty()) {
            LOGGER.debug("Setting the access token on the OAuth2ClientContext");
            this.restTemplate.getOAuth2ClientContext().setAccessToken(accessToken);
        }
        LOGGER.debug("Setting up OAuth2 Filter services and resource template");
        this.setRestTemplate(this.restTemplate);
        this.setTokenServices((ResourceServerTokenServices)this.tokenServices);
        Authentication authentication = null;
        try {
            OAuth2Authentication oAuth2Authentication;
            Object map;
            authentication = super.attemptAuthentication(req, resp);
            req.setAttribute(OAUTH2_AUTHENTICATION_KEY, (Object)authentication);
            if (authentication instanceof OAuth2Authentication && (map = (oAuth2Authentication = (OAuth2Authentication)authentication).getOAuth2Request().getExtensions().get(OAUTH2_ACCESS_TOKEN_CHECK_KEY)) instanceof Map) {
                req.setAttribute(OAUTH2_ACCESS_TOKEN_CHECK_KEY, map);
            }
            if (authentication != null && LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authenticated OAuth request for principal " + String.valueOf(authentication.getPrincipal()));
            }
        }
        catch (Exception e) {
            this.handleOAuthException(e, req, resp);
        }
        String string = username = authentication != null ? SecurityUtils.getUsername((Object)authentication.getPrincipal()) : null;
        if (username != null && username.trim().length() == 0) {
            username = null;
        }
        return username;
    }

    private void handleOAuthException(Exception e, HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        if (e instanceof UserRedirectRequiredException && this.configuration.isEnableRedirectEntryPoint()) {
            this.handleUserRedirection(req, resp);
        } else if (e instanceof BadCredentialsException || e instanceof ResourceAccessException) {
            if (e.getCause() instanceof OAuth2AccessDeniedException) {
                LOGGER.warn("Error while trying to authenticate to OAuth2 Provider with the following Exception cause:", e.getCause());
            } else if (e instanceof ResourceAccessException) {
                LOGGER.error("Could not Authorize OAuth2 Resource due to the following exception:", (Throwable)e);
            } else if (e instanceof ResourceAccessException || e.getCause() instanceof OAuth2AccessDeniedException) {
                LOGGER.warn("It is worth notice that if you try to validate credentials against an SSH protected Endpoint, you need either your server exposed on a secure SSL channel or OAuth2 Provider Certificate to be trusted on your JVM!");
                LOGGER.info("Please refer to the GeoServer OAuth2 Plugin Documentation in order to find the steps for importing the SSH certificates.");
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Could not Authorize OAuth2 Resource due to the following exception:", (Throwable)e);
            }
        }
    }

    private void handleUserRedirection(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        AccessTokenRequest accessTokenRequest;
        if (req.getRequestURI().contains(this.configuration.getProvider() + "/login")) {
            this.authEntryPoint.commence(req, resp, null);
        } else if (resp.getStatus() != 302 && (accessTokenRequest = this.restTemplate.getOAuth2ClientContext().getAccessTokenRequest()).getPreservedState() != null && accessTokenRequest.getStateKey() != null) {
            accessTokenRequest.remove((Object)"state");
            accessTokenRequest.remove((Object)accessTokenRequest.getStateKey());
            accessTokenRequest.setPreservedState(null);
        }
    }

    protected void configureRestTemplate() {
        AuthorizationCodeResourceDetails details = (AuthorizationCodeResourceDetails)this.restTemplate.getResource();
        details.setClientId(this.configuration.getClientId());
        details.setClientSecret(this.configuration.getClientSecret());
        this.tokenServices.setClientId(this.configuration.getClientId());
        this.tokenServices.setClientSecret(this.configuration.getClientSecret());
        details.setAccessTokenUri(this.configuration.getAccessTokenUri());
        details.setUserAuthorizationUri(this.configuration.getAuthorizationUri());
        details.setPreEstablishedRedirectUri(this.configuration.getRedirectUri());
        this.tokenServices.setCheckTokenEndpointUrl(this.configuration.getCheckTokenEndpointUrl());
        details.setScope(this.parseScopes(Stream.of(this.configuration.getScopes()).collect(Collectors.joining(","))));
    }

    protected List<String> parseScopes(String commaSeparatedScopes) {
        ArrayList scopes = Lists.newArrayList();
        Collections.addAll(scopes, commaSeparatedScopes.split(","));
        return scopes;
    }

    protected PreAuthenticatedAuthenticationToken createPreAuthentication(String username, HttpServletRequest request, HttpServletResponse response) {
        User user = this.retrieveUserWithAuthorities(username, request, response);
        if (user == null) {
            return null;
        }
        SimpleGrantedAuthority authority = new SimpleGrantedAuthority("ROLE_" + user.getRole().toString());
        PreAuthenticatedAuthenticationToken authenticationToken = new PreAuthenticatedAuthenticationToken((Object)user, null, Collections.singletonList(authority));
        String idToken = OAuth2Utils.getIdToken();
        if (user != null && (StringUtils.isNotBlank((CharSequence)this.configuration.getGroupsClaim()) || StringUtils.isNotBlank((CharSequence)this.configuration.getRolesClaim()))) {
            this.addAuthoritiesFromToken(user, idToken);
        }
        OAuth2AccessToken accessToken = this.restTemplate.getOAuth2ClientContext().getAccessToken();
        authenticationToken.setDetails((Object)new TokenDetails(accessToken, idToken, this.configuration.getBeanName()));
        return authenticationToken;
    }

    protected void addAuthoritiesFromToken(User user, String idToken) {
        JWTHelper helper = new JWTHelper(idToken);
        List<Object> roles = null;
        List<Object> groups = null;
        roles = this.configuration.getRolesClaim() != null ? helper.getClaimAsList(this.configuration.getRolesClaim(), String.class) : Collections.emptyList();
        if (this.configuration.getGroupsClaim() != null) {
            groups = helper.getClaimAsList(this.configuration.getGroupsClaim(), String.class);
        }
        if (groups == null) {
            groups = Collections.emptyList();
        }
        for (String string : roles) {
            if (!string.equals(Role.ADMIN.name())) continue;
            user.setRole(Role.ADMIN);
        }
        for (String string : groups) {
            UserGroup group = null;
            if (this.userGroupService != null) {
                group = this.userGroupService.get(string);
            }
            if (group == null) {
                group = new UserGroup();
                group.setGroupName(string);
            }
            user.getGroups().add(group);
        }
    }

    protected User retrieveUserWithAuthorities(String username, HttpServletRequest request, HttpServletResponse response) {
        User user = null;
        if (username != null && this.userService != null) {
            try {
                user = this.userService.get(username);
            }
            catch (NotFoundServiceEx notFoundServiceEx) {
                LOGGER.debug("User with username " + username + " not found.");
            }
        }
        if (user == null) {
            try {
                user = this.createUser(username, null, "");
            }
            catch (BadRequestServiceEx | NotFoundServiceEx e) {
                LOGGER.error("Error while autocreating the user: " + username, e);
            }
        }
        return user;
    }

    protected User createUser(String userName, String credentials, Object rawUser) throws BadRequestServiceEx, NotFoundServiceEx {
        User user = new User();
        user.setName(userName);
        user.setNewPassword(credentials);
        user.setEnabled(true);
        UserAttribute userAttribute = new UserAttribute();
        userAttribute.setName("CONFIGURATION_NAME");
        userAttribute.setValue(this.configuration.getBeanName());
        user.setAttribute(Collections.singletonList(userAttribute));
        HashSet groups = new HashSet();
        user.setGroups(groups);
        user.setRole(Role.USER);
        if (this.userService != null && this.configuration.isAutoCreateUser()) {
            long id = this.userService.insert(user);
            user = new User(user);
            user.setId(Long.valueOf(id));
        }
        return user;
    }

    public void afterPropertiesSet() {
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Authentication success. Updating SecurityContextHolder to contain: " + String.valueOf(authResult));
        }
        SecurityContextHolder.getContext().setAuthentication(authResult);
        this.addRequestAttributes(request, authResult);
        request.setAttribute("PROVIDER", (Object)this.configuration.getProvider());
    }

    private void addRequestAttributes(HttpServletRequest request, Authentication authentication) {
        TokenDetails tokenDetails;
        if (authentication != null && (tokenDetails = this.tokenDetails(authentication)) != null && tokenDetails.getAccessToken() != null) {
            OAuth2AccessToken accessToken = tokenDetails.getAccessToken();
            request.setAttribute("access_token", (Object)accessToken.getValue());
            if (tokenDetails.getIdToken() != null) {
                request.setAttribute("id_token", (Object)tokenDetails.getIdToken());
            }
            if (accessToken.getRefreshToken() != null) {
                request.setAttribute("refresh_token", (Object)accessToken.getRefreshToken().getValue());
            }
            request.setAttribute("PROVIDER", (Object)this.configuration.getProvider());
        }
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        if (failed instanceof AccessTokenRequiredException) {
            SecurityContextHolder.clearContext();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Authentication request failed: " + String.valueOf(failed), (Throwable)failed);
                LOGGER.debug("Updated SecurityContextHolder to contain null Authentication");
            }
        }
    }

    public static enum OAuth2AuthenticationType {
        BEARER,
        USER;

    }
}

