/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.security.UserMapper;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.security.GroupsRolesService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.ldap.authentication.LdapAuthenticationProvider;
import org.springframework.security.ldap.authentication.LdapAuthenticator;
import org.springframework.security.ldap.userdetails.LdapAuthoritiesPopulator;
import org.springframework.security.ldap.userdetails.LdapUserDetails;

public class UserLdapAuthenticationProvider
extends LdapAuthenticationProvider {
    public static final String USER_NOT_FOUND_MSG = "User not found. Please check your credentials";
    public static final String USER_NOT_ENABLED = "The user present but not enabled";
    private static final Logger LOGGER = LogManager.getLogger(UserLdapAuthenticationProvider.class);
    private static final String UNAUTHORIZED_MSG = "Bad credentials";
    @Autowired
    UserService userService;
    @Autowired
    UserGroupService userGroupService;
    private UserMapper userMapper;

    public UserLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator) {
        super(authenticator, authoritiesPopulator);
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public void setUserGroupService(UserGroupService userGroupService) {
        this.userGroupService = userGroupService;
    }

    public void setUserMapper(UserMapper userMapper) {
        this.userMapper = userMapper;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        try {
            authentication = super.authenticate(authentication);
        }
        catch (Exception e) {
            LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
            throw new BadCredentialsException(UNAUTHORIZED_MSG);
        }
        LdapUserDetails ldapUser = null;
        if (authentication.isAuthenticated()) {
            Collection authorities = null;
            ldapUser = (LdapUserDetails)authentication.getPrincipal();
            if (!(ldapUser.isAccountNonExpired() && ldapUser.isAccountNonLocked() && ldapUser.isCredentialsNonExpired() && ldapUser.isEnabled())) {
                throw new DisabledException(USER_NOT_FOUND_MSG);
            }
            authorities = ldapUser.getAuthorities();
            String pw = (String)authentication.getCredentials();
            String us = ldapUser.getUsername();
            User user = null;
            try {
                user = this.userService.get(us);
                LOGGER.info("US: " + us);
                if (!user.isEnabled()) {
                    throw new DisabledException(USER_NOT_FOUND_MSG);
                }
            }
            catch (Exception e) {
                LOGGER.info(USER_NOT_FOUND_MSG);
                user = null;
            }
            if (user != null) {
                try {
                    HashSet<UserGroup> groups = new HashSet<UserGroup>();
                    Role role = this.extractUserRoleAndGroups(user.getRole(), authorities, groups);
                    user.setRole(role);
                    user.setGroups(GroupReservedNames.checkReservedGroups(groups));
                    if (this.userService != null) {
                        this.userService.update(user);
                    }
                    Authentication a = this.prepareAuthentication(pw, user, role);
                    return a;
                }
                catch (BadRequestServiceEx e) {
                    LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                    throw new UsernameNotFoundException(USER_NOT_FOUND_MSG);
                }
                catch (NotFoundServiceEx e) {
                    LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                    throw new UsernameNotFoundException(USER_NOT_FOUND_MSG);
                }
            }
            try {
                user = new User();
                user.setName(us);
                user.setNewPassword(null);
                user.setEnabled(true);
                HashSet<UserGroup> groups = new HashSet<UserGroup>();
                Role role = this.extractUserRoleAndGroups(null, authorities, groups);
                user.setRole(role);
                user.setGroups(GroupReservedNames.checkReservedGroups(groups));
                if (this.userMapper != null) {
                    this.userMapper.mapUser((Object)ldapUser, user);
                }
                if (this.userService != null) {
                    this.userService.insert(user);
                }
                Authentication a = this.prepareAuthentication(pw, user, role);
                return a;
            }
            catch (BadRequestServiceEx e) {
                LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                throw new UsernameNotFoundException(USER_NOT_FOUND_MSG);
            }
            catch (NotFoundServiceEx e) {
                LOGGER.log(Level.ERROR, e.getMessage(), (Throwable)e);
                throw new UsernameNotFoundException(USER_NOT_FOUND_MSG);
            }
        }
        throw new BadCredentialsException(UNAUTHORIZED_MSG);
    }

    protected Authentication prepareAuthentication(String pw, User user, Role role) {
        ArrayList<SimpleGrantedAuthority> grantedAuthorities = new ArrayList<SimpleGrantedAuthority>();
        grantedAuthorities.add(new SimpleGrantedAuthority("ROLE_" + String.valueOf(role)));
        UsernamePasswordAuthenticationToken a = new UsernamePasswordAuthenticationToken((Object)user, (Object)pw, grantedAuthorities);
        return a;
    }

    protected Role extractUserRoleAndGroups(Role userRole, Collection<? extends GrantedAuthority> authorities, Set<UserGroup> groups) throws BadRequestServiceEx {
        Role role = userRole != null ? userRole : Role.USER;
        for (GrantedAuthority grantedAuthority : authorities) {
            if (grantedAuthority.getAuthority().startsWith("ROLE_")) {
                if (grantedAuthority.getAuthority().toUpperCase().endsWith("ADMIN") && (role == Role.GUEST || role == Role.USER)) {
                    role = Role.ADMIN;
                    continue;
                }
                if (!grantedAuthority.getAuthority().toUpperCase().endsWith("USER") || role != Role.GUEST) continue;
                role = Role.USER;
                continue;
            }
            groups.add(this.synchronizeGroup(grantedAuthority));
        }
        return role;
    }

    public void synchronizeGroups() throws BadRequestServiceEx {
        if (this.getAuthoritiesPopulator() instanceof GroupsRolesService) {
            GroupsRolesService groupsService = (GroupsRolesService)this.getAuthoritiesPopulator();
            for (GrantedAuthority authority : groupsService.getAllGroups()) {
                this.synchronizeGroup(authority);
            }
        }
    }

    private UserGroup synchronizeGroup(GrantedAuthority a) throws BadRequestServiceEx {
        UserGroup group = new UserGroup();
        group.setGroupName(a.getAuthority());
        if (this.userGroupService != null) {
            UserGroup userGroup = this.userGroupService.get(group.getGroupName());
            if (userGroup == null) {
                LOGGER.log(Level.INFO, "Creating new group from LDAP: " + group.getGroupName());
                long groupId = this.userGroupService.insert(group);
                userGroup = this.userGroupService.get(groupId);
            }
            return userGroup;
        }
        return group;
    }
}

