/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security;

import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationFilter;
import it.geosolutions.geostore.services.rest.utils.MockedUserService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public class TokenAuthenticationFilterTest {
    private static final String DEFAULT_PREFIX = "Bearer ";
    private static final String DEFAULT_HEADER = "Authorization";
    private static final String SAMPLE_USER = "user";
    private static final String SAMPLE_TOKEN = UUID.randomUUID().toString();
    private static final String WRONG_TOKEN = UUID.randomUUID().toString();
    private static final Authentication SAMPLE_AUTH = new UsernamePasswordAuthenticationToken((Object)"user", (Object)"");
    HttpServletRequest request = null;
    HttpServletResponse response = null;
    FilterChain chain = null;
    private TokenAuthenticationFilter filter;
    private Map<String, Authentication> tokens;

    @Before
    public void setUp() {
        this.tokens = new HashMap<String, Authentication>();
        this.tokens.put(SAMPLE_TOKEN, SAMPLE_AUTH);
        this.filter = new TokenAuthenticationFilter(){

            protected Authentication checkToken(String token) {
                return TokenAuthenticationFilterTest.this.tokens.get(token);
            }
        };
        this.filter.setUserService((UserService)new MockedUserService());
        this.request = (HttpServletRequest)Mockito.mock(HttpServletRequest.class);
        this.response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        this.chain = (FilterChain)Mockito.mock(FilterChain.class);
    }

    @After
    public void tearDown() {
        SecurityContextHolder.getContext().setAuthentication(null);
    }

    @Test
    public void testExistingToken() throws IOException, ServletException {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)(DEFAULT_PREFIX + SAMPLE_TOKEN));
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)SAMPLE_USER, (Object)SecurityContextHolder.getContext().getAuthentication().getName());
    }

    @Test
    public void testUnknownToken() throws IOException, ServletException {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)(DEFAULT_PREFIX + WRONG_TOKEN));
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }

    @Test
    public void testCustomHeader() throws IOException, ServletException {
        Mockito.when((Object)this.request.getHeader("Custom")).thenReturn((Object)(DEFAULT_PREFIX + SAMPLE_TOKEN));
        this.filter.setTokenHeader("Custom");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)SAMPLE_USER, (Object)SecurityContextHolder.getContext().getAuthentication().getName());
    }

    @Test
    public void testCustomPrefix() throws IOException, ServletException {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)("Custom" + SAMPLE_TOKEN));
        this.filter.setTokenPrefix("Custom");
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)SAMPLE_USER, (Object)SecurityContextHolder.getContext().getAuthentication().getName());
    }

    @Test
    public void testCacheExpiration() throws IOException, ServletException, InterruptedException {
        Mockito.when((Object)this.request.getHeader(DEFAULT_HEADER)).thenReturn((Object)(DEFAULT_PREFIX + SAMPLE_TOKEN));
        this.filter.setCacheExpiration(1);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Assert.assertEquals((Object)SAMPLE_USER, (Object)SecurityContextHolder.getContext().getAuthentication().getName());
        this.tokens.clear();
        SecurityContextHolder.getContext().setAuthentication(null);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNotNull((Object)SecurityContextHolder.getContext().getAuthentication());
        Thread.sleep(2000L);
        SecurityContextHolder.getContext().setAuthentication(null);
        this.filter.doFilter((ServletRequest)this.request, (ServletResponse)this.response, this.chain);
        Assert.assertNull((Object)SecurityContextHolder.getContext().getAuthentication());
    }
}

