/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.openid_connect;

import it.geosolutions.geostore.services.rest.IdPLoginRest;
import it.geosolutions.geostore.services.rest.IdPLoginService;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.Oauth2LoginService;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

public class OpenIdConnectLoginService
extends Oauth2LoginService {
    public OpenIdConnectLoginService(IdPLoginRest loginRest) {
        loginRest.registerService("oidc", (IdPLoginService)this);
    }

    @Override
    public Response doInternalRedirect(HttpServletRequest request, HttpServletResponse response, String provider) {
        Authentication auth;
        String token = OAuth2Utils.getAccessToken();
        String refreshToken = OAuth2Utils.getRefreshAccessToken();
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (token == null && SecurityContextHolder.getContext() != null && requestAttributes != null && (auth = SecurityContextHolder.getContext().getAuthentication()) != null && auth.getDetails() != null && auth.getDetails() instanceof TokenDetails) {
            TokenDetails tokenDetails = (TokenDetails)auth.getDetails();
            OAuth2AccessToken accessTokenDetails = tokenDetails.getAccessToken();
            if (accessTokenDetails != null) {
                token = accessTokenDetails.getValue();
                requestAttributes.setAttribute("access_token", (Object)accessTokenDetails, 0);
                requestAttributes.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_VALUE, (Object)token, 0);
                if (accessTokenDetails.getRefreshToken().getValue() != null) {
                    refreshToken = accessTokenDetails.getRefreshToken().getValue();
                    requestAttributes.setAttribute("refresh_token", (Object)accessTokenDetails.getRefreshToken().getValue(), 0);
                }
            }
            if (tokenDetails.getIdToken() != null) {
                requestAttributes.setAttribute("id_token", (Object)tokenDetails.getIdToken(), 0);
                requestAttributes.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_VALUE, (Object)tokenDetails.getIdToken(), 0);
            }
        }
        assert (requestAttributes != null);
        requestAttributes.setAttribute("PROVIDER", (Object)provider, 0);
        return this.buildCallbackResponse(response, token, refreshToken, provider);
    }
}

