/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.GroupReservedNames;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.core.model.enums.UserReservedNames;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public abstract class RESTServiceImpl {
    private static final Logger LOGGER = LogManager.getLogger(RESTServiceImpl.class);
    @Autowired
    UserService userService;

    public static List<String> extractGroupNames(Set<UserGroup> groups) {
        ArrayList<String> groupNames = new ArrayList<String>(groups.size() + 1);
        for (UserGroup ug : groups) {
            groupNames.add(ug.getGroupName());
        }
        return groupNames;
    }

    protected abstract SecurityService getSecurityService();

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    protected User extractAuthUser(SecurityContext sc) throws InternalErrorWebEx {
        if (sc == null) {
            throw new InternalErrorWebEx("Missing auth info");
        }
        Principal principal = sc.getUserPrincipal();
        if (principal == null) {
            principal = this.createGuestPrincipal();
        }
        if (!(principal instanceof Authentication)) {
            RESTServiceImpl.logMismatchedPrincipal();
            throw new InternalErrorWebEx("Mismatching auth principal (" + principal.getClass() + ")");
        }
        Authentication usrToken = (Authentication)principal;
        if (usrToken.getPrincipal() instanceof User) {
            User user = (User)usrToken.getPrincipal();
            LOGGER.info("Accessing service with user {} and role {}", (Object)user.getName(), (Object)user.getRole());
            return user;
        }
        RESTServiceImpl.logMismatchedPrincipal();
        throw new InternalErrorWebEx("Mismatching auth principal (not a GeoStore User)");
    }

    private static void logMismatchedPrincipal() {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Mismatching auth principal");
        }
    }

    public boolean resourceAccessWrite(User authUser, long resourceId) {
        List groupSecurityRules;
        List<String> groupNames;
        if (authUser.getRole().equals((Object)Role.ADMIN)) {
            return true;
        }
        List userSecurityRules = this.getSecurityService().getUserSecurityRule(authUser.getName(), resourceId);
        if (userSecurityRules != null && !userSecurityRules.isEmpty()) {
            for (SecurityRule sr : userSecurityRules) {
                if (!sr.isCanWrite() || sr.getUser() == null || !sr.getUser().getName().equals(authUser.getName())) continue;
                return true;
            }
        }
        if (!(groupNames = RESTServiceImpl.extractGroupNames(authUser.getGroups())).isEmpty() && (groupSecurityRules = this.getSecurityService().getGroupSecurityRule(groupNames, resourceId)) != null && !groupSecurityRules.isEmpty()) {
            for (SecurityRule sr : groupSecurityRules) {
                if (!sr.isCanWrite()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean resourceAccessRead(User authUser, long resourceId) {
        List groupSecurityRules;
        List<String> groupNames;
        if (authUser.getRole().equals((Object)Role.ADMIN)) {
            return true;
        }
        List userSecurityRules = this.getSecurityService().getUserSecurityRule(authUser.getName(), resourceId);
        if (userSecurityRules != null && !userSecurityRules.isEmpty()) {
            for (SecurityRule sr : userSecurityRules) {
                if (!sr.isCanRead() || sr.getUser() == null || !sr.getUser().getName().equals(authUser.getName())) continue;
                return true;
            }
        }
        if (!(groupNames = RESTServiceImpl.extractGroupNames(authUser.getGroups())).isEmpty() && (groupSecurityRules = this.getSecurityService().getGroupSecurityRule(groupNames, resourceId)) != null && !groupSecurityRules.isEmpty()) {
            for (SecurityRule sr : groupSecurityRules) {
                if (!sr.isCanRead()) continue;
                return true;
            }
        }
        return false;
    }

    public Principal createGuestPrincipal() {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_GUEST"));
        try {
            User u = this.userService.get(UserReservedNames.GUEST.userName());
            return new UsernamePasswordAuthenticationToken((Object)u, (Object)"", authorities);
        }
        catch (NotFoundServiceEx e) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("User GUEST is not configured, creating on-the-fly a default one");
            }
            User guest = new User();
            guest.setName("guest");
            guest.setRole(Role.GUEST);
            HashSet<UserGroup> groups = new HashSet<UserGroup>();
            UserGroup everyoneGroup = new UserGroup();
            everyoneGroup.setEnabled(true);
            everyoneGroup.setId(Long.valueOf(-1L));
            everyoneGroup.setGroupName(GroupReservedNames.EVERYONE.groupName());
            groups.add(everyoneGroup);
            guest.setGroups(groups);
            return new UsernamePasswordAuthenticationToken((Object)guest, (Object)"", authorities);
        }
    }

    public static String convertNameLikeToSqlSyntax(String nameLike) {
        if (nameLike == null) {
            return null;
        }
        return nameLike.replaceAll("[*]", "%");
    }
}

