/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.google;

import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreRemoteTokenServices;
import it.geosolutions.geostore.services.rest.security.oauth2.google.GoogleAccessTokenConverter;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

public class GoogleTokenServices
extends GeoStoreRemoteTokenServices {
    public GoogleTokenServices(String principalKey) {
        super((AccessTokenConverter)new GoogleAccessTokenConverter(principalKey));
    }

    @Override
    protected Map<String, Object> checkToken(String accessToken) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"token", (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.getAuthorizationHeader(accessToken));
        String accessTokenUrl = this.checkTokenEndpointUrl + "?access_token=" + accessToken;
        return this.sendRequestForMap(accessTokenUrl, (MultiValueMap<String, String>)formData, headers, HttpMethod.POST);
    }

    @Override
    protected void transformNonStandardValuesToStandardValues(Map<String, Object> map) {
        LOGGER.debug("Original map = " + map);
        map.put("client_id", map.get("issued_to"));
        map.put("user_name", map.get("user_id"));
        LOGGER.debug("Transformed = " + map);
    }

    @Override
    protected String getAuthorizationHeader(String accessToken) {
        String creds = String.format("%s:%s", this.clientId, this.clientSecret);
        return "Basic " + new String(Base64.getEncoder().encode(creds.getBytes(StandardCharsets.UTF_8)));
    }
}

