/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.security.password.PwEncoder;
import it.geosolutions.geostore.services.rest.utils.GeoStorePrincipal;
import it.geosolutions.geostore.services.rest.utils.GeoStoreSecurityContext;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.AccessDeniedException;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.security.SecurityContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractGeoStoreAuthenticationInterceptor
extends AbstractPhaseInterceptor<Message> {
    protected static final Logger LOGGER = LogManager.getLogger(AbstractGeoStoreAuthenticationInterceptor.class);

    public AbstractGeoStoreAuthenticationInterceptor() {
        super("unmarshal");
    }

    public void handleMessage(Message message) throws Fault {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("In handleMessage");
            LOGGER.info("Message --> " + message);
        }
        String username = null;
        String password = null;
        User user = null;
        AuthorizationPolicy policy = (AuthorizationPolicy)message.get(AuthorizationPolicy.class);
        if (policy != null) {
            username = policy.getUserName();
            password = policy.getPassword();
            if (password == null) {
                password = "";
            }
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Requesting user: " + username);
            }
            try {
                user = this.getUser(username, message);
            }
            catch (Exception e) {
                LOGGER.error("Exception while checking pw: {}", (Object)username, (Object)e);
                throw new AccessDeniedException("Authorization error");
            }
            if (!PwEncoder.isPasswordValid((String)user.getPassword(), (String)password)) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Bad pw for user {}", (Object)username);
                }
                throw new AccessDeniedException("Not authorized");
            }
        } else if (LOGGER.isInfoEnabled()) {
            LOGGER.info("No requesting user -- GUEST access");
        }
        GeoStoreSecurityContext securityContext = new GeoStoreSecurityContext();
        GeoStorePrincipal principal = user != null ? new GeoStorePrincipal(user) : GeoStorePrincipal.createGuest();
        securityContext.setPrincipal(principal);
        message.put(SecurityContext.class, (Object)securityContext);
    }

    protected abstract User getUser(String var1, Message var2);
}

