/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.IdPLoginService;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.AccessCookie;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenStorage;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.time.DateUtils;
import org.apache.cxf.jaxrs.impl.ResponseBuilderImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Oauth2LoginService
implements IdPLoginService {
    private static final Logger LOGGER = LogManager.getLogger(Oauth2LoginService.class);

    public void doLogin(HttpServletRequest request, HttpServletResponse response, String provider) {
        HttpServletResponse resp = OAuth2Utils.getResponse();
        OAuth2Configuration configuration = this.oauth2Configuration(provider);
        String login = configuration.buildLoginUri();
        try {
            resp.sendRedirect(login);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Response doInternalRedirect(HttpServletRequest request, HttpServletResponse response, String provider) {
        String token = OAuth2Utils.getAccessToken();
        String refreshToken = OAuth2Utils.getRefreshAccessToken();
        return this.buildCallbackResponse(response, token, refreshToken, provider);
    }

    protected Response.ResponseBuilder getCallbackResponseBuilder(HttpServletResponse response, String token, String refreshToken, String provider) {
        ResponseBuilderImpl result = new ResponseBuilderImpl();
        IdPConfiguration configuration = this.configuration(provider);
        LOGGER.info("Callback Provider: {}", (Object)provider);
        LOGGER.debug("Token: {}", (Object)token);
        LOGGER.debug("Redirect uri: {}", (Object)configuration.getRedirectUri());
        LOGGER.debug("Internal redirect uri: {}", (Object)configuration.getInternalRedirectUri());
        if (token != null) {
            LOGGER.info("AccessToken found");
            SessionToken sessionToken = new SessionToken();
            try {
                result = result.status(302).location(new URI(configuration.getInternalRedirectUri()));
                LOGGER.debug("AccessToken: {}", (Object)token);
                sessionToken.setAccessToken(token);
                if (refreshToken != null) {
                    LOGGER.debug("RefreshToken: {}", (Object)refreshToken);
                    sessionToken.setRefreshToken(refreshToken);
                }
                sessionToken.setTokenType("Bearer");
                TokenStorage tokenStorage = this.tokenStorage();
                Object key = tokenStorage.buildTokenKey();
                tokenStorage.saveToken(key, sessionToken);
                NewCookie cookie = this.cookie("tokens_key", key.toString());
                result.header("Set-Cookie", (Object)cookie.toString());
                cookie = this.cookie("authProvider", provider);
                result.header("Set-Cookie", (Object)cookie.toString());
            }
            catch (URISyntaxException e) {
                LOGGER.error((Object)e);
                result = result.status(Response.Status.INTERNAL_SERVER_ERROR).entity((Object)("Exception while parsing the internal redirect url: " + e.getMessage()));
            }
        } else {
            LOGGER.error("No access token found on callback request: {}", (Object)response.getStatus());
            result = Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)"No access token found.");
        }
        return result;
    }

    public SessionToken getTokenByIdentifier(String provider, String tokenIdentifier) {
        TokenStorage storage = this.tokenStorage();
        SessionToken sessionToken = storage.getTokenByIdentifier(tokenIdentifier);
        if (sessionToken != null) {
            storage.removeTokenByIdentifier(tokenIdentifier);
        }
        return sessionToken;
    }

    protected TokenStorage tokenStorage() {
        return GeoStoreContext.bean(TokenStorage.class);
    }

    protected Response buildCallbackResponse(HttpServletResponse response, String token, String refreshToken, String provider) {
        Response.ResponseBuilder result = this.getCallbackResponseBuilder(response, token, refreshToken, provider);
        return result.build();
    }

    protected OAuth2Configuration oauth2Configuration(String provider) {
        return GeoStoreContext.bean(provider + "OAuth2Config", OAuth2Configuration.class);
    }

    protected IdPConfiguration configuration(String provider) {
        return GeoStoreContext.bean(provider + "OAuth2Config", IdPConfiguration.class);
    }

    protected NewCookie cookie(String name, String value) {
        return this.cookie(name, value, DateUtils.addMinutes((Date)new Date(), (int)2));
    }

    protected NewCookie cookie(String name, String value, Date expires) {
        Cookie cookie = new Cookie(name, value, "/", null);
        return new AccessCookie(cookie, "", 120, DateUtils.addMinutes((Date)new Date(), (int)2), false, false, "lax");
    }
}

