/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.utils;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataURIDecoder {
    public static final String DEFAULT_MEDIA_TYPE = "text/plain";
    public static final String DEFAULT_CHARSET = "US-ASCII";
    final String DATA_URI_REGEX = "data:((?<mediatype>(?<mime>\\w+)/(?<extension>\\w+));)?(charset=(?<charset>[\\w\\s]+);)?(?<encoding>\\w+)?";
    private final boolean valid;
    private String mediatype;
    private String charset;
    private String encoding;
    private boolean base64Encoded;

    public DataURIDecoder(String header) {
        Matcher matcher = Pattern.compile("data:((?<mediatype>(?<mime>\\w+)/(?<extension>\\w+));)?(charset=(?<charset>[\\w\\s]+);)?(?<encoding>\\w+)?").matcher(header);
        if (matcher.matches()) {
            this.valid = true;
            this.mediatype = matcher.group("mediatype");
            this.charset = matcher.group("charset");
            this.encoding = matcher.group("encoding");
            this.base64Encoded = "base64".equals(this.encoding);
        } else {
            this.valid = false;
        }
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getMediatype() {
        return this.mediatype;
    }

    public String getCharset() {
        return this.charset;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isBase64Encoded() {
        return this.base64Encoded;
    }

    public String getNormalizedMediatype() {
        return this.mediatype != null ? this.mediatype : DEFAULT_MEDIA_TYPE;
    }
}

