/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import java.io.IOException;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.oauth2.common.exceptions.InvalidTokenException;
import org.springframework.security.oauth2.provider.OAuth2Authentication;
import org.springframework.security.oauth2.provider.token.AccessTokenConverter;
import org.springframework.security.oauth2.provider.token.RemoteTokenServices;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

public class GeoStoreRemoteTokenServices
extends RemoteTokenServices {
    protected static Logger LOGGER = LogManager.getLogger((String)GeoStoreRemoteTokenServices.class.getName());
    protected RestOperations restTemplate;
    protected String checkTokenEndpointUrl;
    protected String clientId;
    protected String clientSecret;
    protected AccessTokenConverter tokenConverter;

    protected GeoStoreRemoteTokenServices() {
    }

    protected GeoStoreRemoteTokenServices(AccessTokenConverter tokenConverter) {
        this.tokenConverter = tokenConverter;
        this.restTemplate = new RestTemplate();
        ((RestTemplate)this.restTemplate).setErrorHandler((ResponseErrorHandler)new DefaultResponseErrorHandler(){

            public void handleError(ClientHttpResponse response) throws IOException {
                if (response.getRawStatusCode() != 400) {
                    super.handleError(response);
                }
            }
        });
    }

    public void setRestTemplate(RestOperations restTemplate) {
        this.restTemplate = restTemplate;
    }

    public void setCheckTokenEndpointUrl(String checkTokenEndpointUrl) {
        this.checkTokenEndpointUrl = checkTokenEndpointUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setAccessTokenConverter(AccessTokenConverter accessTokenConverter) {
        this.tokenConverter = accessTokenConverter;
    }

    public OAuth2Authentication loadAuthentication(String accessToken) throws AuthenticationException, InvalidTokenException {
        Map<String, Object> checkTokenResponse = this.checkToken(accessToken);
        this.verifyTokenResponse(accessToken, checkTokenResponse);
        this.transformNonStandardValuesToStandardValues(checkTokenResponse);
        return this.tokenConverter.extractAuthentication(checkTokenResponse);
    }

    protected void verifyTokenResponse(String accessToken, Map<String, Object> checkTokenResponse) {
        if (checkTokenResponse.containsKey("error")) {
            this.logger.debug((Object)("check_token returned error: " + checkTokenResponse.get("error")));
            throw new InvalidTokenException(accessToken);
        }
    }

    protected void transformNonStandardValuesToStandardValues(Map<String, Object> map) {
    }

    protected Map<String, Object> checkToken(String accessToken) {
        LinkedMultiValueMap formData = new LinkedMultiValueMap();
        formData.add((Object)"token", (Object)accessToken);
        HttpHeaders headers = new HttpHeaders();
        headers.set("Authorization", this.getAuthorizationHeader(accessToken));
        String accessTokenUrl = this.checkTokenEndpointUrl + "?access_token=" + accessToken;
        return this.sendRequestForMap(accessTokenUrl, (MultiValueMap<String, String>)formData, headers, HttpMethod.POST);
    }

    protected String getAuthorizationHeader(String accessToken) {
        return "Bearer " + accessToken;
    }

    protected Map<String, Object> sendRequestForMap(String path, MultiValueMap<String, String> formData, HttpHeaders headers, HttpMethod method) {
        if (headers.getContentType() == null) {
            headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        }
        ParameterizedTypeReference<Map<String, Object>> map = new ParameterizedTypeReference<Map<String, Object>>(){};
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Executing request " + path + " form data are " + formData);
            LOGGER.debug("Headers are " + headers);
        }
        return (Map)this.restTemplate.exchange(path, method, new HttpEntity(formData, (MultiValueMap)headers), (ParameterizedTypeReference)map, new Object[0]).getBody();
    }
}

