/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.UserSessionService;
import it.geosolutions.geostore.services.dto.UserSession;
import it.geosolutions.geostore.services.dto.UserSessionImpl;
import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.SessionServiceDelegate;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.impl.SessionServiceDelegateImpl;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.provider.authentication.BearerTokenExtractor;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RESTSessionServiceImpl
extends RESTServiceImpl
implements RESTSessionService {
    static final String BEARER_TYPE = "bearer";
    private static final String expireParser = "yyyy-MM-dd'T'HH:mm:ssZ";
    @Autowired
    UserSessionService userSessionService;
    private Map<String, SessionServiceDelegate> delegates;
    private boolean autorefresh = false;
    private long sessionTimeout = 86400L;

    public RESTSessionServiceImpl() {
        this.registerDelegate("DEFAULT", new SessionServiceDelegateImpl());
    }

    public static String fromCalendar(Calendar calendar) {
        Date date = calendar.getTime();
        String formatted = new SimpleDateFormat(expireParser).format(date);
        return formatted.substring(0, 22) + ":" + formatted.substring(22);
    }

    public static Calendar toCalendar(String iso8601string) throws ParseException {
        Calendar calendar = GregorianCalendar.getInstance();
        Object s = iso8601string.replace("Z", "+00:00");
        try {
            s = ((String)s).substring(0, 22) + ((String)s).substring(23);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException("Invalid length", 0);
        }
        Date date = new SimpleDateFormat(expireParser).parse((String)s);
        calendar.setTime(date);
        return calendar;
    }

    public boolean isAutorefresh() {
        return this.autorefresh;
    }

    public void setAutorefresh(boolean autorefresh) {
        this.autorefresh = autorefresh;
    }

    public UserSessionService getUserSessionService() {
        return this.userSessionService;
    }

    public void setUserSessionService(UserSessionService userSessionService) {
        this.userSessionService = userSessionService;
    }

    public User getUser(String sessionId, boolean refresh) {
        SessionServiceDelegate del;
        User user = null;
        Collection<SessionServiceDelegate> list = this.delegates.values();
        Iterator<SessionServiceDelegate> iterator = list.iterator();
        while (iterator.hasNext() && (user = (del = iterator.next()).getUser(sessionId, refresh, this.autorefresh)) == null) {
        }
        return user;
    }

    public String getUserName(String sessionId, boolean refresh) {
        SessionServiceDelegate del;
        String userName = null;
        Collection<SessionServiceDelegate> list = this.delegates.values();
        Iterator<SessionServiceDelegate> iterator = list.iterator();
        while (iterator.hasNext() && (userName = (del = iterator.next()).getUserName(sessionId, refresh, this.autorefresh)) == null) {
        }
        return userName;
    }

    private Calendar getExpiration(String expires) throws ParseException {
        if (!"".equals(expires)) {
            return RESTSessionServiceImpl.toCalendar(expires);
        }
        return null;
    }

    public String createSession(String expires, SecurityContext sc) throws ParseException {
        User user = this.extractAuthUser(sc);
        if (user != null) {
            Calendar expiration = this.getExpiration(expires);
            UserSessionImpl session = null;
            if (user instanceof User) {
                session = new UserSessionImpl(null, user, expiration);
            }
            return this.userSessionService.registerNewSession(session);
        }
        return null;
    }

    public SessionToken login(SecurityContext sc) throws ParseException {
        GregorianCalendar expires = new GregorianCalendar();
        ((Calendar)expires).add(13, (int)this.getSessionTimeout());
        User user = this.extractAuthUser(sc);
        if (user != null) {
            UserSessionImpl session = null;
            if (user instanceof User) {
                session = new UserSessionImpl(null, user, (Calendar)expires);
                session.setExpirationInterval(this.getSessionTimeout());
            }
            return this.toSessionToken(this.userSessionService.registerNewSession(session), (UserSession)session);
        }
        return null;
    }

    private SessionToken toSessionToken(String accessToken, UserSession sessionToken) {
        if (sessionToken == null) {
            return null;
        }
        SessionToken token = new SessionToken();
        token.setAccessToken(accessToken);
        token.setRefreshToken(sessionToken.getRefreshToken());
        token.setExpires(Long.valueOf(sessionToken.getExpirationInterval()));
        token.setTokenType(BEARER_TYPE);
        return token;
    }

    public SessionToken refresh(SecurityContext sc, String sessionId, String refreshToken) {
        String provider = (String)Objects.requireNonNull(RequestContextHolder.getRequestAttributes()).getAttribute("PROVIDER", 0);
        SessionServiceDelegate delegate = this.getDelegate(provider);
        return delegate.refresh(refreshToken, sessionId);
    }

    private SessionServiceDelegate getDelegate(String key) {
        SessionServiceDelegate result = key == null ? this.delegates.get("DEFAULT") : this.delegates.get(key);
        if (result == null) {
            result = this.delegates.get("DEFAULT");
        }
        return result;
    }

    public void removeSession(String sessionId) {
        String provider = (String)RequestContextHolder.getRequestAttributes().getAttribute("PROVIDER", 0);
        SessionServiceDelegate delegate = this.getDelegate(provider);
        delegate.doLogout(sessionId);
    }

    public SessionToken refresh(SessionToken sessionToken) throws ParseException {
        return this.refresh(null, sessionToken.getAccessToken(), sessionToken.getRefreshToken());
    }

    public void removeSession() {
        HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
        Authentication authentication = new BearerTokenExtractor().extract(request);
        if (authentication != null && authentication.getPrincipal() != null) {
            this.removeSession(authentication.getPrincipal().toString());
        }
    }

    public void clear() {
        this.userSessionService.removeAllSessions();
    }

    @Override
    protected SecurityService getSecurityService() {
        return null;
    }

    public long getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(long sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void registerDelegate(String key, SessionServiceDelegate delegate) {
        if (this.delegates == null) {
            this.delegates = new TreeMap<String, SessionServiceDelegate>(String.CASE_INSENSITIVE_ORDER);
        }
        this.delegates.put(key, delegate);
    }
}

