/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.security.oauth2.GeoStoreOAuthRestTemplate;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenProvider;
import org.springframework.security.oauth2.client.token.AccessTokenProviderChain;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.client.ClientCredentialsAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.code.AuthorizationCodeResourceDetails;
import org.springframework.security.oauth2.client.token.grant.implicit.ImplicitAccessTokenProvider;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordAccessTokenProvider;
import org.springframework.security.oauth2.common.AuthenticationScheme;

@Configuration
public abstract class OAuth2GeoStoreSecurityConfiguration
implements ApplicationContextAware {
    static final String DETAILS_ID = "oauth2-client";
    protected ApplicationContext context;
    @Resource
    @Qualifier(value="accessTokenRequest")
    private AccessTokenRequest accessTokenRequest;

    public AccessTokenRequest getAccessTokenRequest() {
        return this.accessTokenRequest;
    }

    protected OAuth2ProtectedResourceDetails resourceDetails() {
        AuthorizationCodeResourceDetails details = new AuthorizationCodeResourceDetails();
        details.setId(this.getDetailsId());
        details.setGrantType("authorization_code");
        details.setAuthenticationScheme(AuthenticationScheme.header);
        details.setClientAuthenticationScheme(AuthenticationScheme.form);
        return details;
    }

    protected String getDetailsId() {
        return DETAILS_ID;
    }

    protected GeoStoreOAuthRestTemplate restTemplate() {
        return new GeoStoreOAuthRestTemplate(this.resourceDetails(), (OAuth2ClientContext)new DefaultOAuth2ClientContext(this.getAccessTokenRequest()), this.configuration());
    }

    public GeoStoreOAuthRestTemplate oauth2RestTemplate() {
        GeoStoreOAuthRestTemplate oAuth2RestTemplate = this.restTemplate();
        this.setJacksonConverter(oAuth2RestTemplate);
        AuthorizationCodeAccessTokenProvider authorizationCodeAccessTokenProvider = new AuthorizationCodeAccessTokenProvider();
        authorizationCodeAccessTokenProvider.setStateMandatory(false);
        AccessTokenProviderChain accessTokenProviderChain = new AccessTokenProviderChain(Arrays.asList(authorizationCodeAccessTokenProvider, new ImplicitAccessTokenProvider(), new ResourceOwnerPasswordAccessTokenProvider(), new ClientCredentialsAccessTokenProvider()));
        oAuth2RestTemplate.setAccessTokenProvider((AccessTokenProvider)accessTokenProviderChain);
        return oAuth2RestTemplate;
    }

    protected void setJacksonConverter(OAuth2RestTemplate oAuth2RestTemplate) {
        List converterList = oAuth2RestTemplate.getMessageConverters();
        MappingJackson2HttpMessageConverter jacksonConverter = null;
        for (HttpMessageConverter converter : converterList) {
            if (!(converter instanceof MappingJackson2HttpMessageConverter)) continue;
            jacksonConverter = (MappingJackson2HttpMessageConverter)converter;
            break;
        }
        if (jacksonConverter == null) {
            jacksonConverter = new MappingJackson2HttpMessageConverter();
            oAuth2RestTemplate.getMessageConverters().add(jacksonConverter);
        }
        jacksonConverter.setSupportedMediaTypes(Collections.singletonList(new MediaType("application", "json", StandardCharsets.UTF_8)));
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    public abstract OAuth2Configuration configuration();
}

