/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.service.impl;

import it.geosolutions.geostore.core.dao.UserGroupDAO;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.impl.RESTUserGroupServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import it.geosolutions.geostore.services.rest.utils.MockSecurityContext;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RESTUserGroupServiceImplTest
extends ServiceTestBase {
    RESTUserGroupServiceImpl restService;
    UserGroupDAO userGroupDAO;

    @Before
    public void setUp() throws BadRequestServiceEx, NotFoundServiceEx {
        this.restService = new RESTUserGroupServiceImpl();
        this.restService.setUserGroupService(userGroupService);
        this.restService.setUserService(userService);
    }

    @After
    public void tearDown() throws Exception {
        this.removeAll();
    }

    @Test
    public void testGetAllWithUsers() throws Exception {
        long adminID = this.createUser("admin", Role.ADMIN, "admin");
        long userID = this.createUser("user", Role.USER, "user");
        this.createUserGroup("group", new long[]{adminID, userID});
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminID));
        UserGroupList res = this.restService.getAll((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(1000), true, true, null);
        List groups = res.getUserGroupList();
        RESTUserGroupServiceImplTest.assertEquals((int)1, (int)groups.size());
        RESTUserGroup group = (RESTUserGroup)groups.get(0);
        RESTUserGroupServiceImplTest.assertEquals((int)2, (int)group.getRestUsers().getList().size());
    }

    @Test
    public void testGetAllWithoutUsers() throws Exception {
        long adminID = this.createUser("admin", Role.ADMIN, "admin");
        long userID = this.createUser("user", Role.USER, "user");
        this.createUserGroup("group", new long[]{adminID, userID});
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminID));
        UserGroupList res = this.restService.getAll((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(1000), true, false, null);
        List groups = res.getUserGroupList();
        RESTUserGroupServiceImplTest.assertEquals((int)1, (int)groups.size());
        RESTUserGroup group = (RESTUserGroup)groups.get(0);
        RESTUserGroupServiceImplTest.assertEquals((int)0, (int)group.getRestUsers().getList().size());
    }

    @Test
    public void testGetAllPagination() throws Exception {
        String firstGroupName = "group1";
        String secondGroupName = "group2";
        String thirdGroupName = "group3";
        long adminID = this.createUser("admin", Role.ADMIN, "admin");
        this.createUserGroup("group1", new long[0]);
        this.createUserGroup("group2", new long[0]);
        this.createUserGroup("group3", new long[0]);
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminID));
        UserGroupList firstPage = this.restService.getAll((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(2), false, false, null);
        List firstPageGroups = firstPage.getUserGroupList();
        List firstPageGroupsNames = firstPageGroups.stream().map(RESTUserGroup::getGroupName).collect(Collectors.toList());
        RESTUserGroupServiceImplTest.assertEquals(List.of("group1", "group2"), firstPageGroupsNames);
        UserGroupList secondPage = this.restService.getAll((SecurityContext)sc, Integer.valueOf(1), Integer.valueOf(2), false, false, null);
        List secondPageGroups = secondPage.getUserGroupList();
        List secondPageGroupsNames = secondPageGroups.stream().map(RESTUserGroup::getGroupName).collect(Collectors.toList());
        RESTUserGroupServiceImplTest.assertEquals(List.of("group3"), secondPageGroupsNames);
    }

    @Test
    public void testGetAllFiltered() throws Exception {
        String groupAName = "group_A";
        String groupBName = "groupB";
        String groupCName = "this is group C";
        long adminID = this.createUser("admin", Role.ADMIN, "admin");
        this.createUserGroup("group_A", new long[0]);
        this.createUserGroup("groupB", new long[0]);
        this.createUserGroup("this is group C", new long[0]);
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminID));
        UserGroupList allGroupsMatched = this.restService.getAll((SecurityContext)sc, null, null, false, false, "group%");
        List allGroupsMatchedGroups = allGroupsMatched.getUserGroupList();
        List allGroupsMatchedGroupsNames = allGroupsMatchedGroups.stream().map(RESTUserGroup::getGroupName).collect(Collectors.toList());
        RESTUserGroupServiceImplTest.assertTrue((boolean)List.of("group_A", "groupB").containsAll(allGroupsMatchedGroupsNames));
        UserGroupList oneGroupMatched = this.restService.getAll((SecurityContext)sc, null, null, false, false, "group_a");
        List oneGroupsMatchedGroups = oneGroupMatched.getUserGroupList();
        List oneGroupMatchedGroupsNames = oneGroupsMatchedGroups.stream().map(RESTUserGroup::getGroupName).collect(Collectors.toList());
        RESTUserGroupServiceImplTest.assertEquals(List.of("group_A"), oneGroupMatchedGroupsNames);
    }
}

