/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.service.impl;

import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ServiceTestBase;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.impl.RESTUserGroupServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import it.geosolutions.geostore.services.rest.utils.MockSecurityContext;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class RESTUserGroupServiceImplTest
extends ServiceTestBase {
    RESTUserGroupServiceImpl restService;
    long adminID;

    @Before
    public void setUp() throws BadRequestServiceEx, NotFoundServiceEx {
        this.restService = new RESTUserGroupServiceImpl();
        this.restService.setUserGroupService(userGroupService);
        this.restService.setUserService(userService);
    }

    @After
    public void tearDown() throws Exception {
        this.removeAll();
    }

    @Test
    public void testGetAllWithUsers() throws Exception {
        long adminID = this.createUser("admin", Role.ADMIN, "admin");
        long userID = this.createUser("user", Role.USER, "user");
        this.createUserGroup("group", new long[]{adminID, userID});
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminID));
        UserGroupList res = this.restService.getAll((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(1000), true, true);
        List groups = res.getUserGroupList();
        RESTUserGroupServiceImplTest.assertEquals((int)1, (int)groups.size());
        RESTUserGroup group = (RESTUserGroup)groups.get(0);
        RESTUserGroupServiceImplTest.assertEquals((int)2, (int)group.getRestUsers().getList().size());
    }

    @Test
    public void testGetAllWithoutUsers() throws Exception {
        long adminID = this.createUser("admin", Role.ADMIN, "admin");
        long userID = this.createUser("user", Role.USER, "user");
        this.createUserGroup("group", new long[]{adminID, userID});
        MockSecurityContext sc = new MockSecurityContext(userService.get(adminID));
        UserGroupList res = this.restService.getAll((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(1000), true, false);
        List groups = res.getUserGroupList();
        RESTUserGroupServiceImplTest.assertEquals((int)1, (int)groups.size());
        RESTUserGroup group = (RESTUserGroup)groups.get(0);
        RESTUserGroupServiceImplTest.assertEquals((int)0, (int)group.getRestUsers().getList().size());
    }
}

