/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.oauth2.openid_connect;

import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2SessionServiceDelegate;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.UserRedirectRequiredException;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

class RefreshTokenServiceTest {
    private TestOAuth2SessionServiceDelegate serviceDelegate;
    private OAuth2Configuration configuration;
    private OAuth2RestTemplate restTemplate;
    private MockHttpServletRequest mockRequest;
    private MockHttpServletResponse mockResponse;
    private DefaultOAuth2AccessToken mockOAuth2AccessToken;
    @Mock
    private TokenAuthenticationCache authenticationCache;

    RefreshTokenServiceTest() {
    }

    @BeforeEach
    void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        this.configuration = (OAuth2Configuration)Mockito.mock(OAuth2Configuration.class);
        this.restTemplate = (OAuth2RestTemplate)Mockito.mock(OAuth2RestTemplate.class);
        this.authenticationCache = (TokenAuthenticationCache)Mockito.mock(TokenAuthenticationCache.class);
        this.serviceDelegate = (TestOAuth2SessionServiceDelegate)((Object)Mockito.spy((Object)((Object)new TestOAuth2SessionServiceDelegate())));
        this.serviceDelegate.setRestTemplate(this.restTemplate);
        this.serviceDelegate.setConfiguration(this.configuration);
        this.serviceDelegate.authenticationCache = this.authenticationCache;
        this.mockRequest = new MockHttpServletRequest();
        this.mockResponse = new MockHttpServletResponse();
        RequestContextHolder.setRequestAttributes((RequestAttributes)new ServletRequestAttributes((HttpServletRequest)this.mockRequest));
        Mockito.when((Object)this.configuration.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getMaxRetries()).thenReturn((Object)3);
        Mockito.when((Object)this.configuration.getClientId()).thenReturn((Object)"testClientId");
        Mockito.when((Object)this.configuration.getClientSecret()).thenReturn((Object)"testClientSecret");
        Mockito.when((Object)this.configuration.buildRefreshTokenURI()).thenReturn((Object)"https://example.com/oauth2/token");
        this.mockOAuth2AccessToken = new DefaultOAuth2AccessToken("providedAccessToken");
        DefaultOAuth2RefreshToken mockRefreshToken = new DefaultOAuth2RefreshToken("existingRefreshToken");
        this.mockOAuth2AccessToken.setRefreshToken((OAuth2RefreshToken)mockRefreshToken);
        this.mockOAuth2AccessToken.setExpiration(new Date(System.currentTimeMillis() + 3600000L));
        this.serviceDelegate.currentAccessToken = this.mockOAuth2AccessToken;
        Authentication mockAuthentication = (Authentication)Mockito.mock(Authentication.class);
        TokenDetails mockTokenDetails = (TokenDetails)Mockito.mock(TokenDetails.class);
        Mockito.when((Object)mockTokenDetails.getIdToken()).thenReturn((Object)"mockIdToken");
        ((TestOAuth2SessionServiceDelegate)((Object)Mockito.doReturn((Object)mockTokenDetails).when((Object)this.serviceDelegate))).getTokenDetails(mockAuthentication);
        Mockito.when((Object)this.authenticationCache.get("providedAccessToken")).thenReturn((Object)mockAuthentication);
        SecurityContext securityContext = (SecurityContext)Mockito.mock(SecurityContext.class);
        Mockito.when((Object)securityContext.getAuthentication()).thenReturn((Object)mockAuthentication);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
    }

    @AfterEach
    void tearDown() {
        RequestContextHolder.resetRequestAttributes();
        Mockito.framework().clearInlineMocks();
    }

    @Test
    void testRefreshWithValidTokens() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "providedAccessToken";
        DefaultOAuth2AccessToken newAccessToken = new DefaultOAuth2AccessToken("newAccessToken");
        DefaultOAuth2RefreshToken newRefreshToken = new DefaultOAuth2RefreshToken("newRefreshToken");
        newAccessToken.setRefreshToken((OAuth2RefreshToken)newRefreshToken);
        newAccessToken.setExpiration(new Date(System.currentTimeMillis() + 0x6DDD00L));
        ResponseEntity responseEntity = new ResponseEntity((Object)newAccessToken, HttpStatus.OK);
        Mockito.when((Object)this.configuration.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.configuration.getClientId()).thenReturn((Object)"testClientId");
        Mockito.when((Object)this.configuration.getClientSecret()).thenReturn((Object)"testClientSecret");
        Mockito.when((Object)this.configuration.buildRefreshTokenURI()).thenReturn((Object)"https://example.com/oauth2/token");
        Mockito.when((Object)this.configuration.getInitialBackoffDelay()).thenReturn((Object)1000L);
        Mockito.when((Object)this.configuration.getMaxRetries()).thenReturn((Object)3);
        Mockito.when((Object)this.restTemplate.exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0])).thenReturn((Object)responseEntity);
        Mockito.when((Object)this.serviceDelegate.getRequest()).thenReturn((Object)this.mockRequest);
        Mockito.when((Object)this.serviceDelegate.getResponse()).thenReturn((Object)this.mockResponse);
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null");
        Assertions.assertEquals((Object)"newAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should be updated");
        Assertions.assertEquals((Object)"newRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should be updated");
        Assertions.assertTrue((sessionToken.getExpires() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Token expiration should be in the future");
        Assertions.assertEquals((Object)"bearer", (Object)sessionToken.getTokenType(), (String)"Token type should be 'bearer'");
        ((TokenAuthenticationCache)Mockito.verify((Object)this.authenticationCache)).putCacheEntry((String)Mockito.eq((Object)"newAccessToken"), (Authentication)Mockito.any(Authentication.class));
        ((TestOAuth2SessionServiceDelegate)((Object)Mockito.verify((Object)((Object)this.serviceDelegate), (VerificationMode)Mockito.never()))).handleRefreshFailure(Mockito.anyString(), Mockito.anyString(), (OAuth2Configuration)Mockito.any(OAuth2Configuration.class));
    }

    @Test
    void testRefreshWithInvalidRefreshToken() {
        String refreshToken = "invalidRefreshToken";
        String accessToken = "providedAccessToken";
        Mockito.when((Object)this.restTemplate.exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0])).thenThrow(new Throwable[]{new HttpClientErrorException(HttpStatus.BAD_REQUEST)});
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null even when refresh fails");
        Assertions.assertEquals((Object)"providedAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should remain unchanged");
        Assertions.assertEquals((Object)"existingRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should remain unchanged");
        Assertions.assertNotNull((Object)sessionToken.getWarning(), (String)"Warning message should be set");
        Assertions.assertTrue((boolean)sessionToken.getWarning().contains("Using existing access token."), (String)"Expected error message in SessionToken");
    }

    @Test
    void testRefreshWithServerError() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "providedAccessToken";
        Mockito.when((Object)this.restTemplate.exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0])).thenThrow(new Throwable[]{new HttpServerErrorException(HttpStatus.INTERNAL_SERVER_ERROR)});
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null even when refresh fails");
        Assertions.assertEquals((Object)"providedAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should remain unchanged after server error");
        Assertions.assertEquals((Object)"existingRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should remain unchanged after server error");
        Assertions.assertNotNull((Object)sessionToken.getWarning(), (String)"Warning message should be set");
        Assertions.assertTrue((boolean)sessionToken.getWarning().contains("Using existing access token."), (String)"Expected error message in SessionToken");
        ((OAuth2RestTemplate)Mockito.verify((Object)this.restTemplate, (VerificationMode)Mockito.times((int)3))).exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0]);
    }

    @Test
    void testRefreshWithNullResponse() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "providedAccessToken";
        ResponseEntity responseEntity = new ResponseEntity(null, HttpStatus.OK);
        Mockito.when((Object)this.restTemplate.exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0])).thenReturn((Object)responseEntity);
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null even when response is null");
        Assertions.assertEquals((Object)"providedAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should remain unchanged");
        Assertions.assertEquals((Object)"existingRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should remain unchanged");
        Assertions.assertNotNull((Object)sessionToken.getWarning(), (String)"Warning message should be set");
        Assertions.assertTrue((boolean)sessionToken.getWarning().contains("Using existing access token."), (String)"Expected warning message in SessionToken");
    }

    @Test
    void testRefreshWhenConfigurationDisabled() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "providedAccessToken";
        Mockito.when((Object)this.configuration.isEnabled()).thenReturn((Object)false);
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null when configuration is disabled");
        Assertions.assertEquals((Object)"providedAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should remain unchanged");
        Assertions.assertEquals((Object)"existingRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should remain unchanged");
        ((OAuth2RestTemplate)Mockito.verify((Object)this.restTemplate, (VerificationMode)Mockito.never())).exchange(Mockito.anyString(), (HttpMethod)Mockito.any(HttpMethod.class), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0]);
    }

    @Test
    void testRefreshWithMissingAccessToken() {
        String refreshToken = "providedRefreshToken";
        String accessToken = null;
        Exception exception = (Exception)Assertions.assertThrows(RuntimeException.class, () -> this.serviceDelegate.refresh(refreshToken, accessToken));
        Assertions.assertTrue((boolean)exception.getMessage().contains("Either the accessToken or the refresh token are missing"), (String)"Expected exception message");
    }

    @Test
    void testRefreshWhenCacheReturnsNullAuthentication() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "providedAccessToken";
        Mockito.when((Object)this.authenticationCache.get("providedAccessToken")).thenReturn(null);
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null even when authentication is not found in cache");
        Assertions.assertEquals((Object)"providedAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should remain unchanged");
        Assertions.assertEquals((Object)"existingRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should remain unchanged");
    }

    @Test
    void testRefreshWhenAuthenticationIsAnonymous() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "providedAccessToken";
        Authentication anonymousAuthentication = (Authentication)Mockito.mock(AnonymousAuthenticationToken.class);
        Mockito.when((Object)this.authenticationCache.get("providedAccessToken")).thenReturn((Object)anonymousAuthentication);
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null even when authentication is anonymous");
        Assertions.assertEquals((Object)"providedAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should remain unchanged");
        Assertions.assertEquals((Object)"existingRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should remain unchanged");
    }

    @Test
    void testRefreshWithExpiredAccessToken() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "expiredAccessToken";
        this.mockOAuth2AccessToken.setExpiration(new Date(System.currentTimeMillis() - 1000L));
        this.serviceDelegate.currentAccessToken = this.mockOAuth2AccessToken;
        DefaultOAuth2AccessToken newAccessToken = new DefaultOAuth2AccessToken("newAccessToken");
        DefaultOAuth2RefreshToken newRefreshToken = new DefaultOAuth2RefreshToken("newRefreshToken");
        newAccessToken.setRefreshToken((OAuth2RefreshToken)newRefreshToken);
        newAccessToken.setExpiration(new Date(System.currentTimeMillis() + 0x6DDD00L));
        ResponseEntity responseEntity = new ResponseEntity((Object)newAccessToken, HttpStatus.OK);
        Mockito.when((Object)this.restTemplate.exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0])).thenReturn((Object)responseEntity);
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null");
        Assertions.assertEquals((Object)"newAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should be updated");
        Assertions.assertEquals((Object)"newRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should be updated");
        Assertions.assertTrue((sessionToken.getExpires() > System.currentTimeMillis() ? 1 : 0) != 0, (String)"Token expiration should be in the future");
    }

    @Test
    void testRefreshWithExpiredTokenAndUnsuccessfulRefresh() {
        String refreshToken = "expiredRefreshToken";
        String accessToken = "expiredAccessToken";
        this.mockOAuth2AccessToken.setExpiration(new Date(System.currentTimeMillis() - 300000L));
        this.serviceDelegate.currentAccessToken = this.mockOAuth2AccessToken;
        Mockito.when((Object)this.restTemplate.exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0])).thenThrow(new Throwable[]{new HttpClientErrorException(HttpStatus.UNAUTHORIZED)});
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNull((Object)sessionToken, (String)"SessionToken should be null when the token is expired and cannot be refreshed");
        ((OAuth2RestTemplate)Mockito.verify((Object)this.restTemplate, (VerificationMode)Mockito.times((int)3))).exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0]);
    }

    @Test
    void testRefreshWithUserRedirectRequiredException() {
        String refreshToken = "providedRefreshToken";
        String accessToken = "providedAccessToken";
        Mockito.when((Object)this.restTemplate.exchange(Mockito.anyString(), (HttpMethod)Mockito.eq((Object)HttpMethod.POST), (HttpEntity)Mockito.any(HttpEntity.class), (Class)Mockito.eq(OAuth2AccessToken.class), new Object[0])).thenThrow(new Throwable[]{new UserRedirectRequiredException("redirect_uri", new HashMap())});
        SessionToken sessionToken = this.serviceDelegate.refresh(refreshToken, accessToken);
        Assertions.assertNotNull((Object)sessionToken, (String)"SessionToken should not be null even when redirect is required");
        Assertions.assertEquals((Object)"providedAccessToken", (Object)sessionToken.getAccessToken(), (String)"Access token should remain unchanged");
        Assertions.assertEquals((Object)"existingRefreshToken", (Object)sessionToken.getRefreshToken(), (String)"Refresh token should remain unchanged");
        Assertions.assertNotNull((Object)sessionToken.getWarning(), (String)"Warning message should be set");
        Assertions.assertTrue((boolean)sessionToken.getWarning().contains("A redirect is required to get the user's approval"), (String)"Expected redirect warning message in SessionToken");
        ((TestOAuth2SessionServiceDelegate)((Object)Mockito.verify((Object)((Object)this.serviceDelegate), (VerificationMode)Mockito.never()))).handleRefreshFailure(Mockito.anyString(), Mockito.anyString(), (OAuth2Configuration)Mockito.any(OAuth2Configuration.class));
    }

    class TestOAuth2SessionServiceDelegate
    extends OAuth2SessionServiceDelegate {
        private OAuth2RestTemplate restTemplate;
        private OAuth2Configuration configuration;
        private OAuth2AccessToken currentAccessToken;
        protected TokenAuthenticationCache authenticationCache;

        public TestOAuth2SessionServiceDelegate() {
            super(null, null);
        }

        public void setRestTemplate(OAuth2RestTemplate restTemplate) {
            this.restTemplate = restTemplate;
        }

        public void setConfiguration(OAuth2Configuration configuration) {
            this.configuration = configuration;
        }

        protected OAuth2RestTemplate restTemplate() {
            return this.restTemplate;
        }

        protected OAuth2Configuration configuration() {
            return this.configuration;
        }

        protected HttpServletRequest getRequest() {
            return RefreshTokenServiceTest.this.mockRequest;
        }

        protected HttpServletResponse getResponse() {
            return RefreshTokenServiceTest.this.mockResponse;
        }

        protected TokenDetails getTokenDetails(Authentication authentication) {
            return super.getTokenDetails(authentication);
        }

        protected OAuth2AccessToken retrieveAccessToken(String accessToken, Long expires) {
            return this.currentAccessToken;
        }

        protected TokenAuthenticationCache cache() {
            return this.authenticationCache;
        }

        protected void updateAuthToken(String oldAccessToken, OAuth2AccessToken newAccessToken, OAuth2RefreshToken newRefreshToken, OAuth2Configuration configuration) {
            this.currentAccessToken = newAccessToken;
            Authentication newAuthentication = (Authentication)Mockito.mock(Authentication.class);
            TokenDetails newTokenDetails = (TokenDetails)Mockito.mock(TokenDetails.class);
            Mockito.when((Object)newTokenDetails.getAccessToken()).thenReturn((Object)newAccessToken);
            Mockito.when((Object)OAuth2Utils.getTokenDetails((Authentication)newAuthentication)).thenReturn((Object)newTokenDetails);
            this.authenticationCache.removeEntry(oldAccessToken);
            this.authenticationCache.putCacheEntry(newAccessToken.getValue(), newAuthentication);
        }
    }
}

