/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.UserSessionService;
import it.geosolutions.geostore.services.dto.UserSession;
import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.SessionServiceDelegate;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import org.springframework.beans.factory.annotation.Autowired;

public class SessionServiceDelegateImpl
implements SessionServiceDelegate {
    public static final String DEFAULT_NAME = "DEFAULT";
    @Autowired
    private UserSessionService userSessionService;

    public SessionServiceDelegateImpl(RESTSessionService restSessionService) {
        restSessionService.registerDelegate(DEFAULT_NAME, (SessionServiceDelegate)this);
    }

    public SessionServiceDelegateImpl() {
    }

    public SessionToken refresh(String refreshToken, String accessToken) {
        UserSession sessionToken = this.userSessionService.refreshSession(accessToken, refreshToken);
        if (sessionToken == null) {
            throw new ForbiddenErrorWebEx("Refresh token was not provided or session is already expired.");
        }
        SessionToken token = new SessionToken();
        token.setAccessToken(accessToken);
        token.setRefreshToken(sessionToken.getRefreshToken());
        token.setExpires(Long.valueOf(sessionToken.getExpirationInterval()));
        token.setTokenType("bearer");
        return token;
    }

    public void doLogout(String sessionId) {
        this.userSessionService.removeSession(sessionId);
    }

    public void setUserSessionService(UserSessionService userSessionService) {
        this.userSessionService = userSessionService;
    }

    public User getUser(String sessionId, boolean refresh, boolean autorefresh) {
        User details = null;
        if (this.userSessionService != null && (details = this.userSessionService.getUserData(sessionId)) != null && refresh && autorefresh) {
            this.userSessionService.refreshSession(sessionId, this.userSessionService.getRefreshToken(sessionId));
        }
        return details;
    }

    public String getUserName(String sessionId, boolean refresh, boolean autorefresh) {
        User userData = this.getUser(sessionId, refresh, autorefresh);
        if (userData != null) {
            return userData.getName();
        }
        return null;
    }
}

