/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.DuplicatedResourceNameServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import it.geosolutions.geostore.services.rest.RESTResourceService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ConflictWebEx;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.RESTAttribute;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.ResourceList;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.model.ShortAttributeList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.utils.Convert;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTResourceServiceImpl
extends RESTServiceImpl
implements RESTResourceService {
    private static final Logger LOGGER = LogManager.getLogger(RESTResourceServiceImpl.class);
    private ResourceService resourceService;

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    @Override
    protected SecurityService getSecurityService() {
        return this.resourceService;
    }

    public long insert(SecurityContext sc, RESTResource resource) {
        if (resource == null) {
            throw new BadRequestWebEx("Resource is null");
        }
        if (resource.getId() != null) {
            throw new BadRequestWebEx("Id should be null");
        }
        if (resource.getCategory() == null) {
            throw new BadRequestWebEx("Category should be not null");
        }
        User authUser = this.extractAuthUser(sc);
        ArrayList<SecurityRule> securities = new ArrayList<SecurityRule>();
        SecurityRule userSecurityRule = new SecurityRule();
        userSecurityRule.setCanRead(true);
        userSecurityRule.setCanWrite(true);
        userSecurityRule.setUser(authUser);
        securities.add(userSecurityRule);
        Resource r = Convert.convertResource(resource);
        r.setSecurity(securities);
        try {
            return this.resourceService.insert(r);
        }
        catch (BadRequestServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
        catch (NotFoundServiceEx e) {
            throw new NotFoundWebEx(e.getMessage());
        }
        catch (DuplicatedResourceNameServiceEx e) {
            throw new ConflictWebEx(e.getMessage());
        }
    }

    public long update(SecurityContext sc, long id, RESTResource resource) throws NotFoundWebEx, BadRequestWebEx {
        try {
            if (resource == null) {
                throw new BadRequestWebEx("Resource is null");
            }
            resource.setId(Long.valueOf(id));
            Resource old = this.resourceService.get(id);
            if (old == null) {
                throw new NotFoundWebEx("Resource not found");
            }
            if (resource.getCategory() != null) {
                RESTCategory newrc = resource.getCategory();
                Category oldrc = old.getCategory();
                if (newrc.getId() != null && !newrc.getId().equals(oldrc.getId()) || newrc.getName() != null && !newrc.getName().equals(oldrc.getName())) {
                    LOGGER.info("Trying to change category old(" + oldrc.getId() + ":" + oldrc.getName() + ") new(" + newrc.getId() + ":" + newrc.getName() + ")");
                    throw new BadRequestWebEx("Can't change resource category");
                }
            }
            boolean canUpdate = false;
            User authUser = this.extractAuthUser(sc);
            canUpdate = this.resourceAccessWrite(authUser, old.getId());
            if (canUpdate) {
                if (resource.getDescription() != null) {
                    old.setDescription(resource.getDescription());
                }
                if (resource.getName() != null) {
                    old.setName(resource.getName());
                }
                if (resource.getMetadata() != null) {
                    old.setMetadata(resource.getMetadata());
                }
                if (resource.getCreator() != null) {
                    old.setCreator(resource.getCreator());
                }
                old.setEditor(authUser.getName());
                old.setAdvertised(Boolean.valueOf(resource.isAdvertised()));
                try {
                    this.resourceService.update(old);
                }
                catch (DuplicatedResourceNameServiceEx e) {
                    throw new ConflictWebEx(e.getMessage());
                }
                if (resource.getAttribute() == null) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Attribute list is null: no change in the attrib list");
                    }
                } else {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Attribute list is " + resource.getAttribute().size());
                    }
                    List<Attribute> attributes = Convert.convertAttributeList(resource.getAttribute());
                    this.resourceService.updateAttributes(id, attributes);
                }
                return id;
            }
            throw new ForbiddenErrorWebEx("Can't update resource");
        }
        catch (NotFoundServiceEx ex) {
            LOGGER.warn("Resource not found (" + id + "): " + ex.getMessage(), (Throwable)ex);
            throw new NotFoundWebEx("Resource not found");
        }
    }

    public void delete(SecurityContext sc, long id) throws NotFoundWebEx {
        boolean canDelete = false;
        User authUser = this.extractAuthUser(sc);
        canDelete = this.resourceAccessWrite(authUser, id);
        if (canDelete) {
            boolean ret = this.resourceService.delete(id);
            if (!ret) {
                throw new NotFoundWebEx("Resource not found");
            }
        } else {
            throw new ForbiddenErrorWebEx("This user cannot delete this resource !");
        }
    }

    public void deleteResources(SecurityContext sc, SearchFilter filter) throws BadRequestWebEx, InternalErrorWebEx {
        try {
            this.resourceService.deleteResources(filter);
        }
        catch (BadRequestServiceEx e) {
            if (LOGGER.isEnabled(Level.ERROR)) {
                LOGGER.error(e.getMessage());
            }
            throw new BadRequestWebEx(e.getMessage());
        }
        catch (InternalErrorServiceEx e) {
            if (LOGGER.isEnabled(Level.ERROR)) {
                LOGGER.error(e.getMessage());
            }
            throw new InternalErrorWebEx(e.getMessage());
        }
    }

    public Resource get(SecurityContext sc, long id, boolean fullResource) throws NotFoundWebEx {
        boolean canRead = false;
        User authUser = this.extractAuthUser(sc);
        canRead = this.resourceAccessRead(authUser, id);
        if (!canRead) {
            throw new ForbiddenErrorWebEx("This user cannot read this resource !");
        }
        if (fullResource) {
            List resourcesFull;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Retrieving a full resource");
            }
            try {
                FieldFilter filter = new FieldFilter(BaseField.ID, Long.toString(id), SearchOperator.EQUAL_TO);
                resourcesFull = this.resourceService.getResourcesFull(ResourceSearchParameters.builder().filter((SearchFilter)filter).authUser(authUser).build());
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
                throw new InternalErrorWebEx("Internal error");
            }
            if (resourcesFull.isEmpty()) {
                throw new NotFoundWebEx("Resource not found");
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("DATA is " + ((Resource)resourcesFull.get(0)).getData());
            }
            return (Resource)resourcesFull.get(0);
        }
        Resource ret = this.resourceService.get(id);
        if (ret == null) {
            throw new NotFoundWebEx("Resource not found");
        }
        if (ret.getData() != null) {
            LOGGER.warn("Resource has data attached. It should not. Please check.");
            ret.setData(null);
        }
        return ret;
    }

    public ShortResourceList getList(SecurityContext sc, String nameLike, Integer page, Integer entries) throws BadRequestWebEx {
        User authUser = this.extractAuthUser(sc);
        nameLike = nameLike.replaceAll("[*]", "%");
        try {
            return new ShortResourceList(this.resourceService.getList(ResourceSearchParameters.builder().nameLike(nameLike).page(page).entries(entries).authUser(authUser).build()));
        }
        catch (BadRequestServiceEx | InternalErrorServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
    }

    public ShortResourceList getAll(SecurityContext sc, Integer page, Integer entries) throws BadRequestWebEx {
        User authUser = this.extractAuthUser(sc);
        try {
            return new ShortResourceList(this.resourceService.getAll(ResourceSearchParameters.builder().page(page).entries(entries).authUser(authUser).build()));
        }
        catch (BadRequestServiceEx | InternalErrorServiceEx ex) {
            throw new BadRequestWebEx(ex.getMessage());
        }
    }

    public long getCount(SecurityContext sc, String nameLike) {
        nameLike = nameLike.replaceAll("[*]", "%");
        return this.resourceService.getCount(nameLike);
    }

    private long parseId(SecurityContext sc, String id) throws BadRequestWebEx {
        try {
            return Long.parseLong(id);
        }
        catch (Exception e) {
            LOGGER.info("Bad id requested '" + id + "'");
            throw new BadRequestWebEx("Bad id");
        }
    }

    public ShortAttributeList getAttributes(SecurityContext sc, long id) throws NotFoundWebEx {
        Resource resource = this.resourceService.get(id);
        if (resource == null) {
            throw new NotFoundWebEx("Resource not found");
        }
        boolean canRead = false;
        User authUser = this.extractAuthUser(sc);
        canRead = this.resourceAccessRead(authUser, id);
        if (canRead) {
            return new ShortAttributeList(this.resourceService.getAttributes(id));
        }
        throw new ForbiddenErrorWebEx("This user cannot read this resource so neither its attributes!");
    }

    public String getAttribute(SecurityContext sc, long id, String name) throws NotFoundWebEx {
        Resource resource = this.resourceService.get(id);
        if (resource == null) {
            throw new NotFoundWebEx("Resource not found");
        }
        boolean canRead = false;
        User authUser = this.extractAuthUser(sc);
        canRead = this.resourceAccessRead(authUser, id);
        if (canRead) {
            ShortAttribute shAttribute = this.resourceService.getAttribute(id, name);
            if (shAttribute == null) {
                throw new NotFoundWebEx("Resource attribute not found");
            }
            return shAttribute.getValue();
        }
        throw new ForbiddenErrorWebEx("This user cannot read this resource so neither its attributes!");
    }

    public long updateAttribute(SecurityContext sc, long id, String name, String value, DataType type) throws NotFoundWebEx, InternalErrorWebEx {
        long attributeId;
        Resource resource = this.resourceService.get(id);
        if (resource == null) {
            throw new NotFoundWebEx("Resource not found");
        }
        boolean canUpdate = false;
        try {
            User authUser = this.extractAuthUser(sc);
            canUpdate = this.resourceAccessWrite(authUser, resource.getId());
            if (canUpdate) {
                ShortAttribute a = this.resourceService.getAttribute(id, name);
                attributeId = a != null ? this.resourceService.updateAttribute(id, name, value) : (type != null ? this.resourceService.insertAttribute(id, name, value, type) : this.resourceService.insertAttribute(id, name, value, DataType.STRING));
            } else {
                throw new InternalErrorServiceEx("This user cannot access this resource !");
            }
            resource.setEditor(authUser.getName());
            this.resourceService.update(resource);
        }
        catch (InternalErrorServiceEx ex) {
            throw new InternalErrorWebEx(ex.getMessage());
        }
        catch (DuplicatedResourceNameServiceEx | NotFoundServiceEx e) {
            throw new RuntimeException(e);
        }
        return attributeId;
    }

    public long updateAttribute(SecurityContext sc, long id, String name, String value) {
        return this.updateAttribute(sc, id, name, value, null);
    }

    public long updateAttribute(SecurityContext sc, long id, RESTAttribute content) {
        if (content != null && content.getName() != null) {
            return this.updateAttribute(sc, id, content.getName(), content.getValue(), content.getType());
        }
        throw new BadRequestWebEx("missing attribute content or attribute name in request");
    }

    public ShortResourceList getResources(SecurityContext sc, SearchFilter filter) {
        User authUser = this.extractAuthUser(sc);
        try {
            return new ShortResourceList(this.resourceService.getShortResources(ResourceSearchParameters.builder().filter(filter).authUser(authUser).build()));
        }
        catch (BadRequestServiceEx e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(e.getMessage());
            }
            throw new BadRequestWebEx(e.getMessage());
        }
        catch (InternalErrorServiceEx e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(e.getMessage());
            }
            throw new InternalErrorWebEx(e.getMessage());
        }
    }

    public ResourceList getResourcesList(SecurityContext sc, Integer page, Integer entries, boolean includeAttributes, boolean includeData, SearchFilter filter) {
        User authUser = this.extractAuthUser(sc);
        try {
            return new ResourceList(this.resourceService.getResources(ResourceSearchParameters.builder().filter(filter).page(page).entries(entries).includeAttributes(includeAttributes).includeData(includeData).authUser(authUser).build()));
        }
        catch (BadRequestServiceEx e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(e.getMessage());
            }
            throw new BadRequestWebEx(e.getMessage());
        }
        catch (InternalErrorServiceEx e) {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(e.getMessage());
            }
            throw new InternalErrorWebEx(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSecurityRules(SecurityContext sc, long id, SecurityRuleList securityRules) {
        boolean canWrite = false;
        User authUser = this.extractAuthUser(sc);
        canWrite = this.resourceAccessWrite(authUser, id);
        if (!canWrite) throw new ForbiddenErrorWebEx("This user cannot write this resource so neither its permissions!");
        ShortAttribute owner = this.resourceService.getAttribute(id, "owner");
        if (authUser.getRole() != Role.ADMIN && owner != null && !owner.getValue().equals(authUser.getName())) throw new ForbiddenErrorWebEx("This user cannot update this resource permissions!");
        try {
            this.resourceService.updateSecurityRules(id, Convert.convertSecurityRuleList(securityRules.getList(), id));
            return;
        }
        catch (BadRequestServiceEx e) {
            if (!LOGGER.isInfoEnabled()) throw new BadRequestWebEx(e.getMessage());
            LOGGER.info(e.getMessage());
            throw new BadRequestWebEx(e.getMessage());
        }
        catch (InternalErrorServiceEx e) {
            if (!LOGGER.isInfoEnabled()) throw new InternalErrorWebEx(e.getMessage());
            LOGGER.info(e.getMessage());
            throw new InternalErrorWebEx(e.getMessage());
        }
        catch (NotFoundServiceEx e) {
            if (!LOGGER.isInfoEnabled()) throw new NotFoundWebEx(e.getMessage());
            LOGGER.info(e.getMessage());
            throw new NotFoundWebEx(e.getMessage());
        }
    }

    public SecurityRuleList getSecurityRules(SecurityContext sc, long id) {
        boolean canRead = false;
        User authUser = this.extractAuthUser(sc);
        canRead = this.resourceAccessRead(authUser, id);
        if (canRead) {
            ShortAttribute owner = this.resourceService.getAttribute(id, "owner");
            if (authUser.getRole() == Role.ADMIN || owner == null || owner.getValue().equals(authUser.getName())) {
                return new SecurityRuleList(this.resourceService.getSecurityRules(id));
            }
            throw new ForbiddenErrorWebEx("This user cannot read this resource permissions!");
        }
        throw new ForbiddenErrorWebEx("This user cannot read this resource so neither its permissions!");
    }
}

