/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.rest.security.keycloak;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.UserGroupAttribute;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.NotFoundServiceEx;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

class MockUserGroupService
implements UserGroupService {
    private final Map<String, UserGroup> groups = new ConcurrentHashMap<String, UserGroup>();
    private final AtomicLong atomicLong = new AtomicLong();

    MockUserGroupService() {
    }

    public long insert(UserGroup userGroup) throws BadRequestServiceEx {
        Long id = this.atomicLong.incrementAndGet();
        userGroup.setId(id);
        this.groups.put(userGroup.getGroupName(), userGroup);
        return id;
    }

    public boolean delete(long id) throws NotFoundServiceEx, BadRequestServiceEx {
        return false;
    }

    public void assignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
    }

    public void deassignUserGroup(long userId, long groupId) throws NotFoundServiceEx {
    }

    public List<UserGroup> getAll(Integer page, Integer entries) throws BadRequestServiceEx {
        return null;
    }

    public List<UserGroup> getAllAllowed(User user, Integer page, Integer entries, String nameLike, boolean all) throws BadRequestServiceEx {
        return null;
    }

    public UserGroup get(long id) throws BadRequestServiceEx {
        return this.groups.values().stream().filter(g -> g.getId().equals(id)).findAny().get();
    }

    public List<ShortResource> updateSecurityRules(Long groupId, List<Long> resourcesToSet, boolean canRead, boolean canWrite) throws NotFoundServiceEx, BadRequestServiceEx {
        return null;
    }

    public boolean insertSpecialUsersGroups() {
        return false;
    }

    public boolean removeSpecialUsersGroups() {
        return false;
    }

    public UserGroup get(String name) {
        return this.groups.get(name);
    }

    public long getCount(User authUser, String nameLike) throws BadRequestServiceEx {
        return 0L;
    }

    public long getCount(User authUser, String nameLike, boolean all) throws BadRequestServiceEx {
        return 0L;
    }

    public void updateAttributes(long id, List<UserGroupAttribute> attributes) throws NotFoundServiceEx {
    }

    public long update(UserGroup group) throws NotFoundServiceEx, BadRequestServiceEx {
        return 0L;
    }

    public Collection<UserGroup> findByAttribute(String name, List<String> values, boolean ignoreCase) {
        return null;
    }
}

