/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2.openid_connect;

import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import java.util.Collections;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

public class OpenIdConnectConfiguration
extends OAuth2Configuration {
    String jwkURI;
    String postLogoutRedirectUri;
    boolean sendClientSecret = false;
    boolean allowBearerTokens = true;
    boolean usePKCE = false;

    public String getJwkURI() {
        return this.jwkURI;
    }

    public void setJwkURI(String jwkURI) {
        this.jwkURI = jwkURI;
    }

    public String getPostLogoutRedirectUri() {
        return this.postLogoutRedirectUri;
    }

    public void setPostLogoutRedirectUri(String postLogoutRedirectUri) {
        this.postLogoutRedirectUri = postLogoutRedirectUri;
    }

    public boolean isSendClientSecret() {
        return this.sendClientSecret;
    }

    public void setSendClientSecret(boolean sendClientSecret) {
        this.sendClientSecret = sendClientSecret;
    }

    public boolean isAllowBearerTokens() {
        return this.allowBearerTokens;
    }

    public void setAllowBearerTokens(boolean allowBearerTokens) {
        this.allowBearerTokens = allowBearerTokens;
    }

    public boolean isUsePKCE() {
        return this.usePKCE;
    }

    public void setUsePKCE(boolean usePKCE) {
        this.usePKCE = usePKCE;
    }

    @Override
    public OAuth2Configuration.Endpoint buildLogoutEndpoint(String token, String accessToken, OAuth2Configuration configuration) {
        String idToken;
        OAuth2Configuration.Endpoint result = null;
        String uri = this.getLogoutUri();
        String string = idToken = OAuth2Utils.getIdToken() != null ? OAuth2Utils.getIdToken() : accessToken;
        if (uri != null) {
            HttpHeaders headers = new HttpHeaders();
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            if (idToken != null) {
                params.put((Object)"token_type_hint", Collections.singletonList("id_token"));
                headers.set("Authorization", "Bearer " + idToken);
            }
            if (StringUtils.hasText((String)this.getPostLogoutRedirectUri())) {
                params.put((Object)"post_logout_redirect_uri", Collections.singletonList(this.getPostLogoutRedirectUri()));
            }
            OpenIdConnectConfiguration.getLogoutRequestParams(token, this.clientId, (MultiValueMap<String, String>)params);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            result = new OAuth2Configuration.Endpoint(HttpMethod.GET, this.appendParameters((MultiValueMap<String, String>)params, uri));
            result.setRequestEntity(requestEntity);
        }
        return result;
    }
}

