/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2GeoStoreAuthenticationFilter;
import java.util.Collections;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.util.UriComponentsBuilder;

public class OAuth2Configuration
extends IdPConfiguration {
    public static final String CONFIG_NAME_SUFFIX = "OAuth2Config";
    public static final String CONFIGURATION_NAME = "CONFIGURATION_NAME";
    private static final Logger LOGGER = LogManager.getLogger(OAuth2GeoStoreAuthenticationFilter.class);
    protected String clientId;
    protected String clientSecret;
    protected String accessTokenUri;
    protected String authorizationUri;
    protected String checkTokenEndpointUrl;
    protected String logoutUri;
    protected boolean globalLogoutEnabled = false;
    protected String scopes;
    protected String idTokenUri;
    protected String discoveryUrl;
    protected String revokeEndpoint;
    protected boolean enableRedirectEntryPoint = false;
    protected String principalKey;
    protected String rolesClaim;
    protected String groupsClaim;

    public AuthenticationEntryPoint getAuthenticationEntryPoint() {
        return (request, response, authException) -> {
            String loginUri = this.buildLoginUri();
            response.sendRedirect(loginUri);
        };
    }

    public String buildLoginUri() {
        return this.buildLoginUri(null, new String[0]);
    }

    public String buildLoginUri(String accessType) {
        return this.buildLoginUri(accessType, new String[0]);
    }

    public String buildLoginUri(String accessType, String ... additionalScopes) {
        StringBuilder loginUri = new StringBuilder(this.getAuthorizationUri());
        loginUri.append("?").append("response_type=code").append("&").append("client_id=").append(this.getClientId()).append("&").append("scope=").append(this.getScopes().replace(",", "%20"));
        for (String s : additionalScopes) {
            loginUri.append("%20").append(s);
        }
        loginUri.append("&").append("redirect_uri=").append(this.getRedirectUri());
        if (accessType != null) {
            loginUri.append("&").append("access_type=").append(accessType);
        }
        String finalUrl = loginUri.toString();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info("Going to request authorization to this endpoint {}", (Object)finalUrl);
        }
        return finalUrl;
    }

    public String buildRefreshTokenURI() {
        return this.buildRefreshTokenURI(null);
    }

    public String buildRefreshTokenURI(String accessType) {
        StringBuilder refreshUri = new StringBuilder(this.getAccessTokenUri());
        refreshUri.append("?").append("&").append("client_id=").append(this.getClientId()).append("&").append("scope=").append(this.getScopes().replace(",", "%20"));
        if (accessType != null) {
            refreshUri.append("&").append("access_type=").append(accessType);
        }
        return refreshUri.toString();
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String cliendId) {
        this.clientId = cliendId;
    }

    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public String getAccessTokenUri() {
        return this.accessTokenUri;
    }

    public void setAccessTokenUri(String accessTokenUri) {
        this.accessTokenUri = accessTokenUri;
    }

    public String getAuthorizationUri() {
        return this.authorizationUri;
    }

    public void setAuthorizationUri(String authorizationUri) {
        this.authorizationUri = authorizationUri;
    }

    public String getCheckTokenEndpointUrl() {
        return this.checkTokenEndpointUrl;
    }

    public void setCheckTokenEndpointUrl(String checkTokenEndpointUrl) {
        this.checkTokenEndpointUrl = checkTokenEndpointUrl;
    }

    public String getLogoutUri() {
        return this.logoutUri;
    }

    public void setLogoutUri(String logoutUri) {
        this.logoutUri = logoutUri;
    }

    public boolean isGlobalLogoutEnabled() {
        return this.globalLogoutEnabled;
    }

    public void setGlobalLogoutEnabled(boolean globalLogoutEnabled) {
        this.globalLogoutEnabled = globalLogoutEnabled;
    }

    public String getScopes() {
        return this.scopes;
    }

    public void setScopes(String scopes) {
        this.scopes = scopes;
    }

    public String getIdTokenUri() {
        return this.idTokenUri;
    }

    public void setIdTokenUri(String idTokenUri) {
        this.idTokenUri = idTokenUri;
    }

    public String getDiscoveryUrl() {
        return this.discoveryUrl;
    }

    public void setDiscoveryUrl(String discoveryUrl) {
        this.discoveryUrl = discoveryUrl;
    }

    public boolean isInvalid() {
        return this.clientId == null || this.clientSecret == null || this.authorizationUri == null || this.accessTokenUri == null;
    }

    public String getRevokeEndpoint() {
        return this.revokeEndpoint;
    }

    public void setRevokeEndpoint(String revokeEndpoint) {
        this.revokeEndpoint = revokeEndpoint;
    }

    public String getProvider() {
        return this.getBeanName().replaceAll(CONFIG_NAME_SUFFIX, "");
    }

    protected String appendParameters(MultiValueMap<String, String> params, String url) {
        UriComponentsBuilder builder = UriComponentsBuilder.fromHttpUrl((String)url);
        builder.queryParams(params);
        return builder.build().toUriString();
    }

    protected static void getLogoutRequestParams(String token, String clientId, MultiValueMap<String, String> params) {
        params.put((Object)"token", Collections.singletonList(token));
        if (clientId != null && !clientId.isEmpty()) {
            params.put((Object)"client_id", Collections.singletonList(clientId));
        }
    }

    public Endpoint buildRevokeEndpoint(String token, String accessToken, OAuth2Configuration configuration) {
        Endpoint result = null;
        if (this.revokeEndpoint != null) {
            HttpHeaders headers = OAuth2Configuration.getHttpHeaders(accessToken, configuration);
            LinkedMultiValueMap bodyParams = new LinkedMultiValueMap();
            bodyParams.add((Object)"token", (Object)token);
            bodyParams.add((Object)"client_id", (Object)this.clientId);
            HttpEntity requestEntity = new HttpEntity((Object)bodyParams, (MultiValueMap)headers);
            result = new Endpoint(HttpMethod.POST, this.revokeEndpoint);
            result.setRequestEntity(requestEntity);
        }
        return result;
    }

    private static HttpHeaders getHttpHeaders(String accessToken, OAuth2Configuration configuration) {
        HttpHeaders headers = OAuth2Configuration.getHeaders(accessToken, configuration);
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    public Endpoint buildLogoutEndpoint(String token, String accessToken, OAuth2Configuration configuration) {
        Endpoint result = null;
        if (this.logoutUri != null) {
            HttpHeaders headers = OAuth2Configuration.getHeaders(accessToken, configuration);
            LinkedMultiValueMap params = new LinkedMultiValueMap();
            OAuth2Configuration.getLogoutRequestParams(token, this.clientId, (MultiValueMap<String, String>)params);
            HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
            result = new Endpoint(HttpMethod.GET, this.appendParameters((MultiValueMap<String, String>)params, this.logoutUri));
            result.setRequestEntity(requestEntity);
        }
        return result;
    }

    private static HttpHeaders getHeaders(String accessToken, OAuth2Configuration configuration) {
        HttpHeaders headers = new HttpHeaders();
        if (configuration != null && configuration.clientId != null && configuration.clientSecret != null) {
            headers.setBasicAuth(configuration.clientId, configuration.clientSecret);
        } else if (accessToken != null && !accessToken.isEmpty()) {
            headers.set("Authorization", "Bearer " + accessToken);
        }
        return headers;
    }

    public boolean isEnableRedirectEntryPoint() {
        return this.enableRedirectEntryPoint;
    }

    public void setEnableRedirectEntryPoint(boolean enableRedirectEntryPoint) {
        this.enableRedirectEntryPoint = enableRedirectEntryPoint;
    }

    public String getPrincipalKey() {
        if (this.principalKey == null || this.principalKey.isEmpty()) {
            return "email";
        }
        return this.principalKey;
    }

    public void setPrincipalKey(String principalKey) {
        this.principalKey = principalKey;
    }

    public String getRolesClaim() {
        return this.rolesClaim;
    }

    public void setRolesClaim(String rolesClaim) {
        this.rolesClaim = rolesClaim;
    }

    public String getGroupsClaim() {
        return this.groupsClaim;
    }

    public void setGroupsClaim(String groupsClaim) {
        this.groupsClaim = groupsClaim;
    }

    public static class Endpoint {
        private String url;
        private HttpMethod method;
        private HttpEntity<?> requestEntity;

        public Endpoint(HttpMethod method, String url) {
            this.method = method;
            this.url = url;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public HttpMethod getMethod() {
            return this.method;
        }

        public void setMethod(HttpMethod method) {
            this.method = method;
        }

        public HttpEntity<?> getRequestEntity() {
            return this.requestEntity;
        }

        public void setRequestEntity(HttpEntity<?> requestEntity) {
            this.requestEntity = requestEntity;
        }
    }
}

