/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.security.oauth2;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.security.password.SecurityUtils;
import it.geosolutions.geostore.services.UserService;
import it.geosolutions.geostore.services.rest.RESTSessionService;
import it.geosolutions.geostore.services.rest.SessionServiceDelegate;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.SessionToken;
import it.geosolutions.geostore.services.rest.security.IdPConfiguration;
import it.geosolutions.geostore.services.rest.security.TokenAuthenticationCache;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Configuration;
import it.geosolutions.geostore.services.rest.security.oauth2.OAuth2Utils;
import it.geosolutions.geostore.services.rest.security.oauth2.TokenDetails;
import it.geosolutions.geostore.services.rest.utils.GeoStoreContext;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.common.DefaultOAuth2AccessToken;
import org.springframework.security.oauth2.common.DefaultOAuth2RefreshToken;
import org.springframework.security.oauth2.common.OAuth2AccessToken;
import org.springframework.security.oauth2.common.OAuth2RefreshToken;
import org.springframework.security.oauth2.provider.authentication.OAuth2AuthenticationDetails;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpMessageConverterExtractor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.context.request.RequestContextHolder;

public abstract class OAuth2SessionServiceDelegate
implements SessionServiceDelegate {
    private static final Logger LOGGER = LogManager.getLogger(OAuth2SessionServiceDelegate.class);
    protected UserService userService;

    public OAuth2SessionServiceDelegate(RESTSessionService restSessionService, String delegateName, UserService userService) {
        restSessionService.registerDelegate(delegateName, (SessionServiceDelegate)this);
        this.userService = userService;
    }

    public SessionToken refresh(String refreshToken, String accessToken) {
        HttpServletRequest request = OAuth2Utils.getRequest();
        if (accessToken == null) {
            accessToken = OAuth2Utils.tokenFromParamsOrBearer("access_token", request);
        }
        if (accessToken == null) {
            throw new NotFoundWebEx("Either the accessToken or the refresh token are missing");
        }
        OAuth2AccessToken currentToken = this.retrieveAccessToken(accessToken);
        Date expiresIn = currentToken.getExpiration();
        if (refreshToken == null || refreshToken.isEmpty()) {
            refreshToken = OAuth2Utils.getParameterValue("refresh_token", request);
        }
        Date fiveMinutesFromNow = OAuth2Utils.fiveMinutesFromNow();
        SessionToken sessionToken = null;
        OAuth2Configuration configuration = this.configuration();
        if (configuration != null && configuration.isEnabled() && (expiresIn == null || fiveMinutesFromNow.after(expiresIn)) && refreshToken != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Going to refresh the token.");
            }
            try {
                sessionToken = this.doRefresh(refreshToken, accessToken, configuration);
            }
            catch (NullPointerException npe) {
                LOGGER.error("Current configuration wasn't correctly initialized.");
            }
        }
        if (sessionToken == null) {
            sessionToken = this.sessionToken(accessToken, refreshToken, currentToken.getExpiration());
        }
        request.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_VALUE, (Object)sessionToken.getAccessToken());
        request.setAttribute(OAuth2AuthenticationDetails.ACCESS_TOKEN_TYPE, (Object)sessionToken.getTokenType());
        return sessionToken;
    }

    protected SessionToken doRefresh(String refreshToken, String accessToken, OAuth2Configuration configuration) {
        SessionToken sessionToken = null;
        RestTemplate restTemplate = new RestTemplate();
        HttpHeaders headers = OAuth2SessionServiceDelegate.getHttpHeaders(accessToken, configuration);
        LinkedMultiValueMap requestBody = new LinkedMultiValueMap();
        requestBody.add((Object)"grant_type", (Object)"refresh_token");
        requestBody.add((Object)"refresh_token", (Object)refreshToken);
        requestBody.add((Object)"client_secret", (Object)configuration.getClientSecret());
        requestBody.add((Object)"client_id", (Object)configuration.getClientId());
        HttpEntity requestEntity = new HttpEntity((Object)requestBody, (MultiValueMap)headers);
        OAuth2AccessToken newToken = null;
        try {
            newToken = (OAuth2AccessToken)restTemplate.exchange(configuration.buildRefreshTokenURI(), HttpMethod.POST, requestEntity, OAuth2AccessToken.class, new Object[0]).getBody();
        }
        catch (Exception ex) {
            LOGGER.error("Error trying to obtain a refresh token.", (Throwable)ex);
        }
        if (!(refreshToken == null || accessToken == null || refreshToken.isEmpty() || accessToken.isEmpty() || newToken == null || newToken.getValue() == null || newToken.getValue().isEmpty())) {
            String newRefreshToken = newToken.getRefreshToken() != null && newToken.getRefreshToken().getValue() != null && !newToken.getRefreshToken().getValue().isEmpty() ? newToken.getRefreshToken().getValue() : refreshToken;
            this.updateAuthToken(accessToken, newToken, newRefreshToken, configuration);
            sessionToken = this.sessionToken(newToken.getValue(), refreshToken, newToken.getExpiration());
        } else if (accessToken != null) {
            sessionToken = this.sessionToken(accessToken, refreshToken, null);
        } else {
            LOGGER.info("Unable to refresh the token. The following request was performed: {}. Redirecting to login.", (Object)configuration.buildRefreshTokenURI("offline"));
            this.doLogout(null);
            try {
                OAuth2Utils.getResponse().sendRedirect("../../openid/" + configuration.getProvider().toLowerCase() + "/login");
            }
            catch (IOException e) {
                LOGGER.error("Error while sending redirect to login service. ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return sessionToken;
    }

    private static HttpHeaders getHttpHeaders(String accessToken, OAuth2Configuration configuration) {
        HttpHeaders headers = new HttpHeaders();
        if (configuration != null && configuration.clientId != null && configuration.clientSecret != null) {
            headers.setBasicAuth(configuration.clientId, configuration.clientSecret);
        } else if (accessToken != null && !accessToken.isEmpty()) {
            headers.set("Authorization", "Bearer " + accessToken);
        }
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        return headers;
    }

    private SessionToken sessionToken(String accessToken, String refreshToken, Date expires) {
        SessionToken sessionToken = new SessionToken();
        if (expires != null) {
            sessionToken.setExpires(Long.valueOf(expires.getTime()));
        }
        sessionToken.setAccessToken(accessToken);
        sessionToken.setRefreshToken(refreshToken);
        sessionToken.setTokenType("bearer");
        return sessionToken;
    }

    private Authentication updateAuthToken(String oldToken, OAuth2AccessToken newToken, String refreshToken, OAuth2Configuration conf) {
        Authentication authentication = this.cache().get(oldToken);
        if (authentication == null) {
            authentication = SecurityContextHolder.getContext().getAuthentication();
        }
        if (authentication instanceof PreAuthenticatedAuthenticationToken) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Updating the cache and the SecurityContext with new Auth details");
            }
            String idToken = null;
            TokenDetails details = OAuth2Utils.getTokenDetails(authentication);
            idToken = details.getIdToken();
            this.cache().removeEntry(oldToken);
            PreAuthenticatedAuthenticationToken updated = new PreAuthenticatedAuthenticationToken(authentication.getPrincipal(), authentication.getCredentials(), authentication.getAuthorities());
            DefaultOAuth2AccessToken accessToken = new DefaultOAuth2AccessToken(newToken);
            if (refreshToken != null) {
                accessToken.setRefreshToken((OAuth2RefreshToken)new DefaultOAuth2RefreshToken(refreshToken));
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Creating new details. AccessToken: " + accessToken + " IdToken: " + idToken);
            }
            updated.setDetails((Object)new TokenDetails((OAuth2AccessToken)accessToken, idToken, conf.getBeanName()));
            this.cache().putCacheEntry(newToken.getValue(), (Authentication)updated);
            SecurityContextHolder.getContext().setAuthentication((Authentication)updated);
            authentication = updated;
        }
        return authentication;
    }

    private OAuth2AccessToken retrieveAccessToken(String accessToken) {
        OAuth2ClientContext context;
        OAuth2RestTemplate oAuth2RestTemplate;
        Authentication authentication = this.cache().get(accessToken);
        OAuth2AccessToken result = null;
        if (authentication != null) {
            TokenDetails details = OAuth2Utils.getTokenDetails(authentication);
            result = details.getAccessToken();
        }
        if (result == null && (oAuth2RestTemplate = this.restTemplate()) != null && (context = oAuth2RestTemplate.getOAuth2ClientContext()) != null) {
            result = context.getAccessToken();
        }
        if (result == null) {
            result = new DefaultOAuth2AccessToken(accessToken);
        }
        return result;
    }

    public void doLogout(String sessionId) {
        OAuth2Configuration configuration;
        HttpServletRequest request = OAuth2Utils.getRequest();
        HttpServletResponse response = OAuth2Utils.getResponse();
        OAuth2RestTemplate restTemplate = this.restTemplate();
        String token = null;
        String accessToken = null;
        if (sessionId != null) {
            TokenAuthenticationCache cache = this.cache();
            Authentication authentication = cache.get(sessionId);
            TokenDetails tokenDetails = OAuth2Utils.getTokenDetails(authentication);
            if (tokenDetails != null) {
                token = tokenDetails.getIdToken();
                accessToken = tokenDetails.getAccessToken().getValue();
            }
            cache.removeEntry(sessionId);
        }
        if (token == null) {
            if (restTemplate.getOAuth2ClientContext().getAccessToken() != null) {
                token = restTemplate.getOAuth2ClientContext().getAccessToken().getRefreshToken().getValue();
            }
            if (token == null) {
                token = OAuth2Utils.getParameterValue("refresh_token", request);
            }
            if (token == null) {
                token = (String)RequestContextHolder.getRequestAttributes().getAttribute("refresh_token", 0);
            }
        }
        if (accessToken == null) {
            if (restTemplate.getOAuth2ClientContext().getAccessToken() != null) {
                accessToken = restTemplate.getOAuth2ClientContext().getAccessToken().getValue();
            }
            if (accessToken == null) {
                accessToken = OAuth2Utils.getParameterValue("access_token", request);
            }
            if (accessToken == null) {
                accessToken = (String)RequestContextHolder.getRequestAttributes().getAttribute("access_token", 0);
            }
        }
        if ((configuration = this.configuration()) != null && configuration.isEnabled()) {
            if (token != null && accessToken != null && !token.isEmpty() && !accessToken.isEmpty()) {
                if (configuration.isGlobalLogoutEnabled()) {
                    this.doLogoutInternal(token, configuration, accessToken);
                }
                if (configuration.getRevokeEndpoint() != null) {
                    this.clearSession(restTemplate, request);
                }
            } else if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Unable to retrieve access token. Remote logout was not executed.");
            }
            if (response != null) {
                this.clearCookies(request, response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSession(OAuth2RestTemplate restTemplate, HttpServletRequest request) {
        AccessTokenRequest accessTokenRequest = restTemplate.getOAuth2ClientContext().getAccessTokenRequest();
        if (accessTokenRequest != null && accessTokenRequest.getStateKey() != null) {
            restTemplate.getOAuth2ClientContext().removePreservedState(accessTokenRequest.getStateKey());
        }
        try {
            accessTokenRequest.remove((Object)"access_token");
            accessTokenRequest.remove((Object)"refresh_token");
            request.logout();
        }
        catch (ServletException e) {
            LOGGER.error("Error happened while doing request logout: ", (Throwable)e);
        }
        finally {
            SecurityContextHolder.clearContext();
        }
    }

    protected void doLogoutInternal(Object token, OAuth2Configuration configuration, String accessToken) {
        String tokenValue = null;
        if (token instanceof OAuth2AccessToken) {
            tokenValue = ((OAuth2AccessToken)token).getRefreshToken() != null ? ((OAuth2AccessToken)token).getRefreshToken().getValue() : ((OAuth2AccessToken)token).getValue();
        } else if (token instanceof String) {
            tokenValue = (String)token;
        }
        if (configuration.getRevokeEndpoint() != null && tokenValue != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.info("Performing remote logout");
            }
            this.callRevokeEndpoint(tokenValue, accessToken);
            this.callRemoteLogout(tokenValue, accessToken);
        }
    }

    protected void callRevokeEndpoint(String token, String accessToken) {
        OAuth2Configuration.Endpoint revokeEndpoint;
        OAuth2Configuration configuration = this.configuration();
        if (configuration != null && configuration.isEnabled() && (revokeEndpoint = configuration.buildRevokeEndpoint(token, accessToken, configuration)) != null) {
            RestTemplate template = new RestTemplate();
            try {
                ResponseEntity responseEntity = template.exchange(revokeEndpoint.getUrl(), revokeEndpoint.getMethod(), revokeEndpoint.getRequestEntity(), String.class, new Object[0]);
                if (responseEntity.getStatusCode().value() != 200) {
                    OAuth2SessionServiceDelegate.logRevokeErrors(responseEntity.getBody());
                }
            }
            catch (Exception e) {
                OAuth2SessionServiceDelegate.logRevokeErrors(e);
            }
        }
    }

    protected void callRemoteLogout(String token, String accessToken) {
        RestTemplate template;
        ResponseEntity responseEntity;
        OAuth2Configuration.Endpoint logoutEndpoint;
        OAuth2Configuration configuration = this.configuration();
        if (configuration != null && configuration.isEnabled() && (logoutEndpoint = configuration.buildLogoutEndpoint(token, accessToken, configuration)) != null && (responseEntity = (template = new RestTemplate()).exchange(logoutEndpoint.getUrl(), logoutEndpoint.getMethod(), logoutEndpoint.getRequestEntity(), String.class, new Object[0])).getStatusCode().value() != 200) {
            OAuth2SessionServiceDelegate.logRevokeErrors(responseEntity.getBody());
        }
    }

    protected void clearCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] allCookies = request.getCookies();
        if (allCookies != null && allCookies.length > 0) {
            for (int i = 0; i < allCookies.length; ++i) {
                Cookie toDelete = allCookies[i];
                if (!this.deleteCookie(toDelete)) continue;
                toDelete.setMaxAge(-1);
                toDelete.setPath("/");
                toDelete.setComment("EXPIRING COOKIE at " + System.currentTimeMillis());
                response.addCookie(toDelete);
            }
        }
    }

    protected boolean deleteCookie(Cookie c) {
        return c.getName().equalsIgnoreCase("JSESSIONID") || c.getName().equalsIgnoreCase("access_token") || c.getName().equalsIgnoreCase("refresh_token");
    }

    private TokenAuthenticationCache cache() {
        return GeoStoreContext.bean("oAuth2Cache", TokenAuthenticationCache.class);
    }

    protected OAuth2Configuration configuration() {
        Optional<OAuth2Configuration> enabledConfig;
        Map<String, OAuth2Configuration> configurations = GeoStoreContext.beans(OAuth2Configuration.class);
        if (configurations != null && (enabledConfig = configurations.values().stream().filter(IdPConfiguration::isEnabled).findFirst()).isPresent()) {
            return enabledConfig.get();
        }
        return null;
    }

    protected HttpMessageConverterExtractor<OAuth2AccessToken> tokenExtractor() {
        return new HttpMessageConverterExtractor(OAuth2AccessToken.class, this.restTemplate().getMessageConverters());
    }

    protected abstract OAuth2RestTemplate restTemplate();

    public User getUser(String sessionId, boolean refresh, boolean autorefresh) {
        String username = this.getUserName(sessionId, refresh, autorefresh);
        if (username != null) {
            User user;
            try {
                user = this.userService.get(username);
            }
            catch (Exception e) {
                LOGGER.warn("Issue while retrieving user. Will return just the username.", (Throwable)e);
                user = new User();
                user.setName(username);
            }
            return user;
        }
        return null;
    }

    public String getUserName(String sessionId, boolean refresh, boolean autorefresh) {
        Object o;
        TokenAuthenticationCache cache = this.cache();
        Authentication authentication = cache.get(sessionId);
        if (refresh) {
            LOGGER.warn("Refresh was set to true but this delegate is not supporting refreshing token when retrieving the user...");
        }
        if (authentication != null && (o = authentication.getPrincipal()) != null) {
            return SecurityUtils.getUsername((Object)o);
        }
        return null;
    }

    private static void logRevokeErrors(Object cause) {
        LOGGER.error("Error while revoking authorization. Error is: {}", cause);
    }
}

