/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.GroupFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.dto.search.TagFilter;
import it.geosolutions.geostore.services.model.ExtGroupList;
import it.geosolutions.geostore.services.model.ExtResource;
import it.geosolutions.geostore.services.model.ExtResourceList;
import it.geosolutions.geostore.services.model.ExtShortResource;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTExtJsServiceImpl;
import it.geosolutions.geostore.services.rest.impl.ServiceTestBase;
import it.geosolutions.geostore.services.rest.model.RESTSecurityRule;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.model.Sort;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RESTExtJsServiceImplTest
extends ServiceTestBase {
    private final RESTExtJsServiceImpl restExtJsService = (RESTExtJsServiceImpl)ctx.getBean("restExtJsService", RESTExtJsServiceImpl.class);

    public RESTExtJsServiceImplTest() {
        Assert.assertNotNull((Object)this.restExtJsService);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)this.restExtJsService);
        this.removeAll();
    }

    @Test
    public void testGetAllResources_auth_base() throws Exception {
        String CAT_NAME = "CAT000";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(ResourceSearchParameters.builder().authUser(this.buildFakeAdminUser()).build()).size());
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        long u1 = this.restCreateUser("u1", Role.USER, null, "p1");
        Category cat = this.createCategory("CAT000");
        this.restCreateResource("r_u0_0", "x", "CAT000", u0, true);
        this.restCreateResource("r_u1_0", "x", "CAT000", u1, true);
        this.restCreateResource("r_u1_1", "x", "CAT000", u1, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)1L, (long)result.total);
        Assert.assertEquals((long)1L, (long)result.returnedCount);
        Assert.assertTrue((boolean)result.names.contains("r_u0_0"));
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)2L, (long)result.total);
        Assert.assertEquals((long)2L, (long)result.returnedCount);
        Assert.assertTrue((boolean)result.names.contains("r_u1_0"));
        Assert.assertTrue((boolean)result.names.contains("r_u1_1"));
        Assert.assertFalse((boolean)result.names.contains("r_u0_0"));
    }

    @Test
    public void testGetAllResources_auth_many() throws Exception {
        String CAT_NAME = "CAT009";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(ResourceSearchParameters.builder().authUser(this.buildFakeAdminUser()).build()).size());
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        long u1 = this.restCreateUser("u1", Role.USER, null, "p1");
        Category cat = this.createCategory("CAT009");
        int RESNUM0 = 20;
        int RESNUM1 = RESNUM0 * 2;
        for (int i = 1000; i < 1000 + RESNUM0; ++i) {
            this.restCreateResource("r_u0_" + i, "x", "CAT009", u0, true);
            this.restCreateResource("r_u1_" + i + "a", "x", "CAT009", u1, true);
            this.restCreateResource("r_u1_" + i + "b", "x", "CAT009", u1, true);
        }
        int cnt = resourceDAO.count((ISearch)new Search(Resource.class));
        Assert.assertEquals((long)(RESNUM0 + RESNUM1), (long)cnt);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("JSON for u0 " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)RESNUM0, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("JSON for u1 " + response);
        result = this.parse(response);
        Assert.assertEquals((long)RESNUM1, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT009", "*", Integer.valueOf(0), Integer.valueOf(10), false, false);
        System.out.println("JSON for u0 " + response);
        result = this.parse(response);
        Assert.assertEquals((long)RESNUM0, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT009", "*", Integer.valueOf(0), Integer.valueOf(10), false, false);
        System.out.println("JSON for u1 " + response);
        result = this.parse(response);
        Assert.assertEquals((long)RESNUM1, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
    }

    @Test
    public void testGetAllResources_iLike() throws Exception {
        String CAT0_NAME = "CAT000";
        String CAT1_NAME = "CAT111";
        String RES_NAME = "a MiXeD cAsE sTrInG";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(ResourceSearchParameters.builder().authUser(this.buildFakeAdminUser()).build()).size());
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        this.createCategory("CAT000");
        this.createCategory("CAT111");
        this.restCreateResource("a MiXeD cAsE sTrInG", "x", "CAT000", u0, true);
        this.restCreateResource("a MiXeD cAsE sTrInG".toLowerCase(), "x", "CAT000", u0, true);
        this.restCreateResource("a MiXeD cAsE sTrInG".toUpperCase(), "x", "CAT000", u0, true);
        this.restCreateResource("a MiXeD cAsE sTrInG in another category", "x", "CAT111", u0, true);
        this.restCreateResource("just an extra resource we shouldn't care about", "x", "CAT000", u0, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)4L, (long)result.total);
        Assert.assertEquals((long)4L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT000", "*mIxEd*", null, Integer.valueOf(0), Integer.valueOf(1000), false, false);
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)3L, (long)result.total);
        Assert.assertEquals((long)3L, (long)result.returnedCount);
    }

    @Test
    public void testGetAllResources_editorUpdate() throws Exception {
        String CAT0_NAME = "CAT000";
        String RES_NAME = "a MiXeD cAsE sTrInG";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(ResourceSearchParameters.builder().authUser(this.buildFakeAdminUser()).build()).size());
        long a0 = this.restCreateUser("a0", Role.ADMIN, new HashSet<UserGroup>(), "p0");
        long u0 = this.restCreateUser("u0", Role.USER, new HashSet<UserGroup>(), "p0");
        this.createCategory("CAT000");
        long r0Id = this.restCreateResource("a MiXeD cAsE sTrInG", "x", "CAT000", u0, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)1L, (long)result.total);
        Assert.assertEquals((long)1L, (long)result.returnedCount);
        ExtShortResource resource = this.restExtJsService.getExtResource((SecurityContext)sc, r0Id, false, false, false);
        Assert.assertEquals((Object)"a MiXeD cAsE sTrInG", (Object)resource.getName());
        Assert.assertEquals((Object)"u0", (Object)resource.getCreator());
        Assert.assertEquals((Object)"u0", (Object)resource.getEditor());
        sc = new ServiceTestBase.SimpleSecurityContext(a0);
        Resource realResource = resourceService.get(r0Id);
        realResource.setName("new name");
        restResourceService.update((SecurityContext)sc, r0Id, this.createRESTResource(realResource));
        ExtShortResource resource2 = this.restExtJsService.getExtResource((SecurityContext)sc, r0Id, false, false, false);
        Assert.assertEquals((Object)realResource.getName(), (Object)resource2.getName());
        Assert.assertEquals((Object)"u0", (Object)resource2.getCreator());
        Assert.assertEquals((Object)"a0", (Object)resource2.getEditor());
    }

    @Test
    public void testGetAllResources_unadvertised() throws Exception {
        String CAT0_NAME = "CAT000";
        String CAT1_NAME = "CAT111";
        String RES_NAME = "a MiXeD cAsE sTrInG";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(ResourceSearchParameters.builder().authUser(this.buildFakeAdminUser()).build()).size());
        long g0Id = this.createGroup("g0");
        UserGroup g0 = new UserGroup();
        g0.setId(Long.valueOf(g0Id));
        g0.setGroupName("g0");
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        groups.add(g0);
        long a0 = this.restCreateUser("a0", Role.ADMIN, groups, "p0");
        long u0 = this.restCreateUser("u0", Role.USER, groups, "p0");
        long u1 = this.restCreateUser("u1", Role.USER, groups, "p1");
        this.createCategory("CAT000");
        this.createCategory("CAT111");
        SecurityRule sr0 = new SecurityRule();
        sr0.setUser((User)userDAO.find(Long.valueOf(u0)));
        sr0.setCanRead(true);
        sr0.setCanWrite(true);
        SecurityRule sr1 = new SecurityRule();
        sr1.setGroup(g0);
        sr1.setCanRead(true);
        sr1.setCanWrite(false);
        SecurityRuleList rules = new SecurityRuleList(Arrays.asList(sr0, sr1));
        this.restCreateResource("a MiXeD cAsE sTrInG", "x", "CAT000", u0, rules, true);
        this.restCreateResource("a MiXeD cAsE sTrInG".toLowerCase(), "x", "CAT000", u0, rules, false);
        this.restCreateResource("a MiXeD cAsE sTrInG".toUpperCase(), "x", "CAT000", u0, rules, true);
        this.restCreateResource("a MiXeD cAsE sTrInG in another category", "x", "CAT111", u0, rules, false);
        this.restCreateResource("just an extra resource we shouldn't care about", "x", "CAT000", u0, rules, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(a0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)4L, (long)result.total);
        Assert.assertEquals((long)4L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)4L, (long)result.total);
        Assert.assertEquals((long)4L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)2L, (long)result.total);
        Assert.assertEquals((long)2L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT000", "*mIxEd*", null, Integer.valueOf(0), Integer.valueOf(1000), false, false);
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)3L, (long)result.total);
        Assert.assertEquals((long)3L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT000", "*mIxEd*", null, Integer.valueOf(0), Integer.valueOf(1000), false, false);
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)2L, (long)result.total);
        Assert.assertEquals((long)2L, (long)result.returnedCount);
    }

    @Test
    public void testExtResourcesList_sorted() throws Exception {
        String CAT0_NAME = "CAT000";
        String RES_ATTRIBUTE_A = "A";
        String RES_ATTRIBUTE_B = "B";
        String RES_ATTRIBUTE_C = "C";
        Assert.assertEquals((long)0L, (long)resourceService.getShortResources(ResourceSearchParameters.builder().authUser(this.buildFakeAdminUser()).build()).size());
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        this.createCategory("CAT000");
        this.restCreateResource("A", "A", "CAT000", u0, true);
        this.restCreateResource("B", "B", "CAT000", u0, true);
        this.restCreateResource("C", "C", "CAT000", u0, true);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("description", "asc"), false, false, false, false, (SearchFilter)new AndFilter());
        List resources = response.getList();
        Assert.assertEquals((long)3L, (long)resources.size());
        List resourcesDescriptions = resources.stream().map(Resource::getDescription).collect(Collectors.toList());
        Assert.assertEquals(List.of("A", "B", "C"), resourcesDescriptions);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("creation", "desc"), false, false, false, false, (SearchFilter)new AndFilter());
        resources = response.getList();
        Assert.assertEquals((long)3L, (long)resources.size());
        List resourcesCreationDates = resources.stream().map(Resource::getCreation).collect(Collectors.toList());
        Assert.assertTrue((boolean)((Date)resourcesCreationDates.get(0)).after((Date)resourcesCreationDates.get(1)));
        Assert.assertTrue((boolean)((Date)resourcesCreationDates.get(1)).after((Date)resourcesCreationDates.get(2)));
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(1000), new Sort(null, null), false, false, false, false, (SearchFilter)new AndFilter());
        resources = response.getList();
        Assert.assertEquals((long)3L, (long)resources.size());
        List resourcesNames = resources.stream().map(Resource::getName).collect(Collectors.toList());
        Assert.assertEquals(List.of("A", "B", "C"), resourcesNames);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(1000), new Sort("unknownfield", "desc"), false, false, false, false, (SearchFilter)new AndFilter());
        Assert.assertNull((Object)response);
    }

    @Test
    public void testExtResourcesList_creatorFiltered() throws Exception {
        String CAT0_NAME = "CAT000";
        String CREATOR_A = "creatorA";
        String CREATOR_B = "creatorB";
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        this.createCategory("CAT000");
        long resourceAId = this.restCreateResource("name_A", "description_A", "CAT000", u0, true);
        long resourceBId = this.restCreateResource("name_B", "description_B", "CAT000", u0, true);
        Resource resourceA = resourceService.get(resourceAId);
        resourceA.setCreator("creatorA");
        resourceService.update(resourceA);
        Resource resourceB = resourceService.get(resourceBId);
        resourceB.setCreator("creatorB");
        resourceService.update(resourceB);
        FieldFilter editorFieldFilter = new FieldFilter(BaseField.CREATOR, "creatorB", SearchOperator.EQUAL_TO);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)editorFieldFilter);
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        ExtResource resource = (ExtResource)resources.get(0);
        Assert.assertEquals((Object)"creatorB", (Object)resource.getCreator());
        editorFieldFilter = new FieldFilter(BaseField.CREATOR, "CREATOR_", SearchOperator.ILIKE);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)editorFieldFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        editorFieldFilter = new FieldFilter(BaseField.CREATOR, "unknown creator", SearchOperator.EQUAL_TO);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)editorFieldFilter);
        Assert.assertTrue((boolean)response.isEmpty());
    }

    @Test
    public void testExtResourcesList_editorFiltered() throws Exception {
        String CAT0_NAME = "CAT000";
        String EDITOR_A = "editorA";
        String EDITOR_B = "editorB";
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        this.createCategory("CAT000");
        long resourceAId = this.restCreateResource("name_A", "description_A", "CAT000", u0, true);
        long resourceBId = this.restCreateResource("name_B", "description_B", "CAT000", u0, true);
        Resource resourceA = resourceService.get(resourceAId);
        resourceA.setEditor("editorA");
        resourceService.update(resourceA);
        Resource resourceB = resourceService.get(resourceBId);
        resourceB.setEditor("editorB");
        resourceService.update(resourceB);
        FieldFilter editorFieldFilter = new FieldFilter(BaseField.EDITOR, "editorA", SearchOperator.EQUAL_TO);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)editorFieldFilter);
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)"editorA", (Object)resource.getEditor());
        editorFieldFilter = new FieldFilter(BaseField.EDITOR, "EDITOR_", SearchOperator.ILIKE);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)editorFieldFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        editorFieldFilter = new FieldFilter(BaseField.CREATOR, "unknown editor", SearchOperator.EQUAL_TO);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)editorFieldFilter);
        Assert.assertTrue((boolean)response.isEmpty());
    }

    @Test
    public void testExtResourcesList_groupFiltered() throws Exception {
        String CAT0_NAME = "CAT000";
        String RESOURCE_A_NAME = "resourceA";
        String RESOURCE_B_NAME = "resourceB";
        String GROUP_A_NAME = "groupA";
        String GROUP_B_NAME = "groupB";
        long user0Id = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(user0Id);
        this.createCategory("CAT000");
        long resourceAId = this.restCreateResource("resourceA", "description_A", "CAT000", user0Id, true);
        long resourceBId = this.restCreateResource("resourceB", "description_B", "CAT000", user0Id, true);
        SecurityRule securityRuleGroupA = new SecurityRule();
        securityRuleGroupA.setGroup(userGroupService.get(this.createGroup("groupA")));
        securityRuleGroupA.setCanWrite(true);
        List securityRulesResourceA = resourceService.getSecurityRules(resourceAId);
        securityRulesResourceA.add(securityRuleGroupA);
        restResourceService.updateSecurityRules((SecurityContext)sc, resourceAId, new SecurityRuleList(securityRulesResourceA));
        SecurityRule securityRuleGroupB = new SecurityRule();
        securityRuleGroupB.setGroup(userGroupService.get(this.createGroup("groupB")));
        securityRuleGroupB.setCanRead(true);
        List securityRulesResourceB = resourceService.getSecurityRules(resourceBId);
        securityRulesResourceB.add(securityRuleGroupB);
        restResourceService.updateSecurityRules((SecurityContext)sc, resourceBId, new SecurityRuleList(securityRulesResourceB));
        GroupFilter groupFilter = new GroupFilter("groupA", SearchOperator.EQUAL_TO);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)"resourceA", (Object)resource.getName());
        groupFilter = new GroupFilter("GROUP_", SearchOperator.ILIKE);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        groupFilter = new GroupFilter("groupA,groupB,groupC", SearchOperator.IN);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        groupFilter = new GroupFilter("", SearchOperator.EQUAL_TO);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        Assert.assertTrue((boolean)response.getList().isEmpty());
        groupFilter = new GroupFilter("unknown group", SearchOperator.EQUAL_TO);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        Assert.assertTrue((boolean)response.getList().isEmpty());
        Assert.assertThrows(IllegalArgumentException.class, () -> new GroupFilter(null, SearchOperator.IN));
    }

    @Test
    public void testExtResourcesList_filteredForGroupNameWithCommas() throws Exception {
        String CAT0_NAME = "CAT000";
        String RESOURCE_A_NAME = "resourceA";
        String RESOURCE_B_NAME = "resourceB";
        String GROUP_NAME_WITH_COMMAS = ",groupA,B,C,";
        String OTHER_GROUP_NAME = "group";
        long user0Id = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(user0Id);
        this.createCategory("CAT000");
        long resourceAId = this.restCreateResource("resourceA", "", "CAT000", user0Id, true);
        long resourceBId = this.restCreateResource("resourceB", "", "CAT000", user0Id, true);
        SecurityRule securityRuleGroupA = new SecurityRule();
        securityRuleGroupA.setGroup(userGroupService.get(this.createGroup(",groupA,B,C,")));
        securityRuleGroupA.setCanWrite(true);
        List securityRulesResourceA = resourceService.getSecurityRules(resourceAId);
        securityRulesResourceA.add(securityRuleGroupA);
        restResourceService.updateSecurityRules((SecurityContext)sc, resourceAId, new SecurityRuleList(securityRulesResourceA));
        SecurityRule securityRuleGroupB = new SecurityRule();
        securityRuleGroupB.setGroup(userGroupService.get(this.createGroup("group")));
        securityRuleGroupB.setCanRead(true);
        List securityRulesResourceB = resourceService.getSecurityRules(resourceBId);
        securityRulesResourceB.add(securityRuleGroupB);
        restResourceService.updateSecurityRules((SecurityContext)sc, resourceBId, new SecurityRuleList(securityRulesResourceB));
        GroupFilter groupFilter = new GroupFilter(",groupA,B,C,", SearchOperator.EQUAL_TO);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)"resourceA", (Object)resource.getName());
        groupFilter = new GroupFilter(",%,", SearchOperator.ILIKE);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)"resourceA", (Object)resource.getName());
        groupFilter = new GroupFilter("group,\",groupA,B,C,\"", SearchOperator.IN);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)groupFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
    }

    @Test
    public void testExtResourcesList_tagFiltered() throws Exception {
        String CAT0_NAME = "CAT000";
        String RESOURCE_A_NAME = "resourceA";
        String RESOURCE_B_NAME = "resourceB";
        String TAG_A_NAME = "tagA";
        String TAG_B_NAME = "tagB";
        long user0Id = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(user0Id);
        long tagAId = tagService.insert(new Tag("tagA", "", null));
        long tagBId = tagService.insert(new Tag("tagB", "", null));
        this.createCategory("CAT000");
        long resourceAId = this.restCreateResource("resourceA", "description_A", "CAT000", user0Id, true);
        long resourceBId = this.restCreateResource("resourceB", "description_B", "CAT000", user0Id, true);
        tagService.addToResource(tagAId, resourceAId);
        tagService.addToResource(tagBId, resourceAId);
        tagService.addToResource(tagBId, resourceBId);
        TagFilter tagFilter = new TagFilter("tagA", SearchOperator.EQUAL_TO);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)"resourceA", (Object)resource.getName());
        tagFilter = new TagFilter("TAG_", SearchOperator.ILIKE);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        tagFilter = new TagFilter("tagA,tagB,TagC", SearchOperator.IN);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        tagFilter = new TagFilter("", SearchOperator.EQUAL_TO);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        Assert.assertTrue((boolean)response.getList().isEmpty());
        tagFilter = new TagFilter("unknown tag", SearchOperator.EQUAL_TO);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        Assert.assertTrue((boolean)response.getList().isEmpty());
        Assert.assertThrows(IllegalArgumentException.class, () -> new TagFilter(null, SearchOperator.IN));
    }

    @Test
    public void testExtResourcesList_filteredForTagNameWithCommas() throws Exception {
        String CAT0_NAME = "CAT000";
        String RESOURCE_A_NAME = "resourceA";
        String RESOURCE_B_NAME = "resourceB";
        long user0Id = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(user0Id);
        long tagWithCommas = tagService.insert(new Tag(",a,b,c,d,", "", null));
        long tag = tagService.insert(new Tag("tag", "", null));
        this.createCategory("CAT000");
        long resourceAId = this.restCreateResource("resourceA", "", "CAT000", user0Id, true);
        long resourceBId = this.restCreateResource("resourceB", "", "CAT000", user0Id, true);
        tagService.addToResource(tagWithCommas, resourceAId);
        tagService.addToResource(tag, resourceAId);
        tagService.addToResource(tag, resourceBId);
        TagFilter tagFilter = new TagFilter(",a,b,c,d,", SearchOperator.EQUAL_TO);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)"resourceA", (Object)resource.getName());
        tagFilter = new TagFilter(",%,", SearchOperator.ILIKE);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        resource = (Resource)resources.get(0);
        Assert.assertEquals((Object)"resourceA", (Object)resource.getName());
        tagFilter = new TagFilter("tag,\",a,b,c,d,\"", SearchOperator.IN);
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)tagFilter);
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
    }

    @Test
    public void testExtResourcesList_timeAttributesFiltered() throws Exception {
        String CAT0_NAME = "CAT000";
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        this.createCategory("CAT000");
        long resourceAId = this.restCreateResource("name_A", "", "CAT000", u0, true);
        long resourceBId = this.restCreateResource("name_B", "", "CAT000", u0, true);
        Resource resourceA = resourceService.get(resourceAId);
        Resource resourceB = resourceService.get(resourceBId);
        Thread.sleep(1000L);
        resourceB.setDescription("posticipated");
        resourceService.update(resourceB);
        FieldFilter ltDateFilter = new FieldFilter(BaseField.LASTUPDATE, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(resourceB.getLastUpdate()), SearchOperator.LESS_THAN);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)ltDateFilter);
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        Resource resource = (Resource)resources.get(0);
        Assert.assertEquals((long)resourceAId, (long)resource.getId());
        FieldFilter gteDateFilter = new FieldFilter(BaseField.CREATION, new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(resourceA.getCreation()), SearchOperator.GREATER_THAN_OR_EQUAL_TO);
        FieldFilter lteDateFilter = new FieldFilter(BaseField.CREATION, new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS").format(resourceB.getLastUpdate()), SearchOperator.LESS_THAN_OR_EQUAL_TO);
        AndFilter betweenDatesFieldFilter = new AndFilter((SearchFilter)gteDateFilter, (SearchFilter)lteDateFilter, new SearchFilter[0]);
        ExtResourceList response2 = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)betweenDatesFieldFilter);
        List resources2 = response2.getList();
        Assert.assertEquals((long)2L, (long)resources2.size());
    }

    @Test
    public void testExtResourcesList_userOwnedWithPermissionsInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        String OWNED_RESOURCE_NAME = "ownedResource";
        String READ_ONLY_RESOURCE_NAME = "readOnlyResource";
        long adminId = this.restCreateUser("admin", Role.ADMIN, null, "admin");
        ServiceTestBase.SimpleSecurityContext adminSecurityContext = new ServiceTestBase.SimpleSecurityContext(adminId);
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext user0SecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        this.restCreateResource("adminResource", "", "CAT000", adminId, false);
        this.restCreateResource("ownedResource", "", "CAT000", userId, false);
        long readOnlyResourceId = this.restCreateResource("readOnlyResource", "", "CAT000", userId, false);
        SecurityRule readOnlyRule = new SecurityRule();
        readOnlyRule.setUser(userService.get(userId));
        readOnlyRule.setCanRead(true);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, readOnlyResourceId, new SecurityRuleList(Collections.singletonList(readOnlyRule)));
        this.restCreateResource("advertisedResource", "", "CAT000", adminId, true);
        this.restCreateResource("unruledResource", "", "CAT000", adminId, new SecurityRuleList(Collections.emptyList()), false);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)adminSecurityContext, Integer.valueOf(0), Integer.valueOf(1000), new Sort("", ""), false, false, false, false, (SearchFilter)new AndFilter());
        List resources = response.getList();
        Assert.assertEquals((long)5L, (long)resources.size());
        Assert.assertTrue((boolean)resources.stream().allMatch(r -> r.isCanEdit() && r.isCanDelete() && r.isCanCopy()));
        response = this.restExtJsService.getExtResourcesList((SecurityContext)user0SecurityContext, Integer.valueOf(0), Integer.valueOf(1000), new Sort("", ""), false, false, false, false, (SearchFilter)new AndFilter());
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        ExtResource ownerResource = resources.stream().filter(r -> r.getName().equals("ownedResource")).findFirst().orElseThrow();
        Assert.assertTrue((boolean)ownerResource.isCanEdit());
        Assert.assertTrue((boolean)ownerResource.isCanDelete());
        Assert.assertTrue((boolean)ownerResource.isCanCopy());
        ExtResource readOnlyResource = resources.stream().filter(r -> r.getName().equals("readOnlyResource")).findFirst().orElseThrow();
        Assert.assertFalse((boolean)readOnlyResource.isCanEdit());
        Assert.assertFalse((boolean)readOnlyResource.isCanDelete());
        Assert.assertTrue((boolean)readOnlyResource.isCanCopy());
    }

    @Test
    public void testExtResourcesList_groupOwnedResourceWithPermissionsInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        String GROUP_RESOURCE_NAME = "advertisedGroupResource";
        String READ_ONLY_RESOURCE_NAME = "readOnlyResource";
        long groupId = this.createGroup("group");
        UserGroup group = userGroupService.get(groupId);
        long adminId = this.restCreateUser("admin", Role.ADMIN, null, "admin");
        ServiceTestBase.SimpleSecurityContext adminSecurityContext = new ServiceTestBase.SimpleSecurityContext(adminId);
        long userId = this.restCreateUser("u0", Role.USER, Collections.singleton(group), "p0");
        ServiceTestBase.SimpleSecurityContext user0SecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        SecurityRule editorGroupRule = new SecurityRule();
        editorGroupRule.setGroup(group);
        editorGroupRule.setCanRead(true);
        editorGroupRule.setCanWrite(true);
        long advertisedGroupResourceId = this.restCreateResource("advertisedGroupResource", "", "CAT000", adminId, true);
        List securityRulesAdvertisedGroupResource = resourceService.getSecurityRules(advertisedGroupResourceId);
        securityRulesAdvertisedGroupResource.add(editorGroupRule);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, advertisedGroupResourceId, new SecurityRuleList(securityRulesAdvertisedGroupResource));
        SecurityRule readOnlyGroupRule = new SecurityRule();
        readOnlyGroupRule.setGroup(group);
        readOnlyGroupRule.setCanRead(true);
        long readOnlyGroupResourceId = this.restCreateResource("readOnlyResource", "", "CAT000", adminId, true);
        List securityRulesReadOnlyGroupResource = resourceService.getSecurityRules(readOnlyGroupResourceId);
        securityRulesReadOnlyGroupResource.add(readOnlyGroupRule);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, readOnlyGroupResourceId, new SecurityRuleList(securityRulesReadOnlyGroupResource));
        long unadvertisedGroupResourceId = this.restCreateResource("unadvertisedGroupResource", "", "CAT000", adminId, false);
        List securityRulesUnadvertisedGroupResource = resourceService.getSecurityRules(unadvertisedGroupResourceId);
        securityRulesUnadvertisedGroupResource.add(readOnlyGroupRule);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, unadvertisedGroupResourceId, new SecurityRuleList(securityRulesUnadvertisedGroupResource));
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)adminSecurityContext, Integer.valueOf(0), Integer.valueOf(1000), new Sort("", ""), false, false, false, false, (SearchFilter)new AndFilter());
        List resources = response.getList();
        Assert.assertEquals((long)3L, (long)resources.size());
        Assert.assertTrue((boolean)resources.stream().allMatch(r -> r.isCanEdit() && r.isCanDelete() && r.isCanCopy()));
        response = this.restExtJsService.getExtResourcesList((SecurityContext)user0SecurityContext, Integer.valueOf(0), Integer.valueOf(1000), new Sort("", ""), false, false, false, false, (SearchFilter)new AndFilter());
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        ExtResource groupResource = resources.stream().filter(r -> r.getName().equals("advertisedGroupResource")).findFirst().orElseThrow();
        Assert.assertTrue((boolean)groupResource.isCanEdit());
        Assert.assertTrue((boolean)groupResource.isCanDelete());
        Assert.assertTrue((boolean)groupResource.isCanCopy());
        ExtResource readOnlyResource = resources.stream().filter(r -> r.getName().equals("readOnlyResource")).findFirst().orElseThrow();
        Assert.assertFalse((boolean)readOnlyResource.isCanEdit());
        Assert.assertFalse((boolean)readOnlyResource.isCanDelete());
        Assert.assertTrue((boolean)readOnlyResource.isCanCopy());
    }

    @Test
    public void testExtResourcesList_withTags() throws Exception {
        String CAT0_NAME = "CAT000";
        Tag tagA = new Tag("tagA", "#4561aa", "dusky");
        Tag tagB = new Tag("tagB", "magenta", null);
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext userSecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        long resourceId = this.restCreateResource("ownedResource", "", "CAT000", userId, false);
        long tagAId = tagService.insert(tagA);
        long tagBId = tagService.insert(tagB);
        tagService.addToResource(tagAId, resourceId);
        tagService.addToResource(tagBId, resourceId);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)userSecurityContext, Integer.valueOf(0), Integer.valueOf(1000), new Sort("", ""), false, false, true, false, (SearchFilter)new AndFilter());
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        ExtResource extResource = (ExtResource)resources.get(0);
        Set tags = extResource.getTags();
        Assert.assertEquals((long)2L, (long)tags.size());
        response = this.restExtJsService.getExtResourcesList((SecurityContext)userSecurityContext, Integer.valueOf(0), Integer.valueOf(1000), new Sort("", ""), false, false, false, false, (SearchFilter)new AndFilter());
        resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        extResource = (ExtResource)resources.get(0);
        Assert.assertNull((Object)extResource.getTags());
    }

    @Test
    public void testExtResourcesList_favoritesOnly() throws Exception {
        String CAT0_NAME = "CAT000";
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        long favoriteResourceId = this.restCreateResource("favourite_resource", "", "CAT000", userId, true);
        this.restCreateResource("other_resource", "", "CAT000", userId, true);
        favoriteService.addFavorite(userId, favoriteResourceId);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, true, (SearchFilter)new AndFilter());
        List resources = response.getList();
        Assert.assertEquals((long)1L, (long)resources.size());
        ExtResource resource = (ExtResource)resources.get(0);
        Assert.assertEquals((long)favoriteResourceId, (long)resource.getId());
        Assert.assertEquals((long)1L, (long)response.getCount());
        response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)new AndFilter());
        resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        Assert.assertEquals((long)2L, (long)response.getCount());
    }

    @Test
    public void testExtResourcesList_withFavoriteInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        long favoriteResourceId = this.restCreateResource("favourite_resource", "", "CAT000", userId, true);
        long nonFavoriteResourceId = this.restCreateResource("other_resource", "", "CAT000", userId, true);
        favoriteService.addFavorite(userId, favoriteResourceId);
        ExtResourceList response = this.restExtJsService.getExtResourcesList((SecurityContext)sc, Integer.valueOf(0), Integer.valueOf(100), new Sort("", ""), false, false, false, false, (SearchFilter)new AndFilter());
        List resources = response.getList();
        ExtResource favoriteResource = resources.stream().filter(r -> r.getId().equals(favoriteResourceId)).findFirst().orElseThrow();
        Assert.assertTrue((boolean)favoriteResource.isFavorite());
        ExtResource nonFavoriteResource = resources.stream().filter(r -> r.getId().equals(nonFavoriteResourceId)).findFirst().orElseThrow();
        Assert.assertFalse((boolean)nonFavoriteResource.isFavorite());
    }

    @Test
    public void testGetExtResource_userOwnedWithAttributesInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        ShortAttribute attributeA = new ShortAttribute("attributeA", "ABC", DataType.STRING);
        ShortAttribute attributeB = new ShortAttribute("attributeB", "123.0", DataType.NUMBER);
        long adminId = this.restCreateUser("admin", Role.ADMIN, null, "admin");
        ServiceTestBase.SimpleSecurityContext adminSecurityContext = new ServiceTestBase.SimpleSecurityContext(adminId);
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext user0SecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        long userOwnedResourceId = this.restCreateResource("ownedResource", "", "CAT000", userId, false);
        restResourceService.updateAttribute((SecurityContext)adminSecurityContext, userOwnedResourceId, attributeA.getName(), attributeA.getValue(), attributeA.getType());
        long readOnlyResourceId = this.restCreateResource("readOnlyResource", "", "CAT000", userId, false);
        SecurityRule readOnlyRule = new SecurityRule();
        readOnlyRule.setUser(userService.get(userId));
        readOnlyRule.setCanRead(true);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, readOnlyResourceId, new SecurityRuleList(Collections.singletonList(readOnlyRule)));
        restResourceService.updateAttribute((SecurityContext)adminSecurityContext, readOnlyResourceId, attributeB.getName(), attributeB.getValue(), attributeB.getType());
        long noAttributesResourceId = this.restCreateResource("noAttributesResource", "", "CAT000", userId, false);
        long protectedResourceId = this.restCreateResource("protectedResource", "", "CAT000", userId, false);
        SecurityRule protectedRule = new SecurityRule();
        protectedRule.setUser(userService.get(userId));
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, protectedResourceId, new SecurityRuleList(Collections.singletonList(protectedRule)));
        ExtShortResource response = this.restExtJsService.getExtResource((SecurityContext)adminSecurityContext, userOwnedResourceId, true, true, false);
        Assert.assertTrue((boolean)response.isCanEdit());
        Assert.assertTrue((boolean)response.isCanDelete());
        List attributes = response.getAttributeList().getList();
        Assert.assertEquals((long)1L, (long)attributes.size());
        ShortAttribute attribute = (ShortAttribute)attributes.get(0);
        Assert.assertEquals((Object)attributeA.getName(), (Object)attribute.getName());
        Assert.assertEquals((Object)attributeA.getValue(), (Object)attribute.getValue());
        Assert.assertEquals((Object)attributeA.getType(), (Object)attribute.getType());
        response = this.restExtJsService.getExtResource((SecurityContext)adminSecurityContext, userOwnedResourceId, false, false, false);
        attributes = response.getAttributeList().getList();
        Assert.assertNull((Object)attributes);
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, userOwnedResourceId, true, true, false);
        Assert.assertTrue((boolean)response.isCanEdit());
        Assert.assertTrue((boolean)response.isCanDelete());
        attributes = response.getAttributeList().getList();
        Assert.assertEquals((long)1L, (long)attributes.size());
        attribute = (ShortAttribute)attributes.get(0);
        Assert.assertEquals((Object)attributeA.getName(), (Object)attribute.getName());
        Assert.assertEquals((Object)attributeA.getValue(), (Object)attribute.getValue());
        Assert.assertEquals((Object)attributeA.getType(), (Object)attribute.getType());
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, readOnlyResourceId, true, true, false);
        Assert.assertFalse((boolean)response.isCanEdit());
        Assert.assertFalse((boolean)response.isCanDelete());
        attributes = response.getAttributeList().getList();
        Assert.assertEquals((long)1L, (long)attributes.size());
        attribute = (ShortAttribute)attributes.get(0);
        Assert.assertEquals((Object)attributeB.getName(), (Object)attribute.getName());
        Assert.assertEquals((Object)attributeB.getValue(), (Object)attribute.getValue());
        Assert.assertEquals((Object)attributeB.getType(), (Object)attribute.getType());
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, noAttributesResourceId, true, true, false);
        attributes = response.getAttributeList().getList();
        Assert.assertTrue((boolean)attributes.isEmpty());
        Assert.assertThrows(ForbiddenErrorWebEx.class, () -> this.restExtJsService.getExtResource(user0SecurityContext, protectedResourceId, true, true, false));
        Assert.assertThrows(NotFoundWebEx.class, () -> this.restExtJsService.getExtResource(user0SecurityContext, Long.MAX_VALUE, true, true, false));
    }

    @Test
    public void testGetExtResource_groupOwnedWithAttributesInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        ShortAttribute attributeA = new ShortAttribute("attributeA", "ABC", DataType.STRING);
        ShortAttribute attributeB = new ShortAttribute("attributeB", "2024-08-31 16:22:45.654", DataType.DATE);
        long groupId = this.createGroup("group");
        UserGroup group = userGroupService.get(groupId);
        long adminId = this.restCreateUser("admin", Role.ADMIN, null, "admin");
        ServiceTestBase.SimpleSecurityContext adminSecurityContext = new ServiceTestBase.SimpleSecurityContext(adminId);
        long userId = this.restCreateUser("u0", Role.USER, Collections.singleton(group), "p0");
        ServiceTestBase.SimpleSecurityContext user0SecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        SecurityRule ownerGroupRule = new SecurityRule();
        ownerGroupRule.setGroup(group);
        ownerGroupRule.setCanRead(true);
        ownerGroupRule.setCanWrite(true);
        long groupOwnedResourceId = this.restCreateResource("ownedResource", "", "CAT000", adminId, false);
        List securityRulesGroupOwnedResource = resourceService.getSecurityRules(groupOwnedResourceId);
        securityRulesGroupOwnedResource.add(ownerGroupRule);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, groupOwnedResourceId, new SecurityRuleList(securityRulesGroupOwnedResource));
        restResourceService.updateAttribute((SecurityContext)adminSecurityContext, groupOwnedResourceId, attributeA.getName(), attributeA.getValue(), attributeA.getType());
        SecurityRule readOnlyGroupRule = new SecurityRule();
        readOnlyGroupRule.setGroup(group);
        readOnlyGroupRule.setCanRead(true);
        long readOnlyGroupResourceId = this.restCreateResource("readOnlyResource", "", "CAT000", adminId, false);
        List securityRulesReadOnlyGroupResource = resourceService.getSecurityRules(readOnlyGroupResourceId);
        securityRulesReadOnlyGroupResource.add(readOnlyGroupRule);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, readOnlyGroupResourceId, new SecurityRuleList(securityRulesReadOnlyGroupResource));
        restResourceService.updateAttribute((SecurityContext)adminSecurityContext, readOnlyGroupResourceId, attributeB.getName(), attributeB.getValue(), attributeB.getType());
        SecurityRule protectedRule = new SecurityRule();
        protectedRule.setGroup(group);
        long protectedGroupResourceId = this.restCreateResource("protectedResource", "", "CAT000", adminId, false);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, protectedGroupResourceId, new SecurityRuleList(Collections.singletonList(protectedRule)));
        ExtShortResource response = this.restExtJsService.getExtResource((SecurityContext)adminSecurityContext, groupOwnedResourceId, true, true, false);
        List attributes = response.getAttributeList().getList();
        Assert.assertEquals((long)1L, (long)attributes.size());
        ShortAttribute attribute = (ShortAttribute)attributes.get(0);
        Assert.assertEquals((Object)attributeA.getName(), (Object)attribute.getName());
        Assert.assertEquals((Object)attributeA.getValue(), (Object)attribute.getValue());
        Assert.assertEquals((Object)attributeA.getType(), (Object)attribute.getType());
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, groupOwnedResourceId, true, true, false);
        attributes = response.getAttributeList().getList();
        Assert.assertEquals((long)1L, (long)attributes.size());
        attribute = (ShortAttribute)attributes.get(0);
        Assert.assertEquals((Object)attributeA.getName(), (Object)attribute.getName());
        Assert.assertEquals((Object)attributeA.getValue(), (Object)attribute.getValue());
        Assert.assertEquals((Object)attributeA.getType(), (Object)attribute.getType());
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, readOnlyGroupResourceId, true, true, false);
        Assert.assertFalse((boolean)response.isCanEdit());
        Assert.assertFalse((boolean)response.isCanDelete());
        attributes = response.getAttributeList().getList();
        Assert.assertEquals((long)1L, (long)attributes.size());
        attribute = (ShortAttribute)attributes.get(0);
        Assert.assertEquals((Object)attributeB.getName(), (Object)attribute.getName());
        Assert.assertTrue((boolean)attribute.getValue().matches("2024-08-31T16:22:45.654\\+\\d+"));
        Assert.assertEquals((Object)attributeB.getType(), (Object)attribute.getType());
        Assert.assertThrows(ForbiddenErrorWebEx.class, () -> this.restExtJsService.getExtResource(user0SecurityContext, protectedGroupResourceId, true, true, false));
    }

    @Test
    public void testGetExtResource_userOwnedWithPermissionsInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        long adminId = this.restCreateUser("admin", Role.ADMIN, null, "admin");
        ServiceTestBase.SimpleSecurityContext adminSecurityContext = new ServiceTestBase.SimpleSecurityContext(adminId);
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext user0SecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        long noPermissionsResourceId = this.restCreateResource("noPermissionsResource", "", "CAT000", adminId, false);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, noPermissionsResourceId, new SecurityRuleList(Collections.emptyList()));
        long userOwnedResourceId = this.restCreateResource("ownedResource", "", "CAT000", userId, false);
        long readOnlyResourceId = this.restCreateResource("readOnlyResource", "", "CAT000", userId, false);
        SecurityRule readOnlyRule = new SecurityRule();
        readOnlyRule.setUser(userService.get(userId));
        readOnlyRule.setCanRead(true);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, readOnlyResourceId, new SecurityRuleList(Collections.singletonList(readOnlyRule)));
        long protectedResourceId = this.restCreateResource("protectedResource", "", "CAT000", userId, false);
        SecurityRule protectedRule = new SecurityRule();
        protectedRule.setUser(userService.get(userId));
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, protectedResourceId, new SecurityRuleList(Collections.singletonList(protectedRule)));
        ExtShortResource response = this.restExtJsService.getExtResource((SecurityContext)adminSecurityContext, noPermissionsResourceId, true, true, false);
        List securityRules = response.getSecurityRuleList().getList();
        Assert.assertTrue((boolean)securityRules.isEmpty());
        response = this.restExtJsService.getExtResource((SecurityContext)adminSecurityContext, userOwnedResourceId, true, true, false);
        Assert.assertTrue((boolean)response.isCanEdit());
        Assert.assertTrue((boolean)response.isCanDelete());
        securityRules = response.getSecurityRuleList().getList();
        Assert.assertEquals((long)1L, (long)securityRules.size());
        response = this.restExtJsService.getExtResource((SecurityContext)adminSecurityContext, userOwnedResourceId, false, false, false);
        securityRules = response.getSecurityRuleList().getList();
        Assert.assertNull((Object)securityRules);
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, userOwnedResourceId, true, true, false);
        Assert.assertTrue((boolean)response.isCanEdit());
        Assert.assertTrue((boolean)response.isCanDelete());
        securityRules = response.getSecurityRuleList().getList();
        Assert.assertEquals((long)1L, (long)securityRules.size());
        RESTSecurityRule securityRule = (RESTSecurityRule)securityRules.get(0);
        Assert.assertEquals((long)userId, (long)securityRule.getUser().getId());
        Assert.assertTrue((boolean)securityRule.isCanRead());
        Assert.assertTrue((boolean)securityRule.isCanWrite());
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, readOnlyResourceId, true, true, false);
        Assert.assertFalse((boolean)response.isCanEdit());
        Assert.assertFalse((boolean)response.isCanDelete());
        securityRules = response.getSecurityRuleList().getList();
        Assert.assertEquals((long)1L, (long)securityRules.size());
        securityRule = (RESTSecurityRule)securityRules.get(0);
        Assert.assertEquals((long)userId, (long)securityRule.getUser().getId());
        Assert.assertTrue((boolean)securityRule.isCanRead());
        Assert.assertFalse((boolean)securityRule.isCanWrite());
        Assert.assertThrows(ForbiddenErrorWebEx.class, () -> this.restExtJsService.getExtResource(user0SecurityContext, protectedResourceId, true, true, false));
        Assert.assertThrows(NotFoundWebEx.class, () -> this.restExtJsService.getExtResource(user0SecurityContext, Long.MAX_VALUE, true, true, false));
    }

    @Test
    public void testGetExtResource_groupOwnedWithPermissionsInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        long groupId = this.createGroup("group");
        UserGroup group = userGroupService.get(groupId);
        long adminId = this.restCreateUser("admin", Role.ADMIN, null, "admin");
        ServiceTestBase.SimpleSecurityContext adminSecurityContext = new ServiceTestBase.SimpleSecurityContext(adminId);
        long userId = this.restCreateUser("u0", Role.USER, Collections.singleton(group), "p0");
        ServiceTestBase.SimpleSecurityContext user0SecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        SecurityRule ownerGroupRule = new SecurityRule();
        ownerGroupRule.setGroup(group);
        ownerGroupRule.setCanRead(true);
        ownerGroupRule.setCanWrite(true);
        long groupOwnedResourceId = this.restCreateResource("ownedResource", "", "CAT000", adminId, false);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, groupOwnedResourceId, new SecurityRuleList(Collections.singletonList(ownerGroupRule)));
        SecurityRule readOnlyGroupRule = new SecurityRule();
        readOnlyGroupRule.setGroup(group);
        readOnlyGroupRule.setCanRead(true);
        long readOnlyGroupResourceId = this.restCreateResource("readOnlyResource", "", "CAT000", adminId, false);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, readOnlyGroupResourceId, new SecurityRuleList(Collections.singletonList(readOnlyGroupRule)));
        SecurityRule protectedRule = new SecurityRule();
        protectedRule.setGroup(group);
        long protectedGroupResourceId = this.restCreateResource("protectedResource", "", "CAT000", adminId, false);
        restResourceService.updateSecurityRules((SecurityContext)adminSecurityContext, protectedGroupResourceId, new SecurityRuleList(Collections.singletonList(protectedRule)));
        ExtShortResource response = this.restExtJsService.getExtResource((SecurityContext)adminSecurityContext, groupOwnedResourceId, true, true, false);
        Assert.assertTrue((boolean)response.isCanEdit());
        Assert.assertTrue((boolean)response.isCanDelete());
        List securityRules = response.getSecurityRuleList().getList();
        Assert.assertEquals((long)1L, (long)securityRules.size());
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, groupOwnedResourceId, true, true, false);
        Assert.assertTrue((boolean)response.isCanEdit());
        Assert.assertTrue((boolean)response.isCanDelete());
        securityRules = response.getSecurityRuleList().getList();
        Assert.assertEquals((long)1L, (long)securityRules.size());
        RESTSecurityRule securityRule = (RESTSecurityRule)securityRules.get(0);
        Assert.assertEquals((long)groupId, (long)securityRule.getGroup().getId());
        Assert.assertTrue((boolean)securityRule.isCanRead());
        Assert.assertTrue((boolean)securityRule.isCanWrite());
        response = this.restExtJsService.getExtResource((SecurityContext)user0SecurityContext, readOnlyGroupResourceId, true, true, false);
        Assert.assertFalse((boolean)response.isCanEdit());
        Assert.assertFalse((boolean)response.isCanDelete());
        securityRules = response.getSecurityRuleList().getList();
        Assert.assertEquals((long)1L, (long)securityRules.size());
        securityRule = (RESTSecurityRule)securityRules.get(0);
        Assert.assertEquals((long)groupId, (long)securityRule.getGroup().getId());
        Assert.assertTrue((boolean)securityRule.isCanRead());
        Assert.assertFalse((boolean)securityRule.isCanWrite());
        Assert.assertThrows(ForbiddenErrorWebEx.class, () -> this.restExtJsService.getExtResource(user0SecurityContext, protectedGroupResourceId, true, true, false));
    }

    @Test
    public void testGetExtResource_withTags() throws Exception {
        String CAT0_NAME = "CAT000";
        Tag tagA = new Tag("tagA", "#4561aa", "dusky");
        Tag tagB = new Tag("tagB", "magenta", null);
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext userSecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        long resourceId = this.restCreateResource("ownedResource", "", "CAT000", userId, false);
        long tagAId = tagService.insert(tagA);
        long tagBId = tagService.insert(tagB);
        tagService.addToResource(tagAId, resourceId);
        tagService.addToResource(tagBId, resourceId);
        ExtShortResource response = this.restExtJsService.getExtResource((SecurityContext)userSecurityContext, resourceId, false, false, true);
        Collection tags = response.getTagList().getList();
        Assert.assertEquals((long)2L, (long)tags.size());
        response = this.restExtJsService.getExtResource((SecurityContext)userSecurityContext, resourceId, false, false, false);
        Assert.assertNull((Object)response.getTagList().getList());
    }

    @Test
    public void testGetExtResource_withFavoriteInformation() throws Exception {
        String CAT0_NAME = "CAT000";
        long userId = this.restCreateUser("u0", Role.USER, null, "p0");
        ServiceTestBase.SimpleSecurityContext userSecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        this.createCategory("CAT000");
        long favoriteResourceId = this.restCreateResource("favourite_resource", "", "CAT000", userId, true);
        long nonFavoriteResourceId = this.restCreateResource("other_resource", "", "CAT000", userId, true);
        favoriteService.addFavorite(userId, favoriteResourceId);
        ExtShortResource response = this.restExtJsService.getExtResource((SecurityContext)userSecurityContext, favoriteResourceId, false, false, true);
        Assert.assertTrue((boolean)response.isFavorite());
        response = this.restExtJsService.getExtResource((SecurityContext)userSecurityContext, nonFavoriteResourceId, false, false, true);
        Assert.assertFalse((boolean)response.isFavorite());
    }

    @Test
    public void testGetGroupsList() throws Exception {
        String groupAName = "groupA";
        long groupAId = this.createGroup("groupA");
        UserGroup groupA = userGroupService.get(groupAId);
        this.createGroup("groupB");
        long adminId = this.restCreateUser("admin", Role.ADMIN, null, "admin");
        ServiceTestBase.SimpleSecurityContext adminSecurityContext = new ServiceTestBase.SimpleSecurityContext(adminId);
        long userId = this.restCreateUser("u0", Role.USER, Collections.singleton(groupA), "p0");
        ServiceTestBase.SimpleSecurityContext userSecurityContext = new ServiceTestBase.SimpleSecurityContext(userId);
        ExtGroupList response = this.restExtJsService.getGroupsList((SecurityContext)adminSecurityContext, null, Integer.valueOf(0), Integer.valueOf(1000), true);
        List resources = response.getList();
        Assert.assertEquals((long)2L, (long)resources.size());
        response = this.restExtJsService.getGroupsList((SecurityContext)userSecurityContext, null, Integer.valueOf(0), Integer.valueOf(1000), true);
        List userGroups = response.getList();
        Assert.assertEquals((long)1L, (long)userGroups.size());
        UserGroup userGroup = (UserGroup)userGroups.get(0);
        Assert.assertEquals((Object)"groupA", (Object)userGroup.getGroupName());
    }

    private JSONResult parse(String jsonString) {
        Set<String> names;
        JSONResult ret = new JSONResult();
        JSON json = JSONSerializer.toJSON((Object)jsonString);
        JSONObject jo = (JSONObject)json;
        ret.total = jo.getInt("totalCount");
        JSONArray arrResults = jo.optJSONArray("results");
        if (arrResults != null) {
            names = this.getArray(arrResults);
        } else {
            JSONObject results = jo.optJSONObject("results");
            if (results != null) {
                names = Collections.singleton(this.getSingle(results));
            } else {
                this.LOGGER.warn("No results found");
                names = Collections.emptySet();
            }
        }
        ret.names = names;
        ret.returnedCount = names.size();
        return ret;
    }

    Set<String> getArray(JSONArray arr) {
        HashSet<String> ret = new HashSet<String>();
        for (Object object : arr) {
            ret.add(this.getSingle((JSONObject)object));
        }
        return ret;
    }

    String getSingle(JSONObject jo) {
        return jo.getString("name");
    }

    static class JSONResult {
        int total;
        int returnedCount;
        Set<String> names;

        JSONResult() {
        }
    }
}

