/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.Tag;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.ResourcePermissionService;
import it.geosolutions.geostore.services.ResourceService;
import it.geosolutions.geostore.services.SecurityService;
import it.geosolutions.geostore.services.UserGroupService;
import it.geosolutions.geostore.services.dto.ResourceSearchParameters;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.AndFilter;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.exception.BadRequestServiceEx;
import it.geosolutions.geostore.services.exception.InternalErrorServiceEx;
import it.geosolutions.geostore.services.model.ExtGroupList;
import it.geosolutions.geostore.services.model.ExtResource;
import it.geosolutions.geostore.services.model.ExtResourceList;
import it.geosolutions.geostore.services.model.ExtShortResource;
import it.geosolutions.geostore.services.model.ExtUserList;
import it.geosolutions.geostore.services.rest.RESTExtJsService;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.ForbiddenErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.impl.RESTServiceImpl;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.model.ShortAttributeList;
import it.geosolutions.geostore.services.rest.model.Sort;
import it.geosolutions.geostore.services.rest.model.TagList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.core.SecurityContext;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RESTExtJsServiceImpl
extends RESTServiceImpl
implements RESTExtJsService {
    private static final Logger LOGGER = LogManager.getLogger(RESTExtJsServiceImpl.class);
    private ResourceService resourceService;
    private UserGroupService groupService;
    private ResourcePermissionService resourcePermissionService;

    public void setResourceService(ResourceService resourceService) {
        this.resourceService = resourceService;
    }

    public void setUserGroupService(UserGroupService userGroupService) {
        this.groupService = userGroupService;
    }

    public void setResourcePermissionService(ResourcePermissionService resourcePermissionService) {
        this.resourcePermissionService = resourcePermissionService;
    }

    protected SecurityService getSecurityService() {
        return this.resourceService;
    }

    @Override
    public String getAllResources(SecurityContext sc, String nameLike, Integer start, Integer limit) throws BadRequestWebEx {
        if (start == null || limit == null) {
            throw new BadRequestWebEx("Request parameters are missing !");
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Retrieving paginated resource list (start={} limit={})", (Object)start, (Object)limit);
        }
        User authUser = null;
        try {
            authUser = this.extractAuthUser(sc);
        }
        catch (InternalErrorWebEx ie) {
            LOGGER.warn("Error in validating user (this action should probably be aborted)", (Throwable)ie);
        }
        int page = start == 0 ? start : start / limit;
        try {
            String sqlNameLike = RESTExtJsServiceImpl.convertNameLikeToSqlSyntax((String)nameLike);
            List resources = this.resourceService.getList(ResourceSearchParameters.builder().nameLike(sqlNameLike).page(Integer.valueOf(page)).entries(limit).authUser(authUser).build());
            long count = 0L;
            if (resources != null && !resources.isEmpty()) {
                count = this.resourceService.count(sqlNameLike, authUser);
            }
            JSONObject result = this.makeJSONResult(true, count, resources, authUser);
            return result.toString();
        }
        catch (BadRequestServiceEx | InternalErrorServiceEx e) {
            LOGGER.warn(e.getMessage(), e);
            JSONObject obj = this.makeJSONResult(false, 0L, null, authUser);
            return obj.toString();
        }
    }

    @Override
    public String getResourcesByCategory(SecurityContext sc, String categoryName, Integer start, Integer limit, boolean includeAttributes, boolean includeData) throws BadRequestWebEx {
        return this.getResourcesByCategory(sc, categoryName, null, start, limit, includeAttributes, includeData);
    }

    @Override
    public String getResourcesByCategory(SecurityContext sc, String categoryName, String resourceNameLike, Integer start, Integer limit, boolean includeAttributes, boolean includeData) throws BadRequestWebEx {
        return this.getResourcesByCategory(sc, categoryName, resourceNameLike, null, start, limit, includeAttributes, includeData);
    }

    @Override
    public String getResourcesByCategory(SecurityContext sc, String categoryName, String resourceNameLike, String extraAttributes, Integer start, Integer limit, boolean includeAttributes, boolean includeData) throws BadRequestWebEx, InternalErrorWebEx {
        List<String> extraAttributesList;
        if (start != null && limit == null || start == null && limit != null) {
            throw new BadRequestWebEx("start and limit params should be declared together");
        }
        if (categoryName == null) {
            throw new BadRequestWebEx("Category is null");
        }
        List<String> list = extraAttributesList = extraAttributes != null ? Arrays.asList(extraAttributes.split(",")) : Collections.emptyList();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getResourcesByCategory(" + categoryName + ", start=" + start + ", limit=" + limit + (String)(resourceNameLike != null ? ", search=" + resourceNameLike : ""));
        }
        User authUser = null;
        try {
            authUser = this.extractAuthUser(sc);
        }
        catch (InternalErrorWebEx ie) {
            LOGGER.warn("Error in validating user (this action should probably be aborted)", (Throwable)ie);
        }
        Integer page = null;
        if (start != null) {
            page = start / limit;
        }
        try {
            CategoryFilter filter = new CategoryFilter(categoryName, SearchOperator.EQUAL_TO);
            if (resourceNameLike != null) {
                filter = new AndFilter((SearchFilter)filter, (SearchFilter)new FieldFilter(BaseField.NAME, RESTExtJsServiceImpl.convertNameLikeToSqlSyntax((String)resourceNameLike), SearchOperator.ILIKE), new SearchFilter[0]);
            }
            boolean shouldIncludeAttributes = includeAttributes || extraAttributes != null && !extraAttributes.isEmpty();
            List resources = this.resourceService.getResources(ResourceSearchParameters.builder().filter((SearchFilter)filter).page(page).entries(limit).includeAttributes(shouldIncludeAttributes).includeData(includeData).authUser(authUser).build());
            long count = 0L;
            if (!resources.isEmpty()) {
                count = this.resourceService.count((SearchFilter)filter, authUser);
            }
            JSONObject result = this.makeExtendedJSONResult(true, count, resources, authUser, extraAttributesList, includeAttributes, includeData);
            return result.toString();
        }
        catch (BadRequestServiceEx | InternalErrorServiceEx e) {
            LOGGER.warn(e.getMessage(), e);
            JSONObject obj = this.makeJSONResult(false, 0L, null, authUser);
            return obj.toString();
        }
    }

    @Override
    public ExtResourceList getExtResourcesList(SecurityContext sc, Integer start, Integer limit, Sort sort, boolean includeAttributes, boolean includeData, boolean includeTags, boolean favoritesOnly, SearchFilter filter) throws BadRequestWebEx {
        if (start != null && limit == null || start == null && limit != null) {
            throw new BadRequestWebEx("start and limit params should be declared together");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getResourcesList(start={}, limit={}, includeAttributes={}, includeData={}, includeTags={}, favoritesOnly={}", (Object)start, (Object)limit, (Object)includeAttributes, (Object)includeData, (Object)includeTags, (Object)favoritesOnly);
        }
        User authUser = null;
        try {
            authUser = this.extractAuthUser(sc);
        }
        catch (InternalErrorWebEx ie) {
            LOGGER.warn("Error in validating user (this action should probably be aborted)", (Throwable)ie);
        }
        Integer page = null;
        if (start != null) {
            page = start / limit;
        }
        try {
            ResourceSearchParameters searchParameters = ResourceSearchParameters.builder().filter(filter).page(page).entries(limit).sortBy(sort.getSortBy()).sortOrder(sort.getSortOrder()).includeAttributes(includeAttributes).includeData(includeData).includeTags(includeTags).favoritesOnly(favoritesOnly).authUser(authUser).build();
            List resources = this.resourceService.getResources(searchParameters);
            long count = 0L;
            if (!resources.isEmpty()) {
                count = this.resourceService.count(filter, authUser, favoritesOnly);
            }
            return new ExtResourceList(count, this.convertToExtResources(resources, authUser));
        }
        catch (BadRequestServiceEx | InternalErrorServiceEx e) {
            LOGGER.warn(e.getMessage(), e);
            return null;
        }
    }

    private List<ExtResource> convertToExtResources(List<Resource> foundResources, User user) {
        this.userService.fetchSecurityRules(user);
        this.userService.fetchFavorites(user);
        return foundResources.stream().map(r -> this.convertToExtResource((Resource)r, user)).collect(Collectors.toList());
    }

    private ExtResource convertToExtResource(Resource resource, User user) {
        ExtResource.Builder extResourceBuilder = ExtResource.builder(resource).withCanCopy(user != null);
        if (this.resourcePermissionService.canUserWriteResource(user, resource)) {
            extResourceBuilder.withCanEdit(true).withCanDelete(true);
        }
        if (user != null) {
            extResourceBuilder.withIsFavorite(this.isResourceUserFavorite(resource, user));
        }
        return extResourceBuilder.build();
    }

    private boolean isResourceUserFavorite(Resource resource, User user) {
        return user.getFavorites().stream().map(Resource::getId).anyMatch(id -> id.equals(resource.getId()));
    }

    private JSONObject makeExtendedJSONResult(boolean success, long count, List<Resource> resources, User authUser, List<String> extraAttributes, boolean includeAttributes, boolean includeData) {
        return this.makeGeneralizedJSONResult(success, count, resources, authUser, extraAttributes, includeAttributes, includeData);
    }

    private JSONObject makeJSONResult(boolean success, long count, List<ShortResource> resources, User authUser) {
        return this.makeGeneralizedJSONResult(success, count, resources, authUser, null, false, false);
    }

    @Override
    public ExtUserList getUsersList(SecurityContext sc, String nameLike, Integer start, Integer limit, boolean includeAttributes) throws BadRequestWebEx {
        if (start != null && limit == null || start == null && limit != null) {
            throw new BadRequestWebEx("start and limit params should be declared together");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getUsersList(start={}, limit={}", (Object)start, (Object)limit);
        }
        Integer page = null;
        if (start != null) {
            page = start / limit;
        }
        try {
            String sqlNameLike = RESTExtJsServiceImpl.convertNameLikeToSqlSyntax((String)nameLike);
            List users = this.userService.getAll(page, limit, sqlNameLike, includeAttributes);
            long count = 0L;
            if (users != null && !users.isEmpty()) {
                count = this.userService.getCount(sqlNameLike);
            }
            return new ExtUserList(count, users);
        }
        catch (BadRequestServiceEx e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public ExtGroupList getGroupsList(SecurityContext sc, String nameLike, Integer start, Integer limit, boolean all) throws BadRequestWebEx {
        if (start != null && limit == null || start == null && limit != null) {
            throw new BadRequestWebEx("start and limit params should be declared together");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("getGroupsList(start={}, limit={}", (Object)start, (Object)limit);
        }
        Integer page = null;
        if (start != null) {
            page = start / limit;
        }
        User authUser = null;
        try {
            authUser = this.extractAuthUser(sc);
        }
        catch (InternalErrorWebEx ie) {
            LOGGER.warn("Error in validating user (this action should probably be aborted)", (Throwable)ie);
            return null;
        }
        try {
            String sqlNameLike = RESTExtJsServiceImpl.convertNameLikeToSqlSyntax((String)nameLike);
            List groups = this.groupService.getAllAllowed(authUser, page, limit, sqlNameLike, all);
            long count = 0L;
            if (groups != null && !groups.isEmpty()) {
                count = this.groupService.getCount(authUser, sqlNameLike, all);
            }
            return new ExtGroupList(count, groups);
        }
        catch (BadRequestServiceEx e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private JSONObject makeGeneralizedJSONResult(boolean success, long count, List<?> resources, User authUser, List<String> extraAttributes, boolean includeAttributes, boolean includeData) {
        JSONObject jsonObj = new JSONObject();
        jsonObj.put((Object)"success", (Object)success);
        jsonObj.put((Object)"totalCount", (Object)count);
        if (resources != null) {
            Iterator<?> iterator = resources.iterator();
            int size = resources.size();
            Object result = size == 0 ? null : (size > 1 ? new JSONArray() : new JSONObject());
            while (iterator.hasNext()) {
                String description;
                Object obj = iterator.next();
                ResourceEnvelop sr = null;
                if (obj instanceof Resource) {
                    sr = new ResourceEnvelop((Resource)obj, authUser);
                } else if (obj instanceof ShortResource) {
                    sr = new ResourceEnvelop((ShortResource)obj, authUser);
                }
                if (sr == null) continue;
                JSONObject jobj = new JSONObject();
                jobj.element("canDelete", sr.isCanDelete());
                jobj.element("canEdit", sr.isCanEdit());
                jobj.element("canCopy", (Object)sr.isCanCopy());
                Date date = sr.getCreation();
                if (date != null) {
                    jobj.element("creation", (Object)date.toString());
                }
                if ((date = sr.getLastUpdate()) != null) {
                    jobj.element("lastUpdate", (Object)date.toString());
                }
                if ((description = sr.getDescription()) != null) {
                    jobj.element("description", (Object)description);
                }
                jobj.element("id", sr.getId());
                jobj.element("name", (Object)sr.getName());
                String owner = sr.getOwner();
                if (sr.getAttribute() != null) {
                    for (Attribute at : sr.getAttribute()) {
                        if (includeAttributes || extraAttributes != null && extraAttributes.contains(at.getName())) {
                            jobj.element(at.getName(), (Object)at.getValue());
                        }
                        if (!"owner".equals(at.getName())) continue;
                        owner = at.getValue();
                    }
                }
                if (includeData) {
                    assert (obj instanceof Resource);
                    jobj.element("data", (Object)((Resource)obj).getData().getData());
                }
                if (owner != null) {
                    jobj.element("owner", (Object)owner);
                }
                if (sr.getCreator() != null) {
                    jobj.element("creator", (Object)sr.getCreator());
                } else if (owner != null) {
                    jobj.element("creator", (Object)owner);
                }
                if (sr.getEditor() != null) {
                    jobj.element("editor", (Object)sr.getEditor());
                } else if (owner != null) {
                    jobj.element("editor", (Object)owner);
                }
                if (result instanceof JSONArray) {
                    result.add((Object)jobj);
                    continue;
                }
                result = jobj;
            }
            jsonObj.put((Object)"results", (Object)(result != null ? result.toString() : ""));
        } else {
            jsonObj.put((Object)"results", (Object)"");
        }
        return jsonObj;
    }

    @Override
    public ExtShortResource getExtResource(SecurityContext sc, long id, boolean includeAttributes, boolean includePermissions, boolean includeTags) {
        Resource resource = this.resourceService.getResource(id, includeAttributes, includePermissions, includeTags);
        if (resource == null) {
            throw new NotFoundWebEx("Resource not found");
        }
        User authUser = this.extractAuthUser(sc);
        this.userService.fetchSecurityRules(authUser);
        this.userService.fetchFavorites(authUser);
        if (!this.resourcePermissionService.canUserReadResource(authUser, Long.valueOf(id))) {
            throw new ForbiddenErrorWebEx("Resource is protected");
        }
        ShortResource shortResource = new ShortResource(resource);
        if (this.resourcePermissionService.canUserWriteResource(authUser, resource)) {
            shortResource.setCanEdit(true);
            shortResource.setCanDelete(true);
        }
        return ExtShortResource.builder(shortResource).withAttributes(this.createShortAttributeList(resource.getAttribute())).withSecurityRules(new SecurityRuleList(resource.getSecurity())).withTagList(this.createTagList(resource.getTags())).withIsFavorite(this.isResourceUserFavorite(resource, authUser)).build();
    }

    private ShortAttributeList createShortAttributeList(List<Attribute> attributes) {
        if (attributes == null) {
            return new ShortAttributeList();
        }
        return new ShortAttributeList(attributes.stream().map(ShortAttribute::new).collect(Collectors.toList()));
    }

    private TagList createTagList(Set<Tag> tags) {
        if (tags == null) {
            return new TagList();
        }
        return new TagList(tags, Long.valueOf(tags.size()));
    }

    private class ResourceEnvelop {
        ShortResource sr;
        Resource r;
        String owner;
        User authUser;
        boolean canEdit = false;
        boolean canDelete = false;

        private ResourceEnvelop(ShortResource sr, User authUser) {
            this.sr = sr;
            this.authUser = authUser;
            this.readSecurity();
        }

        private ResourceEnvelop(Resource r, User authUser) {
            this.r = r;
            this.authUser = authUser;
            this.readSecurity();
        }

        private void readSecurity() {
            if (this.sr != null) {
                this.canDelete = this.sr.isCanDelete();
                this.canEdit = this.sr.isCanEdit();
                return;
            }
            RESTExtJsServiceImpl.this.userService.fetchSecurityRules(this.authUser);
            if (this.authUser != null && RESTExtJsServiceImpl.this.resourcePermissionService.canUserWriteResource(this.authUser, this.r)) {
                this.canEdit = true;
                this.canDelete = true;
            }
        }

        boolean isCanDelete() {
            return this.canDelete;
        }

        boolean isCanEdit() {
            return this.canEdit;
        }

        Date getCreation() {
            return this.sr != null ? this.sr.getCreation() : this.r.getCreation();
        }

        Date getLastUpdate() {
            return this.sr != null ? this.sr.getLastUpdate() : this.r.getLastUpdate();
        }

        String getDescription() {
            return this.sr != null ? this.sr.getDescription() : this.r.getDescription();
        }

        long getId() {
            return this.sr != null ? this.sr.getId() : this.r.getId().longValue();
        }

        String getName() {
            return this.sr != null ? this.sr.getName() : this.r.getName();
        }

        List<Attribute> getAttribute() {
            return this.r != null ? this.r.getAttribute() : null;
        }

        public Boolean isCanCopy() {
            return this.authUser != null;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getCreator() {
            String creator = this.sr != null ? this.sr.getCreator() : this.r.getCreator();
            return creator != null ? creator : this.getOwner();
        }

        public String getEditor() {
            String editor = this.sr != null ? this.sr.getEditor() : this.r.getEditor();
            return editor != null ? editor : this.getOwner();
        }
    }
}

