/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.model.ExtGroupList;
import it.geosolutions.geostore.services.model.ExtResourceList;
import it.geosolutions.geostore.services.model.ExtUserList;
import it.geosolutions.geostore.services.rest.exception.BadRequestWebEx;
import it.geosolutions.geostore.services.rest.exception.InternalErrorWebEx;
import it.geosolutions.geostore.services.rest.exception.NotFoundWebEx;
import it.geosolutions.geostore.services.rest.model.Sort;
import javax.annotation.security.RolesAllowed;
import javax.ws.rs.BeanParam;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.SecurityContext;
import org.apache.cxf.jaxrs.ext.multipart.Multipart;
import org.springframework.security.access.annotation.Secured;

public interface RESTExtJsService {
    @GET
    @Path(value="/search/resource/{nameLike}")
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_ANONYMOUS"})
    public String getAllResources(@Context SecurityContext var1, @PathParam(value="nameLike") String var2, @QueryParam(value="start") Integer var3, @QueryParam(value="limit") Integer var4) throws BadRequestWebEx;

    @GET
    @Path(value="/search/category/{categoryName}")
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_ANONYMOUS"})
    public String getResourcesByCategory(@Context SecurityContext var1, @PathParam(value="categoryName") String var2, @QueryParam(value="start") Integer var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var5, @QueryParam(value="includeData") @DefaultValue(value="false") boolean var6) throws BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/search/category/{categoryName}/{resourceNameLike}")
    @Produces(value={"application/json", "text/xml"})
    @RolesAllowed(value={"ADMIN", "USER", "GUEST"})
    public String getResourcesByCategory(@Context SecurityContext var1, @PathParam(value="categoryName") String var2, @PathParam(value="resourceNameLike") String var3, @QueryParam(value="start") Integer var4, @QueryParam(value="limit") Integer var5, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var6, @QueryParam(value="includeData") @DefaultValue(value="false") boolean var7) throws BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/search/category/{categoryName}/{resourceNameLike}/{extraAttributes}")
    @Produces(value={"application/json"})
    @RolesAllowed(value={"ADMIN", "USER", "GUEST"})
    public String getResourcesByCategory(@Context SecurityContext var1, @PathParam(value="categoryName") String var2, @PathParam(value="resourceNameLike") String var3, @PathParam(value="extraAttributes") String var4, @QueryParam(value="start") Integer var5, @QueryParam(value="limit") Integer var6, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var7, @QueryParam(value="includeData") @DefaultValue(value="false") boolean var8) throws BadRequestWebEx, InternalErrorWebEx;

    @POST
    @GET
    @Path(value="/search/list")
    @Produces(value={"text/xml", "application/json"})
    @Consumes(value={"application/xml", "text/xml"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER", "ROLE_ANONYMOUS"})
    public ExtResourceList getExtResourcesList(@Context SecurityContext var1, @QueryParam(value="start") Integer var2, @QueryParam(value="limit") Integer var3, @BeanParam Sort var4, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var5, @QueryParam(value="includeData") @DefaultValue(value="false") boolean var6, @Multipart(value="filter") SearchFilter var7) throws BadRequestWebEx, InternalErrorWebEx;

    @GET
    @Path(value="/search/users/{nameLike}")
    @Produces(value={"application/json"})
    @Secured(value={"ROLE_ADMIN"})
    public ExtUserList getUsersList(@Context SecurityContext var1, @PathParam(value="nameLike") String var2, @QueryParam(value="start") Integer var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="includeAttributes") @DefaultValue(value="false") boolean var5) throws BadRequestWebEx;

    @GET
    @Path(value="/search/groups/{nameLike}")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_ADMIN", "ROLE_USER"})
    public ExtGroupList getGroupsList(@Context SecurityContext var1, @PathParam(value="nameLike") String var2, @QueryParam(value="start") Integer var3, @QueryParam(value="limit") Integer var4, @QueryParam(value="all") @DefaultValue(value="false") boolean var5) throws BadRequestWebEx;

    @GET
    @Path(value="/resource/{id}")
    @Produces(value={"text/xml", "application/json"})
    @Secured(value={"ROLE_USER", "ROLE_ADMIN", "ROLE_ANONYMOUS"})
    public ShortResource getResource(@Context SecurityContext var1, @PathParam(value="id") long var2) throws NotFoundWebEx;
}

