/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.impl;

import com.googlecode.genericdao.search.ISearch;
import com.googlecode.genericdao.search.Search;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.rest.impl.RESTExtJsServiceImpl;
import it.geosolutions.geostore.services.rest.impl.ServiceTestBase;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.ws.rs.core.SecurityContext;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.JSONSerializer;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RESTExtJsServiceImplTest
extends ServiceTestBase {
    private final RESTExtJsServiceImpl restExtJsService = (RESTExtJsServiceImpl)ctx.getBean("restExtJsService", RESTExtJsServiceImpl.class);

    public RESTExtJsServiceImplTest() {
        Assert.assertNotNull((Object)this.restExtJsService);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        Assert.assertNotNull((Object)this.restExtJsService);
        this.removeAll();
    }

    @Test
    public void testGetAllResources_auth_base() throws Exception {
        String CAT_NAME = "CAT000";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        long u1 = this.restCreateUser("u1", Role.USER, null, "p1");
        Category cat = this.createCategory("CAT000");
        this.restCreateResource("r_u0_0", "x", "CAT000", u0, true);
        this.restCreateResource("r_u1_0", "x", "CAT000", u1, true);
        this.restCreateResource("r_u1_1", "x", "CAT000", u1, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)1L, (long)result.total);
        Assert.assertEquals((long)1L, (long)result.returnedCount);
        Assert.assertTrue((boolean)result.names.contains("r_u0_0"));
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)2L, (long)result.total);
        Assert.assertEquals((long)2L, (long)result.returnedCount);
        Assert.assertTrue((boolean)result.names.contains("r_u1_0"));
        Assert.assertTrue((boolean)result.names.contains("r_u1_1"));
        Assert.assertFalse((boolean)result.names.contains("r_u0_0"));
    }

    @Test
    public void testGetAllResources_auth_many() throws Exception {
        String CAT_NAME = "CAT009";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        long u1 = this.restCreateUser("u1", Role.USER, null, "p1");
        Category cat = this.createCategory("CAT009");
        int RESNUM0 = 20;
        int RESNUM1 = RESNUM0 * 2;
        for (int i = 1000; i < 1000 + RESNUM0; ++i) {
            this.restCreateResource("r_u0_" + i, "x", "CAT009", u0, true);
            this.restCreateResource("r_u1_" + i + "a", "x", "CAT009", u1, true);
            this.restCreateResource("r_u1_" + i + "b", "x", "CAT009", u1, true);
        }
        int cnt = resourceDAO.count((ISearch)new Search(Resource.class));
        Assert.assertEquals((long)(RESNUM0 + RESNUM1), (long)cnt);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("JSON for u0 " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)RESNUM0, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*", Integer.valueOf(0), Integer.valueOf(10));
        System.out.println("JSON for u1 " + response);
        result = this.parse(response);
        Assert.assertEquals((long)RESNUM1, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT009", "*", Integer.valueOf(0), Integer.valueOf(10), false, false);
        System.out.println("JSON for u0 " + response);
        result = this.parse(response);
        Assert.assertEquals((long)RESNUM0, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT009", "*", Integer.valueOf(0), Integer.valueOf(10), false, false);
        System.out.println("JSON for u1 " + response);
        result = this.parse(response);
        Assert.assertEquals((long)RESNUM1, (long)result.total);
        Assert.assertEquals((long)10L, (long)result.returnedCount);
    }

    @Test
    public void testGetAllResources_iLike() throws Exception {
        String CAT0_NAME = "CAT000";
        String CAT1_NAME = "CAT111";
        String RES_NAME = "a MiXeD cAsE sTrInG";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        long u0 = this.restCreateUser("u0", Role.USER, null, "p0");
        this.createCategory("CAT000");
        this.createCategory("CAT111");
        this.restCreateResource("a MiXeD cAsE sTrInG", "x", "CAT000", u0, true);
        this.restCreateResource("a MiXeD cAsE sTrInG".toLowerCase(), "x", "CAT000", u0, true);
        this.restCreateResource("a MiXeD cAsE sTrInG".toUpperCase(), "x", "CAT000", u0, true);
        this.restCreateResource("a MiXeD cAsE sTrInG in another category", "x", "CAT111", u0, true);
        this.restCreateResource("just an extra resource we shouldn't care about", "x", "CAT000", u0, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)4L, (long)result.total);
        Assert.assertEquals((long)4L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT000", "*mIxEd*", null, Integer.valueOf(0), Integer.valueOf(1000), false, false);
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)3L, (long)result.total);
        Assert.assertEquals((long)3L, (long)result.returnedCount);
    }

    @Test
    public void testGetAllResources_editorUpdate() throws Exception {
        String CAT0_NAME = "CAT000";
        String RES_NAME = "a MiXeD cAsE sTrInG";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        long a0 = this.restCreateUser("a0", Role.ADMIN, new HashSet<UserGroup>(), "p0");
        long u0 = this.restCreateUser("u0", Role.USER, new HashSet<UserGroup>(), "p0");
        this.createCategory("CAT000");
        long r0Id = this.restCreateResource("a MiXeD cAsE sTrInG", "x", "CAT000", u0, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(u0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)1L, (long)result.total);
        Assert.assertEquals((long)1L, (long)result.returnedCount);
        ShortResource resource = this.restExtJsService.getResource((SecurityContext)sc, r0Id);
        Assert.assertEquals((Object)"a MiXeD cAsE sTrInG", (Object)resource.getName());
        Assert.assertEquals((Object)"u0", (Object)resource.getCreator());
        Assert.assertEquals((Object)"u0", (Object)resource.getEditor());
        sc = new ServiceTestBase.SimpleSecurityContext(a0);
        Resource realResource = resourceService.get(r0Id);
        realResource.setName("new name");
        restResourceService.update((SecurityContext)sc, r0Id, this.createRESTResource(realResource));
        ShortResource resource2 = this.restExtJsService.getResource((SecurityContext)sc, r0Id);
        Assert.assertEquals((Object)realResource.getName(), (Object)resource2.getName());
        Assert.assertEquals((Object)"u0", (Object)resource2.getCreator());
        Assert.assertEquals((Object)"a0", (Object)resource2.getEditor());
    }

    @Test
    public void testGetAllResources_unadvertised() throws Exception {
        String CAT0_NAME = "CAT000";
        String CAT1_NAME = "CAT111";
        String RES_NAME = "a MiXeD cAsE sTrInG";
        Assert.assertEquals((long)0L, (long)resourceService.getAll(null, null, this.buildFakeAdminUser()).size());
        long g0Id = this.createGroup("g0");
        UserGroup g0 = new UserGroup();
        g0.setId(Long.valueOf(g0Id));
        g0.setGroupName("g0");
        HashSet<UserGroup> groups = new HashSet<UserGroup>();
        groups.add(g0);
        long a0 = this.restCreateUser("a0", Role.ADMIN, groups, "p0");
        long u0 = this.restCreateUser("u0", Role.USER, groups, "p0");
        long u1 = this.restCreateUser("u1", Role.USER, groups, "p1");
        this.createCategory("CAT000");
        this.createCategory("CAT111");
        SecurityRule sr0 = new SecurityRule();
        sr0.setUser((User)userDAO.find(Long.valueOf(u0)));
        sr0.setCanRead(true);
        sr0.setCanWrite(true);
        SecurityRule sr1 = new SecurityRule();
        sr1.setGroup(g0);
        sr1.setCanRead(true);
        sr1.setCanWrite(false);
        SecurityRuleList rules = new SecurityRuleList(Arrays.asList(sr0, sr1));
        this.restCreateResource("a MiXeD cAsE sTrInG", "x", "CAT000", u0, rules, true);
        this.restCreateResource("a MiXeD cAsE sTrInG".toLowerCase(), "x", "CAT000", u0, rules, false);
        this.restCreateResource("a MiXeD cAsE sTrInG".toUpperCase(), "x", "CAT000", u0, rules, true);
        this.restCreateResource("a MiXeD cAsE sTrInG in another category", "x", "CAT111", u0, rules, false);
        this.restCreateResource("just an extra resource we shouldn't care about", "x", "CAT000", u0, rules, true);
        ServiceTestBase.SimpleSecurityContext sc = new ServiceTestBase.SimpleSecurityContext(a0);
        String response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        JSONResult result = this.parse(response);
        Assert.assertEquals((long)4L, (long)result.total);
        Assert.assertEquals((long)4L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)4L, (long)result.total);
        Assert.assertEquals((long)4L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getAllResources((SecurityContext)sc, "*mIxEd*", Integer.valueOf(0), Integer.valueOf(1000));
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)2L, (long)result.total);
        Assert.assertEquals((long)2L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u0);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT000", "*mIxEd*", null, Integer.valueOf(0), Integer.valueOf(1000), false, false);
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)3L, (long)result.total);
        Assert.assertEquals((long)3L, (long)result.returnedCount);
        sc = new ServiceTestBase.SimpleSecurityContext(u1);
        response = this.restExtJsService.getResourcesByCategory((SecurityContext)sc, "CAT000", "*mIxEd*", null, Integer.valueOf(0), Integer.valueOf(1000), false, false);
        System.out.println("JSON " + response);
        result = this.parse(response);
        Assert.assertEquals((long)2L, (long)result.total);
        Assert.assertEquals((long)2L, (long)result.returnedCount);
    }

    private JSONResult parse(String jsonString) {
        Set names;
        JSONResult ret = new JSONResult();
        JSON json = JSONSerializer.toJSON((Object)jsonString);
        JSONObject jo = (JSONObject)json;
        ret.total = jo.getInt("totalCount");
        JSONArray arrResults = jo.optJSONArray("results");
        if (arrResults != null) {
            names = this.getArray(arrResults);
        } else {
            JSONObject results = jo.optJSONObject("results");
            if (results != null) {
                names = Collections.singleton(this.getSingle(results));
            } else {
                this.LOGGER.warn("No results found");
                names = Collections.EMPTY_SET;
            }
        }
        ret.names = names;
        ret.returnedCount = names.size();
        return ret;
    }

    Set<String> getArray(JSONArray arr) {
        HashSet<String> ret = new HashSet<String>();
        for (Object object : arr) {
            ret.add(this.getSingle((JSONObject)object));
        }
        return ret;
    }

    String getSingle(JSONObject jo) {
        return jo.getString("name");
    }

    static class JSONResult {
        int total;
        int returnedCount;
        Set names;

        JSONResult() {
        }
    }
}

