/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.rest.AdministratorGeoStoreClient;
import it.geosolutions.geostore.services.rest.GeoStoreClient;
import it.geosolutions.geostore.services.rest.model.CategoryList;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.RESTStoredData;
import it.geosolutions.geostore.services.rest.model.RESTUser;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import it.geosolutions.geostore.services.rest.model.UserList;
import java.net.ConnectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class BaseGeoStoreClientTest {
    private static final Logger LOGGER = LogManager.getLogger(BaseGeoStoreClientTest.class);
    protected static final String GEOSTORE_REST_URL = "http://localhost:9191/geostore/rest";
    protected GeoStoreClient client;
    protected AdministratorGeoStoreClient adminClient;

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    @Before
    public void before() throws Exception {
        this.client = this.createClient("admin", "admin");
        this.adminClient = this.createAdminClient();
        Assume.assumeTrue((boolean)this.pingGeoStore(this.client));
        this.removeAllResources(this.client);
        this.removeAllCategories(this.client);
        this.removeAllGroups();
        this.removeAllUsers();
    }

    protected GeoStoreClient createClient(String u, String p) {
        GeoStoreClient client = new GeoStoreClient();
        client.setGeostoreRestUrl(GEOSTORE_REST_URL);
        client.setUsername(u);
        client.setPassword(p);
        return client;
    }

    protected AdministratorGeoStoreClient createAdminClient() {
        AdministratorGeoStoreClient client = new AdministratorGeoStoreClient();
        client.setGeostoreRestUrl(GEOSTORE_REST_URL);
        client.setUsername("admin");
        client.setPassword("admin");
        return client;
    }

    protected RESTResource createSampleResource(Long catId) {
        String timeid = Long.toString(System.currentTimeMillis());
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData("test stored data #" + timeid);
        ArrayList<ShortAttribute> attrList = new ArrayList<ShortAttribute>();
        attrList.add(new ShortAttribute("stringAtt", "attVal" + timeid, DataType.STRING));
        attrList.add(ShortAttribute.createDateAttribute((String)"dateAtt", (Date)new Date()));
        attrList.add(new ShortAttribute("longAtt", timeid, DataType.NUMBER));
        RESTResource resource = new RESTResource();
        resource.setCategory(new RESTCategory(catId));
        resource.setName("rest_test_resource_" + timeid);
        resource.setStore(storedData);
        resource.setAttribute(attrList);
        return resource;
    }

    protected void removeAllResources(GeoStoreClient client) {
        FieldFilter filter = new FieldFilter(BaseField.NAME, "*", SearchOperator.IS_NOT_NULL);
        ShortResourceList resources = client.searchResources((SearchFilter)filter);
        if (resources.getList() != null) {
            LOGGER.info("Found " + resources.getList().size() + " resources");
            for (ShortResource shortResource : resources.getList()) {
                LOGGER.info("Found resource " + String.valueOf(shortResource) + " . Deleting...");
                client.deleteResource(Long.valueOf(shortResource.getId()));
            }
        } else {
            LOGGER.info("No resource found");
        }
        resources = client.searchResources((SearchFilter)filter);
        Assert.assertNull((String)"Not all resources have been deleted", (Object)resources.getList());
    }

    protected void removeAllCategories(GeoStoreClient client) {
        CategoryList categories = client.getCategories();
        if (categories.getList() != null) {
            LOGGER.info("Found " + categories.getList().size() + " categories");
            for (Category category : categories.getList()) {
                LOGGER.info("Found category " + String.valueOf(category) + " . Deleting...");
                client.deleteCategory(category.getId());
            }
        } else {
            LOGGER.info("No category found");
        }
        categories = client.getCategories();
        Assert.assertNull((String)"Not all categories have been deleted", (Object)categories.getList());
    }

    protected void removeAllGroups() {
        UserGroupList userGroups = this.adminClient.getUserGroups(Integer.valueOf(0), Integer.valueOf(1000), false);
        for (RESTUserGroup group : userGroups) {
            LOGGER.info("Found userGroup " + String.valueOf(group) + " . Deleting...");
            this.adminClient.deleteUserGroup(group.getId().longValue());
        }
    }

    protected void removeAllUsers() {
        UserList users = this.adminClient.getUsers();
        for (RESTUser user : users) {
            LOGGER.info("Found user " + String.valueOf(user) + " . Deleting...");
            if (user.getName().equals("admin")) {
                LOGGER.info("Skipping main admin");
                continue;
            }
            this.adminClient.deleteUser(user.getId());
        }
    }

    protected boolean pingGeoStore(GeoStoreClient client) {
        try {
            client.getCategories();
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug("Error connecting to GeoStore", (Throwable)ex);
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (!(t instanceof ConnectException)) continue;
                LOGGER.warn("Testing GeoStore is offline");
                return false;
            }
            throw new RuntimeException("Unexpected exception: " + ex.getMessage(), ex);
        }
    }

    protected long createUser(String name, Role role, String pw, UserGroup ... group) {
        User user = new User();
        user.setName(name);
        user.setRole(role);
        user.setNewPassword(pw);
        if (group != null) {
            user.setGroups(new HashSet<UserGroup>(Arrays.asList(group)));
        }
        return this.adminClient.insert(user);
    }

    protected UserGroup createUserGroup(String name) {
        UserGroup g1 = new UserGroup();
        g1.setGroupName(name);
        long id = this.adminClient.insertUserGroup(g1);
        g1.setId(Long.valueOf(id));
        return g1;
    }
}

