/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.services.rest.GeoStoreClient;
import it.geosolutions.geostore.services.rest.model.RESTUserGroup;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.UserGroupList;
import it.geosolutions.geostore.services.rest.model.UserList;
import javax.ws.rs.core.MultivaluedMap;

public class AdministratorGeoStoreClient
extends GeoStoreClient {
    public User getUser(long id) {
        return (User)this.getBaseWebResource("users", "user", id).accept(new String[]{"text/xml"}).get(User.class);
    }

    public User getUser(String name) {
        return (User)this.getBaseWebResource("users", "search", name).accept(new String[]{"text/xml"}).get(User.class);
    }

    public User getUser(long id, Boolean includeAttributes) {
        WebResource wr = this.getBaseWebResource("users", "user", id);
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        if (includeAttributes != null) {
            queryParams.add((Object)"includeattributes", (Object)includeAttributes.toString());
        }
        return (User)wr.queryParams((MultivaluedMap)queryParams).get(User.class);
    }

    public UserList getUsers() {
        return (UserList)((WebResource.Builder)this.getBaseWebResource("users").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(UserList.class);
    }

    public UserList getUsers(Integer page, Integer entries) {
        WebResource wr = this.getBaseWebResource("users");
        return (UserList)((WebResource.Builder)wr.queryParam("page", page.toString()).queryParam("entries", entries.toString()).header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(UserList.class);
    }

    public User getUserDetails() {
        return (User)this.getBaseWebResource("users", "user", "details").get(User.class);
    }

    public Long insert(User user) {
        String sid = (String)((WebResource.Builder)this.getBaseWebResource("users").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/plain"})).post(String.class, (Object)user);
        return Long.parseLong(sid);
    }

    public void deleteUser(Long id) {
        this.getBaseWebResource("users", "user", id).delete();
    }

    public void update(Long id, User user) {
        this.getBaseWebResource("users", "user", id).header("Content-Type", (Object)"text/xml").put((Object)user);
    }

    public long insertUserGroup(UserGroup usergroup) {
        String sid = (String)((WebResource.Builder)this.getBaseWebResource("usergroups").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/plain"})).post(String.class, (Object)usergroup);
        return Long.parseLong(sid);
    }

    public void deleteUserGroup(long usergroupId) {
        this.getBaseWebResource("usergroups", "group", usergroupId).delete();
    }

    public void assignUserGroup(long userId, long usergroupId) {
        this.getBaseWebResource("usergroups", "group", userId, usergroupId).post();
    }

    public void deassignUserGroup(long userId, long usergroupId) {
        this.getBaseWebResource("usergroups", "group", userId, usergroupId).delete();
    }

    public RESTUserGroup getUserGroup(long usergroupId) {
        return (RESTUserGroup)this.getBaseWebResource("usergroups", "group", usergroupId).get(RESTUserGroup.class);
    }

    public UserGroupList getUserGroups(Integer page, Integer entries, boolean all) {
        WebResource wr = this.getBaseWebResource("usergroups");
        wr = wr.queryParam("page", page.toString());
        wr = wr.queryParam("entries", entries.toString());
        wr = wr.queryParam("all", "" + all);
        return (UserGroupList)((WebResource.Builder)wr.header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(UserGroupList.class);
    }

    public ShortResourceList updateSecurityRules(ShortResourceList resourcesToSet, Long groupId, boolean canRead, boolean canWrite) {
        WebResource wr = this.getBaseWebResource("usergroups", "update_security_rules", groupId, canRead, canWrite);
        ShortResourceList updatedResources = (ShortResourceList)((WebResource.Builder)wr.header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).put(ShortResourceList.class, (Object)resourcesToSet);
        return updatedResources;
    }

    public RESTUserGroup getUserGroup(String name) {
        return (RESTUserGroup)this.getBaseWebResource("usergroups", "group", "name", name).get(RESTUserGroup.class);
    }
}

