/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.rest.AdministratorGeoStoreClient;
import it.geosolutions.geostore.services.rest.GeoStoreClient;
import java.net.ConnectException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

public class AutoCreateUsersTest {
    private static final Logger LOGGER = LogManager.getLogger(AutoCreateUsersTest.class);
    AdministratorGeoStoreClient geoStoreClient;
    final String DEFAULTCATEGORYNAME = "TestCategory1";

    protected AdministratorGeoStoreClient createAdministratorClient() {
        this.geoStoreClient = new AdministratorGeoStoreClient();
        this.geoStoreClient.setGeostoreRestUrl("http://localhost:9191/geostore/rest");
        this.geoStoreClient.setUsername("admin");
        this.geoStoreClient.setPassword("admin");
        return this.geoStoreClient;
    }

    protected boolean pingGeoStore(GeoStoreClient client) {
        try {
            client.getCategories();
            return true;
        }
        catch (Exception ex) {
            LOGGER.debug("Error connecting to GeoStore", (Throwable)ex);
            for (Throwable t = ex; t != null; t = t.getCause()) {
                if (!(t instanceof ConnectException)) continue;
                LOGGER.warn("Testing GeoStore is offline");
                return false;
            }
            throw new RuntimeException("Unexpected exception: " + ex.getMessage(), ex);
        }
    }

    @Before
    public void before() throws Exception {
        this.geoStoreClient = this.createAdministratorClient();
        Assume.assumeTrue((boolean)this.pingGeoStore((GeoStoreClient)this.geoStoreClient));
    }

    @Test
    @Ignore(value="Ignore this test until the user autocreation won't be restored")
    public void testAutoCreateUsers() {
        this.geoStoreClient.setUsername("test");
        this.geoStoreClient.setPassword("");
        try {
            User user = this.geoStoreClient.getUserDetails();
            Assert.assertNotNull((Object)user);
            Assert.assertTrue((user.getPassword() == null || user.getPassword().equals("") ? 1 : 0) != 0);
        }
        catch (Exception e) {
            Assert.fail((String)"Unable to create user");
        }
    }
}

