/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import it.geosolutions.geostore.core.model.Category;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.rest.client.model.ExtGroupList;
import it.geosolutions.geostore.services.rest.model.CategoryList;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.ResourceList;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.enums.RawFormat;
import javax.ws.rs.core.MediaType;

public class GeoStoreClient {
    private String username = null;
    private String password = null;
    private String geostoreRestUrl = null;

    @Deprecated
    public ShortResourceList searchResources(SearchFilter searchFilter) {
        ShortResourceList resourceList = (ShortResourceList)((WebResource.Builder)this.getBaseWebResource("resources", "search").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).post(ShortResourceList.class, (Object)searchFilter);
        return resourceList;
    }

    public ResourceList searchResources(SearchFilter searchFilter, Integer page, Integer entries, Boolean includeAttributes, Boolean includeData) {
        WebResource wb = this.getBaseWebResource("resources", "search", "list");
        wb = this.addQParam(wb, "page", page);
        wb = this.addQParam(wb, "entries", entries);
        wb = this.addQParam(wb, "includeAttributes", includeAttributes);
        wb = this.addQParam(wb, "includeData", includeData);
        return (ResourceList)((WebResource.Builder)wb.header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).post(ResourceList.class, (Object)searchFilter);
    }

    protected WebResource addQParam(WebResource wb, String key, Object value) {
        if (value != null) {
            return wb.queryParam(key, value.toString());
        }
        return wb;
    }

    public Long insert(RESTResource resource) {
        String sid = (String)((WebResource.Builder)this.getBaseWebResource("resources").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/plain"})).post(String.class, (Object)resource);
        return Long.parseLong(sid);
    }

    public Resource getResource(Long id, boolean full) {
        WebResource resource = this.getBaseWebResource("resources", "resource", id);
        if (full) {
            resource = resource.queryParam("full", Boolean.toString(full));
        }
        return (Resource)((WebResource.Builder)resource.header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(Resource.class);
    }

    public Resource getResource(Long id) {
        return this.getResource(id, false);
    }

    public void deleteResource(Long id) {
        this.getBaseWebResource("resources", "resource", id).delete();
    }

    public void updateResource(Long id, RESTResource resource) {
        this.getBaseWebResource("resources", "resource", id).header("Content-Type", (Object)"text/xml").put((Object)resource);
    }

    public ShortResourceList getAllShortResource(Integer page, Integer entries) {
        WebResource wr = this.getBaseWebResource("resources");
        return (ShortResourceList)((WebResource.Builder)wr.queryParam("page", page.toString()).queryParam("entries", entries.toString()).header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(ShortResourceList.class);
    }

    public SecurityRuleList getSecurityRules(Long resourceId) {
        WebResource wr = this.getBaseWebResource("resources", "resource", resourceId, "permissions");
        return (SecurityRuleList)((WebResource.Builder)wr.header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(SecurityRuleList.class);
    }

    public void updateSecurityRules(Long resourceId, SecurityRuleList rules) {
        ((WebResource.Builder)this.getBaseWebResource("resources", "resource", resourceId, "permissions").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/plain"})).post((Object)rules);
    }

    public String getData(Long id) {
        return this.getData(id, MediaType.WILDCARD_TYPE);
    }

    public String getData(Long id, MediaType acceptMediaType) {
        return (String)this.getBaseWebResource("data", id).accept(new MediaType[]{acceptMediaType}).get(String.class);
    }

    public byte[] getRawData(Long id, RawFormat decodeFrom) {
        return this.getRawData(byte[].class, id, decodeFrom);
    }

    public <T> T getRawData(Class<T> clazz, Long id, RawFormat decodeFrom) {
        WebResource wr = this.getBaseWebResource("data", id, "raw");
        if (decodeFrom != null) {
            wr = wr.queryParam("decode", decodeFrom.name());
        }
        return (T)wr.get(clazz);
    }

    public void setData(Long id, String data) {
        this.getBaseWebResource("data", id).put((Object)data);
    }

    public void updateData(Long id, String data) {
        this.getBaseWebResource("data", id).header("Content-Type", (Object)"text/plain").put((Object)data);
    }

    public Long insert(RESTCategory category) {
        String sid = (String)((WebResource.Builder)this.getBaseWebResource("categories").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/plain"})).post(String.class, (Object)category);
        return Long.parseLong(sid);
    }

    public Category getCategory(Long id) {
        Category category = (Category)((WebResource.Builder)this.getBaseWebResource("categories", "category", id).header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(Category.class);
        return category;
    }

    public Long getCategoryCount(String nameLike) {
        String count = (String)this.getBaseWebResource("categories", "count", nameLike).accept(new String[]{"text/plain"}).get(String.class);
        return Long.parseLong(count);
    }

    public CategoryList getCategories(Integer page, Integer entries) {
        return (CategoryList)((WebResource.Builder)this.getBaseWebResource("categories").queryParam("page", page.toString()).queryParam("entries", entries.toString()).header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(CategoryList.class);
    }

    public CategoryList getCategories() {
        return (CategoryList)((WebResource.Builder)this.getBaseWebResource("categories").header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(CategoryList.class);
    }

    public void deleteCategory(Long id) {
        this.getBaseWebResource("categories", "category", id).delete();
    }

    public ExtGroupList searchUserGroup(Integer start, Integer limit, String nameLike, boolean all) {
        WebResource wr = this.getBaseWebResource("extjs", "search", "groups", nameLike);
        wr = wr.queryParam("start", start.toString()).queryParam("limit", limit.toString()).queryParam("all", Boolean.toString(all));
        return (ExtGroupList)((WebResource.Builder)wr.header("Content-Type", (Object)"text/xml").accept(new String[]{"text/xml"})).get(ExtGroupList.class);
    }

    public ExtGroupList searchUserGroup(Integer start, Integer limit, String nameLike) {
        return this.searchUserGroup(start, limit, nameLike, false);
    }

    public ShortResource getShortResource(long id) {
        WebResource wr = this.getBaseWebResource("extjs", "resource", id);
        return (ShortResource)wr.get(ShortResource.class);
    }

    protected WebResource getBaseWebResource() {
        if (this.geostoreRestUrl == null) {
            throw new IllegalStateException("GeoStore URL not set");
        }
        Client c = Client.create();
        if (this.username != null || this.password != null) {
            c.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username != null ? this.username : "", this.password != null ? this.password : ""));
        }
        WebResource wr = c.resource(this.geostoreRestUrl);
        return wr;
    }

    protected WebResource getBaseWebResource(Object ... path) {
        if (this.geostoreRestUrl == null) {
            throw new IllegalStateException("GeoStore URL not set");
        }
        Client c = Client.create();
        if (this.username != null || this.password != null) {
            c.addFilter((ClientFilter)new HTTPBasicAuthFilter(this.username != null ? this.username : "", this.password != null ? this.password : ""));
        }
        StringBuilder fullpath = new StringBuilder(this.geostoreRestUrl);
        for (Object o : path) {
            String p = o.toString();
            if (fullpath.charAt(fullpath.length() - 1) != '/') {
                fullpath.append('/');
            }
            fullpath.append(p);
        }
        WebResource wr = c.resource(fullpath.toString());
        return wr;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getGeostoreRestUrl() {
        return this.geostoreRestUrl;
    }

    public void setGeostoreRestUrl(String geostoreRestUrl) {
        this.geostoreRestUrl = geostoreRestUrl;
    }
}

