/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.security;

import com.sun.jersey.api.client.ClientHandlerException;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.services.rest.AdministratorGeoStoreClient;
import java.util.ArrayList;
import java.util.List;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class GeoStoreAuthenticationProvider
implements AuthenticationProvider {
    String geoStoreRestURL;
    List<String> allowedRoles;
    public static final String UNAUTHORIZED_MSG = "This user have not enougth permissions to access to the Admin GUI";
    public static final String USER_NOT_FOUND_MSG = "User not found. Please check your credentials";
    public static final String GEOSTORE_UNAVAILABLE = "GeoStore it's not availabile. Please contact with the administrator";

    public boolean supports(Class<? extends Object> authentication) {
        return authentication.equals(UsernamePasswordAuthenticationToken.class);
    }

    public Authentication authenticate(Authentication authentication) {
        String pw = (String)authentication.getCredentials();
        String us = (String)authentication.getPrincipal();
        AdministratorGeoStoreClient geoStoreClient = new AdministratorGeoStoreClient();
        geoStoreClient.setUsername(us);
        geoStoreClient.setPassword(pw);
        geoStoreClient.setGeostoreRestUrl(this.geoStoreRestURL);
        User user = null;
        try {
            user = geoStoreClient.getUserDetails();
        }
        catch (ClientHandlerException che) {
            throw new UsernameNotFoundException(GEOSTORE_UNAVAILABLE);
        }
        catch (Exception e) {
            user = null;
        }
        if (user != null) {
            String role = user.getRole().toString();
            if (!this.roleAllowed(role)) {
                throw new BadCredentialsException(UNAUTHORIZED_MSG);
            }
            ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
            authorities.add(new SimpleGrantedAuthority("ROLE_" + role));
            UsernamePasswordAuthenticationToken a = new UsernamePasswordAuthenticationToken((Object)us, (Object)pw, authorities);
            return a;
        }
        throw new UsernameNotFoundException(USER_NOT_FOUND_MSG);
    }

    private boolean roleAllowed(String role) {
        for (String allowed : this.allowedRoles) {
            if (allowed == null || !allowed.equals(role)) continue;
            return true;
        }
        return false;
    }

    public List<String> getAllowedRoles() {
        return this.allowedRoles;
    }

    public void setAllowedRoles(List<String> roleFilter) {
        this.allowedRoles = roleFilter;
    }

    public String getGeoStoreRestURL() {
        return this.geoStoreRestURL;
    }

    public void setGeoStoreRestURL(String geoStoreRestURL) {
        this.geoStoreRestURL = geoStoreRestURL;
    }
}

