/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import it.geosolutions.geostore.core.model.Attribute;
import it.geosolutions.geostore.core.model.Resource;
import it.geosolutions.geostore.core.model.SecurityRule;
import it.geosolutions.geostore.core.model.User;
import it.geosolutions.geostore.core.model.UserGroup;
import it.geosolutions.geostore.core.model.enums.DataType;
import it.geosolutions.geostore.core.model.enums.Role;
import it.geosolutions.geostore.services.dto.ShortAttribute;
import it.geosolutions.geostore.services.dto.ShortResource;
import it.geosolutions.geostore.services.dto.search.BaseField;
import it.geosolutions.geostore.services.dto.search.CategoryFilter;
import it.geosolutions.geostore.services.dto.search.FieldFilter;
import it.geosolutions.geostore.services.dto.search.SearchFilter;
import it.geosolutions.geostore.services.dto.search.SearchOperator;
import it.geosolutions.geostore.services.rest.BaseGeoStoreClientTest;
import it.geosolutions.geostore.services.rest.GeoStoreClient;
import it.geosolutions.geostore.services.rest.model.RESTCategory;
import it.geosolutions.geostore.services.rest.model.RESTResource;
import it.geosolutions.geostore.services.rest.model.RESTStoredData;
import it.geosolutions.geostore.services.rest.model.ResourceList;
import it.geosolutions.geostore.services.rest.model.SecurityRuleList;
import it.geosolutions.geostore.services.rest.model.ShortResourceList;
import it.geosolutions.geostore.services.rest.model.enums.RawFormat;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.cxf.helpers.IOUtils;
import org.apache.log4j.Logger;
import org.junit.Assert;
import org.junit.Test;

public class GeoStoreClientTest
extends BaseGeoStoreClientTest {
    private static final Logger LOGGER = Logger.getLogger(GeoStoreClientTest.class);
    final String DEFAULTCATEGORYNAME = "TestCategory1";

    @Test
    public void testRemoveAllAttribs() {
        String KEY_STRING = "stringAtt";
        Date origDate = new Date();
        String origString = "OrigStringValue";
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData("we wish you a merry xmas and a happy new year");
        ArrayList<ShortAttribute> attrList = new ArrayList<ShortAttribute>();
        attrList.add(new ShortAttribute("stringAtt", "OrigStringValue", DataType.STRING));
        String timeid = Long.toString(System.currentTimeMillis());
        this.createDefaultCategory();
        RESTResource origResource = new RESTResource();
        origResource.setCategory(new RESTCategory("TestCategory1"));
        origResource.setName("rest_test_resource_" + timeid);
        origResource.setStore(storedData);
        origResource.setAttribute(attrList);
        Long rid = this.client.insert(origResource);
        System.out.println("RESOURCE has ID " + rid);
        Resource loaded = this.client.getResource(rid);
        System.out.println("RESOURCE: " + loaded);
        List loadedAttrs = loaded.getAttribute();
        Assert.assertEquals((long)1L, (long)loadedAttrs.size());
        origResource.setAttribute(null);
        this.client.updateResource(rid, origResource);
        loaded = this.client.getResource(rid);
        System.out.println("RESOURCE: " + loaded);
        loadedAttrs = loaded.getAttribute();
        Assert.assertEquals((long)1L, (long)loadedAttrs.size());
        origResource.setAttribute(new ArrayList());
        Assert.assertTrue((boolean)origResource.getAttribute().isEmpty());
        this.client.updateResource(rid, origResource);
        loaded = this.client.getResource(rid);
        System.out.println("RESOURCE: " + loaded);
        loadedAttrs = loaded.getAttribute();
        Assert.assertEquals((long)0L, (long)loadedAttrs.size());
    }

    @Test
    public void testInsertResource() {
        Attribute datt;
        Attribute satt;
        String KEY_STRING = "stringAtt";
        String KEY_DATE = "dateAtt";
        Date origDate = new Date();
        String origString = "OrigStringValue";
        this.createDefaultCategory();
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData("we wish you a merry xmas and a happy new year");
        ArrayList<ShortAttribute> attrList = new ArrayList<ShortAttribute>();
        attrList.add(new ShortAttribute("stringAtt", "OrigStringValue", DataType.STRING));
        attrList.add(ShortAttribute.createDateAttribute((String)"dateAtt", (Date)origDate));
        String timeid = Long.toString(System.currentTimeMillis());
        RESTResource origResource = new RESTResource();
        origResource.setCategory(new RESTCategory("TestCategory1"));
        origResource.setName("rest_test_resource_" + timeid);
        origResource.setStore(storedData);
        origResource.setAttribute(attrList);
        Long rid = this.client.insert(origResource);
        System.out.println("RESOURCE has ID " + rid);
        Resource loaded = this.client.getResource(rid);
        System.out.println("RESOURCE: " + loaded);
        List loadedAttrs = loaded.getAttribute();
        Assert.assertEquals((long)2L, (long)loadedAttrs.size());
        if (((Attribute)loadedAttrs.get(0)).getType() == DataType.STRING) {
            satt = (Attribute)loadedAttrs.get(0);
            datt = (Attribute)loadedAttrs.get(1);
        } else {
            datt = (Attribute)loadedAttrs.get(0);
            satt = (Attribute)loadedAttrs.get(1);
        }
        Assert.assertEquals((Object)DataType.STRING, (Object)satt.getType());
        Assert.assertEquals((Object)"stringAtt", (Object)satt.getName());
        Assert.assertEquals((Object)"OrigStringValue", (Object)satt.getTextValue());
        Assert.assertEquals((Object)DataType.DATE, (Object)datt.getType());
        Assert.assertEquals((Object)"dateAtt", (Object)datt.getName());
        Assert.assertEquals((Object)origDate, (Object)datt.getDateValue());
        FieldFilter searchFilter = new FieldFilter(BaseField.NAME, "%" + timeid, SearchOperator.LIKE);
        ShortResourceList rlist = this.client.searchResources((SearchFilter)searchFilter);
        Assert.assertNotNull((Object)rlist);
        Assert.assertEquals((long)1L, (long)rlist.getList().size());
        Assert.assertEquals((Object)rid, (Object)((ShortResource)rlist.getList().get(0)).getId());
    }

    @Test
    public void testUpdateResource() {
        String KEY_STRING = "stringAtt";
        String KEY_DATE = "dateAtt";
        Date origDate = new Date();
        String origString = "OrigStringValue";
        this.createDefaultCategory();
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData("we wish you a merry xmas and a happy new year");
        ArrayList<ShortAttribute> attrList = new ArrayList<ShortAttribute>();
        attrList.add(new ShortAttribute("string1", "value1", DataType.STRING));
        attrList.add(new ShortAttribute("string2", "value2", DataType.STRING));
        attrList.add(new ShortAttribute("string3", "value3", DataType.STRING));
        String timeid = Long.toString(System.currentTimeMillis());
        RESTResource origResource = new RESTResource();
        origResource.setCategory(new RESTCategory("TestCategory1"));
        origResource.setName("rest_test_resource_" + timeid);
        origResource.setStore(storedData);
        origResource.setAttribute(attrList);
        Long rid = this.client.insert(origResource);
        System.out.println("RESOURCE has ID " + rid);
        String name1 = "rest_test_resource_" + Long.toString(System.currentTimeMillis());
        RESTResource updResource = new RESTResource();
        updResource.setName(name1);
        ArrayList<ShortAttribute> attrList2 = new ArrayList<ShortAttribute>();
        attrList2.add(new ShortAttribute("string1", "value1", DataType.STRING));
        attrList2.add(new ShortAttribute("string2", "value2.2", DataType.STRING));
        attrList2.add(new ShortAttribute("string4", "value4", DataType.STRING));
        updResource.setAttribute(attrList2);
        this.client.updateResource(rid, updResource);
        Resource loaded = this.client.getResource(rid);
        System.out.println("RESOURCE: " + loaded);
        List loadedAttrs = loaded.getAttribute();
        Assert.assertEquals((long)3L, (long)loadedAttrs.size());
        HashMap<String, String> attMap = new HashMap<String, String>();
        for (Attribute attribute : loadedAttrs) {
            attMap.put(attribute.getName(), attribute.getTextValue());
        }
        Assert.assertEquals((Object)"value1", attMap.get("string1"));
        Assert.assertEquals((Object)"value2.2", attMap.get("string2"));
        Assert.assertEquals((Object)"value4", attMap.get("string4"));
        RESTResource res = new RESTResource();
        res.setCategory(new RESTCategory("TestCategory2"));
        try {
            this.client.updateResource(rid, res);
            Assert.fail((String)"Undetected error");
        }
        catch (UniformInterfaceException e) {
            String response = "COULD NOT READ RESPONSE";
            try {
                response = IOUtils.toString((InputStream)e.getResponse().getEntityInputStream());
            }
            catch (Exception e2) {
                LOGGER.warn((Object)("Error reading response: " + e2.getMessage()));
            }
            LOGGER.info((Object)("Error condition successfully detected: " + response));
        }
        catch (Exception e) {
            LOGGER.info((Object)("Error condition successfully detected:" + e.getMessage()), (Throwable)e);
        }
        this.client.deleteResource(rid);
    }

    @Test
    public void testSearchByCategory() {
        this.createDefaultCategory();
        RESTResource res = new RESTResource();
        res.setCategory(new RESTCategory("TestCategory1"));
        String timeid = Long.toString(System.currentTimeMillis());
        res.setName("rest_test_resource_" + timeid);
        Long id = this.client.insert(res);
        CategoryFilter filter = new CategoryFilter("TestCategory1", SearchOperator.EQUAL_TO);
        ShortResourceList resources = this.client.searchResources((SearchFilter)filter);
        Assert.assertEquals((long)1L, (long)resources.getList().size());
    }

    @Test
    public void testClearAll() {
        Long catId1 = this.client.insert(new RESTCategory("Test Category#1"));
        Long catId2 = this.client.insert(new RESTCategory("Test Category#2"));
        Assert.assertEquals((long)2L, (long)this.client.getCategories().getList().size());
        this.client.insert(this.createSampleResource(catId1));
        this.client.insert(this.createSampleResource(catId2));
        this.client.insert(this.createSampleResource(catId2));
        FieldFilter filter = new FieldFilter(BaseField.NAME, "*", SearchOperator.IS_NOT_NULL);
        ShortResourceList resources = this.client.searchResources((SearchFilter)filter);
        Assert.assertEquals((long)3L, (long)resources.getList().size());
    }

    @Test
    public void testGetResourceFull() {
        this.createDefaultCategory();
        String DATA = "we wish you a merry xmas and a happy new year";
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData("we wish you a merry xmas and a happy new year");
        RESTResource origResource = new RESTResource();
        origResource.setCategory(new RESTCategory("TestCategory1"));
        origResource.setName("rest_test_resource_getFull");
        origResource.setStore(storedData);
        Long rid = this.client.insert(origResource);
        System.out.println("RESOURCE has ID " + rid);
        String data = this.client.getData(rid);
        Assert.assertEquals((Object)"we wish you a merry xmas and a happy new year", (Object)data);
        Resource loaded = this.client.getResource(rid);
        System.out.println("RESOURCE: " + loaded);
        Assert.assertNull((Object)loaded.getData());
        loaded = this.client.getResource(rid, true);
        System.out.println("RESOURCE: " + loaded);
        Assert.assertNotNull((Object)loaded.getData());
    }

    @Test
    public void testGetDataRawBase64() {
        this.createDefaultCategory();
        String DATA = "we wish you a merry xmas and a happy new year";
        String ENCODED = Base64.encodeBase64String((byte[])"we wish you a merry xmas and a happy new year".getBytes());
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData(ENCODED);
        RESTResource origResource = new RESTResource();
        origResource.setCategory(new RESTCategory("TestCategory1"));
        origResource.setName("rest_test_getrawdata");
        origResource.setStore(storedData);
        Long rid = this.client.insert(origResource);
        LOGGER.info((Object)("RESOURCE has ID " + rid));
        LOGGER.info((Object)"RAW data: base check");
        Object encoded = this.client.getData(rid);
        Assert.assertEquals((Object)ENCODED, (Object)encoded);
        LOGGER.info((Object)"RAW data: no decoding");
        encoded = this.client.getRawData(rid, null);
        Assert.assertArrayEquals((byte[])ENCODED.getBytes(), (byte[])encoded);
        LOGGER.info((Object)"RAW data: base64");
        byte[] decoded = this.client.getRawData(rid, RawFormat.BASE64);
        Assert.assertArrayEquals((byte[])"we wish you a merry xmas and a happy new year".getBytes(), (byte[])decoded);
    }

    @Test
    public void testGetDataRawDataURI() {
        this.createDefaultCategory();
        String DATA = "we wish you a merry xmas and a happy new year";
        String ENCODED_DATA = Base64.encodeBase64String((byte[])"we wish you a merry xmas and a happy new year".getBytes());
        String MEDIATYPE = "test/custom";
        String DATAURIHEADER = "data:test/custom;base64,";
        String FULL_DATA = "data:test/custom;base64," + ENCODED_DATA;
        RESTStoredData storedData = new RESTStoredData();
        storedData.setData(FULL_DATA);
        RESTResource origResource = new RESTResource();
        origResource.setCategory(new RESTCategory("TestCategory1"));
        origResource.setName("rest_test_rawdatauri");
        origResource.setStore(storedData);
        Long rid = this.client.insert(origResource);
        LOGGER.info((Object)("RESOURCE has ID " + rid));
        LOGGER.info((Object)"RAW data: base check");
        String encoded = this.client.getData(rid);
        Assert.assertEquals((Object)FULL_DATA, (Object)encoded);
        LOGGER.info((Object)"RAW data: data URI");
        byte[] decoded = this.client.getRawData(rid, RawFormat.DATAURI);
        Assert.assertArrayEquals((byte[])"we wish you a merry xmas and a happy new year".getBytes(), (byte[])decoded);
        LOGGER.info((Object)"RAW data: test content type");
        ClientResponse response = (ClientResponse)this.client.getRawData(ClientResponse.class, rid, RawFormat.DATAURI);
        byte[] decoded2 = (byte[])response.getEntity(byte[].class);
        Assert.assertEquals((long)200L, (long)response.getStatus());
        Assert.assertArrayEquals((byte[])"we wish you a merry xmas and a happy new year".getBytes(), (byte[])decoded2);
        List contenttypes = (List)response.getHeaders().get((Object)"Content-Type");
        Assert.assertTrue((boolean)contenttypes.contains("test/custom"));
    }

    @Test
    public void testSearch01() {
        this.createDefaultCategory();
        RESTResource res = new RESTResource();
        res.setCategory(new RESTCategory("TestCategory1"));
        res.setName("rest_test_resource_1");
        res.setAttribute(new ArrayList());
        res.getAttribute().add(new ShortAttribute("name1", "value1", DataType.STRING));
        res.getAttribute().add(new ShortAttribute("name2", "value2", DataType.STRING));
        res.setData("pippo");
        Long id = this.client.insert(res);
        Assert.assertNotNull((Object)id);
        CategoryFilter filter = new CategoryFilter("TestCategory1", SearchOperator.EQUAL_TO);
        ResourceList resources = this.client.searchResources((SearchFilter)filter, null, null, Boolean.valueOf(false), Boolean.valueOf(false));
        Assert.assertEquals((long)1L, (long)resources.getList().size());
        Assert.assertNull((Object)((Resource)resources.getList().get(0)).getAttribute());
        Assert.assertNull((Object)((Resource)resources.getList().get(0)).getData());
        resources = this.client.searchResources((SearchFilter)filter, null, null, Boolean.valueOf(true), Boolean.valueOf(false));
        Assert.assertEquals((long)1L, (long)resources.getList().size());
        Assert.assertNotNull((Object)((Resource)resources.getList().get(0)).getAttribute());
        Assert.assertEquals((long)2L, (long)((Resource)resources.getList().get(0)).getAttribute().size());
        Assert.assertNull((Object)((Resource)resources.getList().get(0)).getData());
        resources = this.client.searchResources((SearchFilter)filter, null, null, Boolean.valueOf(true), Boolean.valueOf(true));
        Assert.assertEquals((long)1L, (long)resources.getList().size());
        Assert.assertNotNull((Object)((Resource)resources.getList().get(0)).getAttribute());
        Assert.assertEquals((long)2L, (long)((Resource)resources.getList().get(0)).getAttribute().size());
        Assert.assertNotNull((Object)((Resource)resources.getList().get(0)).getData());
        Assert.assertEquals((Object)"pippo", (Object)((Resource)resources.getList().get(0)).getData().getData());
    }

    @Test
    public void testDefaultSecurityRules() {
        this.createDefaultCategory();
        RESTResource res = new RESTResource();
        res.setCategory(new RESTCategory("TestCategory1"));
        String timeid = Long.toString(System.currentTimeMillis());
        res.setName("rest_test_resource_" + timeid);
        Long id = this.client.insert(res);
        SecurityRuleList rules = this.client.getSecurityRules(id);
        Assert.assertNotNull((Object)rules.getList());
        Assert.assertEquals((long)1L, (long)rules.getList().size());
    }

    @Test
    public void testupdateSecurityRules() {
        this.createDefaultCategory();
        RESTResource res = new RESTResource();
        res.setCategory(new RESTCategory("TestCategory1"));
        String timeid = Long.toString(System.currentTimeMillis());
        res.setName("rest_test_resource_" + timeid);
        Long userId = this.createUser("u1_" + timeid, Role.USER, "---", new UserGroup[0]);
        UserGroup g1 = new UserGroup();
        g1.setGroupName("g1_" + timeid);
        Long groupId = this.adminClient.insertUserGroup(g1);
        Long id = this.client.insert(res);
        ArrayList<SecurityRule> ruleList = new ArrayList<SecurityRule>();
        SecurityRule rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(true);
        User user = new User();
        user.setId(userId);
        rule.setUser(user);
        ruleList.add(rule);
        rule = new SecurityRule();
        rule.setCanRead(true);
        rule.setCanWrite(false);
        UserGroup group = new UserGroup();
        group.setId(groupId);
        rule.setGroup(group);
        ruleList.add(rule);
        SecurityRuleList rules = new SecurityRuleList(ruleList);
        this.client.updateSecurityRules(id, rules);
        SecurityRuleList writtenRules = this.client.getSecurityRules(id);
        Assert.assertNotNull((Object)writtenRules.getList());
        Assert.assertEquals((long)2L, (long)rules.getList().size());
    }

    @Test
    public void testGetShortResource() {
        String DATA = "we wish you a merry xmas and a happy new year";
        UserGroup g1 = this.createUserGroup("g1xyz");
        this.createUser("u1", Role.USER, "u1", g1);
        this.createUser("u2", Role.USER, "u2", g1);
        this.createDefaultCategory();
        RESTResource r1 = this.buildResource("r1", "TestCategory1");
        GeoStoreClient c1 = this.createClient("u1", "u1");
        GeoStoreClient c2 = this.createClient("u2", "u2");
        long rId1 = c1.insert(r1);
        ShortResource res = this.client.getShortResource(rId1);
        Assert.assertEquals((Object)"r1", (Object)res.getName());
        ShortResource loaded = c1.getShortResource(rId1);
        Assert.assertEquals((Object)"r1", (Object)loaded.getName());
        Assert.assertTrue((boolean)loaded.isCanEdit());
        Assert.assertTrue((boolean)loaded.isCanDelete());
        try {
            loaded = c2.getShortResource(rId1);
            Assert.assertEquals((Object)"r1", (Object)loaded.getName());
        }
        catch (UniformInterfaceException ex) {
            Assert.assertEquals((Object)ClientResponse.Status.FORBIDDEN, (Object)ex.getResponse().getClientResponseStatus());
        }
        SecurityRule sr = new SecurityRule();
        sr.setGroup(g1);
        sr.setCanRead(true);
        sr.setCanWrite(false);
        SecurityRuleList srlist = new SecurityRuleList(Collections.singletonList(sr));
        c1.updateSecurityRules(Long.valueOf(rId1), srlist);
        ShortResource loaded2 = c2.getShortResource(rId1);
        Assert.assertEquals((Object)"r1", (Object)loaded2.getName());
        Assert.assertFalse((boolean)loaded2.isCanEdit());
    }

    private RESTResource buildResource(String name, String catName) {
        RESTResource res = new RESTResource();
        res.setCategory(new RESTCategory(catName));
        res.setName(name);
        return res;
    }

    protected Long createDefaultCategory() {
        Long catid = this.client.insert(new RESTCategory("TestCategory1"));
        Assert.assertNotNull((Object)catid);
        return catid;
    }
}

