/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.geostore.services.rest.auditing;

import it.geosolutions.geostore.services.rest.auditing.AuditingException;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class AuditingConfiguration {
    private static final Logger LOGGER = LogManager.getLogger(AuditingConfiguration.class);
    static final String CONFIGURATION_PATH = "GEOSTORE_AUDITING_CONF";
    static final String AUDIT_ENABLE = "auditing.enable";
    static final String TEMPLATES_DIRECTORY = "auditing.templates.directory";
    static final String OUTPUT_DIRECTORY = "auditing.output.directory";
    static final String TEMPLATES_VERSION = "auditing.templates.version";
    static final String MAX_RESQUEST_PER_FILE = "auditing.max.requests.per.file";
    static final String OUTPUT_FILES_EXTENSION = "auditing.output.files.extension";
    private final File configurationFile;
    private final long configurationFileChecksum;
    private final boolean auditEnable;
    private final String templatesDirectory;
    private final String outputDirectory;
    private final int templatesVersion;
    private final int maxRequestPerFile;
    private final String outputFilesExtension;

    AuditingConfiguration() {
        this(null, 0L);
    }

    AuditingConfiguration(File configurationFile, long configurationFileChecksum) {
        if (configurationFile == null) {
            this.configurationFile = AuditingConfiguration.findConfigurationFile();
            this.configurationFileChecksum = this.checksum(this.configurationFile);
        } else {
            this.configurationFile = configurationFile;
            this.configurationFileChecksum = configurationFileChecksum;
        }
        Properties properties = this.readProperties();
        this.auditEnable = Boolean.parseBoolean(AuditingConfiguration.getProperty(properties, AUDIT_ENABLE));
        this.templatesDirectory = AuditingConfiguration.getProperty(properties, TEMPLATES_DIRECTORY);
        this.outputDirectory = AuditingConfiguration.getProperty(properties, OUTPUT_DIRECTORY);
        this.templatesVersion = Integer.parseInt(AuditingConfiguration.getProperty(properties, TEMPLATES_VERSION));
        this.maxRequestPerFile = Integer.parseInt(AuditingConfiguration.getProperty(properties, MAX_RESQUEST_PER_FILE));
        this.outputFilesExtension = AuditingConfiguration.getProperty(properties, OUTPUT_FILES_EXTENSION);
    }

    static boolean configurationExists() {
        return AuditingConfiguration.findConfigurationFile() != null;
    }

    boolean isAuditEnable() {
        return this.auditEnable;
    }

    String getTemplatesDirectory() {
        return this.templatesDirectory;
    }

    String getOutputDirectory() {
        return this.outputDirectory;
    }

    int getTemplatesVersion() {
        return this.templatesVersion;
    }

    int getMaxRequestPerFile() {
        return this.maxRequestPerFile;
    }

    String getOutputFilesExtension() {
        return this.outputFilesExtension;
    }

    AuditingConfiguration checkForNewConfiguration() {
        File candidateConfigurationFile = AuditingConfiguration.findConfigurationFile();
        long candidateConfigurationFileChecksum = this.checksum(candidateConfigurationFile);
        if (this.configurationFile.compareTo(candidateConfigurationFile) != 0 || this.configurationFileChecksum != candidateConfigurationFileChecksum) {
            return new AuditingConfiguration(candidateConfigurationFile, candidateConfigurationFileChecksum);
        }
        return null;
    }

    private long checksum(File file) {
        try {
            return FileUtils.checksumCRC32((File)file);
        }
        catch (Exception exception) {
            throw new AuditingException(exception, "Error computing checksum of file '%s'.", file.getPath());
        }
    }

    private static File findConfigurationFile() {
        String configurationFilePath = System.getProperty(CONFIGURATION_PATH);
        if (configurationFilePath == null) {
            configurationFilePath = System.getenv(CONFIGURATION_PATH);
        }
        if (configurationFilePath == null) {
            LOGGER.warn("Could not found configuration path property.");
            return null;
        }
        File configurationFile = new File(configurationFilePath);
        if (!configurationFile.exists()) {
            throw new AuditingException("Configuration file '%s' does not exists.", configurationFile.getPath());
        }
        return configurationFile;
    }

    private Properties readProperties() {
        Properties properties;
        FileInputStream input = new FileInputStream(this.configurationFile);
        try {
            Properties properties2 = new Properties();
            properties2.load(input);
            input.close();
            properties = properties2;
        }
        catch (Throwable throwable) {
            try {
                try {
                    input.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception exception) {
                throw new AuditingException(exception, "Error reading properties from configuration file '%s'.", this.configurationFile.getPath());
            }
        }
        input.close();
        return properties;
    }

    private static String getProperty(Properties properties, String propertyName) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            throw new AuditingException("Missing configuration property '%s'.", propertyName);
        }
        return propertyValue;
    }
}

